/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.utils;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.graphql.generator.CodeGeneratorConstants;
import io.ballerina.graphql.generator.utils.GeneratorContext;
import io.ballerina.graphql.generator.utils.SrcFilePojo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class CodeGeneratorUtils {
    public static final MinutiaeList SINGLE_WS_MINUTIAE = CodeGeneratorUtils.getSingleWSMinutiae();
    private static final MinutiaeList SINGLE_END_OF_LINE_MINUTIAE = CodeGeneratorUtils.getEndOfLineMinutiae();

    public static String getDocumentName(File documentFile) {
        return documentFile.getName().split(".graphql")[0].replaceAll("[-+.^:,]", "").substring(0, 1).toUpperCase() + documentFile.getName().split(".graphql")[0].replaceAll("[-+.^:,]", "").substring(1);
    }

    public static String getClientFileName(File documentFile) {
        return documentFile.getName().split(".graphql")[0].replaceAll("[-+.^:,]", "_").concat("_") + "client.bal";
    }

    public static Path getAbsoluteFilePath(SrcFilePojo file, Path outputPath) {
        Path filePath;
        if (file.getModuleName().equals("root")) {
            File theDir = new File(outputPath.toString());
            if (!theDir.exists()) {
                theDir.mkdirs();
            }
            filePath = outputPath.resolve(file.getFileName());
        } else {
            File theDir = new File(String.valueOf(outputPath) + "/modules/" + file.getModuleName());
            if (!theDir.exists()) {
                theDir.mkdirs();
            }
            filePath = outputPath.resolve(String.valueOf(outputPath) + "/modules/" + file.getModuleName() + "/" + file.getFileName());
        }
        return filePath;
    }

    public static void writeFile(Path filePath, String content) throws IOException {
        try (FileWriter writer = new FileWriter(filePath.toString(), StandardCharsets.UTF_8);){
            writer.write(content);
        }
    }

    public static ImportDeclarationNode getImportDeclarationNode(String orgName, String moduleName) {
        IdentifierToken importKeyword = AbstractNodeFactory.createIdentifierToken((String)"import", (MinutiaeList)SINGLE_WS_MINUTIAE, (MinutiaeList)SINGLE_WS_MINUTIAE);
        IdentifierToken orgNameToken = AbstractNodeFactory.createIdentifierToken((String)orgName);
        IdentifierToken slashToken = AbstractNodeFactory.createIdentifierToken((String)"/");
        ImportOrgNameNode importOrgNameNode = NodeFactory.createImportOrgNameNode((Token)orgNameToken, (Token)slashToken);
        IdentifierToken moduleNameToken = AbstractNodeFactory.createIdentifierToken((String)moduleName);
        SeparatedNodeList moduleNodeList = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{moduleNameToken});
        IdentifierToken semicolon = AbstractNodeFactory.createIdentifierToken((String)";");
        return NodeFactory.createImportDeclarationNode((Token)importKeyword, (ImportOrgNameNode)importOrgNameNode, (SeparatedNodeList)moduleNodeList, null, (Token)semicolon);
    }

    private static MinutiaeList getSingleWSMinutiae() {
        Minutiae whitespace = AbstractNodeFactory.createWhitespaceMinutiae((String)" ");
        MinutiaeList leading = AbstractNodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{whitespace});
        return leading;
    }

    public static String getClientClassName(GeneratorContext generatorContext) {
        if (generatorContext == GeneratorContext.IDL_PLUGIN) {
            return "'client";
        }
        return "GraphqlClient";
    }

    public static String getRemoteFunctionSignatureReturnTypeName(String operationName) {
        return operationName.substring(0, 1).toUpperCase() + operationName.substring(1).concat("Response|graphql:ClientError");
    }

    public static String getRemoteFunctionBodyReturnTypeName(String operationName) {
        return "<" + operationName.substring(0, 1).toUpperCase() + operationName.substring(1) + "Response> check performDataBinding(graphqlResponse, " + operationName.substring(0, 1).toUpperCase() + operationName.substring(1) + "Response)";
    }

    public static MetadataNode getMetadataNode(String comment) {
        ArrayList<MarkdownDocumentationLineNode> docs = new ArrayList<MarkdownDocumentationLineNode>(CodeGeneratorUtils.createAPIDescriptionDoc(comment, false));
        MarkdownDocumentationNode authDocumentationNode = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(docs));
        return NodeFactory.createMetadataNode((Node)authDocumentationNode, (NodeList)AbstractNodeFactory.createEmptyNodeList());
    }

    private static MinutiaeList getEndOfLineMinutiae() {
        Minutiae endOfLineMinutiae = AbstractNodeFactory.createEndOfLineMinutiae((String)CodeGeneratorConstants.LINE_SEPARATOR);
        MinutiaeList leading = AbstractNodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{endOfLineMinutiae});
        return leading;
    }

    private static List<MarkdownDocumentationLineNode> createAPIDescriptionDoc(String description, boolean addExtraLine) {
        String[] descriptionLines = description.split("\n");
        ArrayList<MarkdownDocumentationLineNode> documentElements = new ArrayList<MarkdownDocumentationLineNode>();
        Token hashToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.HASH_TOKEN, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)SINGLE_WS_MINUTIAE);
        for (String line : descriptionLines) {
            MarkdownDocumentationLineNode documentationLineNode = NodeFactory.createMarkdownDocumentationLineNode((SyntaxKind)SyntaxKind.MARKDOWN_DOCUMENTATION_LINE, (Token)hashToken, (NodeList)AbstractNodeFactory.createNodeList((Node[])new Node[]{AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.DOCUMENTATION_DESCRIPTION, (String)line, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)SINGLE_END_OF_LINE_MINUTIAE)}));
            documentElements.add(documentationLineNode);
        }
        if (addExtraLine) {
            MarkdownDocumentationLineNode newLine = NodeFactory.createMarkdownDocumentationLineNode((SyntaxKind)SyntaxKind.MARKDOWN_DOCUMENTATION_LINE, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.HASH_TOKEN), (NodeList)AbstractNodeFactory.createEmptyNodeList());
            documentElements.add(newLine);
        }
        return documentElements;
    }

    public static NodeList<ImportDeclarationNode> generateImports() {
        ArrayList<ImportDeclarationNode> imports = new ArrayList<ImportDeclarationNode>();
        ImportDeclarationNode importForGraphql = CodeGeneratorUtils.getImportDeclarationNode("ballerina", "graphql");
        imports.add(importForGraphql);
        return AbstractNodeFactory.createNodeList(imports);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String escapeIdentifier(String identifier) {
        if (((String)identifier).matches("\\b[0-9]*\\b")) {
            return "'" + (String)identifier;
        }
        if (((String)identifier).matches("\\b[_a-zA-Z][_a-zA-Z0-9]*\\b")) {
            if (!CodeGeneratorConstants.BAL_KEYWORDS.stream().anyMatch(((String)identifier)::equals)) return identifier;
        }
        if (((String)identifier).equals("error")) {
            return "_error";
        }
        if (!((String)(identifier = ((String)identifier).replaceAll("([\\[\\]\\\\?!<>@#&~`*\\-=^+();:\\/\\_{}\\s|.$])", "\\\\$1"))).endsWith("?")) return "'" + (String)identifier;
        if (((String)identifier).charAt(((String)identifier).length() - 2) == '\\') {
            StringBuilder stringBuilder = new StringBuilder((String)identifier);
            stringBuilder.deleteCharAt(((String)identifier).length() - 2);
            identifier = stringBuilder.toString();
        }
        if (!CodeGeneratorConstants.BAL_KEYWORDS.stream().anyMatch(Optional.ofNullable(identifier).filter(sStr -> sStr.length() != 0).map(sStr -> sStr.substring(0, sStr.length() - 1)).orElse((String)identifier)::equals)) return identifier;
        return "'" + (String)identifier;
    }

    /*
     * WARNING - void declaration
     */
    public static String getValidName(String identifier) {
        if (!identifier.matches("\\b[0-9]*\\b")) {
            String[] split = identifier.split("([\\[\\]\\\\?!<>@#&~`*\\-=^+();:\\/\\_{}\\s|.$])");
            StringBuilder validName = new StringBuilder();
            for (String string : split) {
                void var6_6;
                if (string.isBlank()) continue;
                if (split.length > 1) {
                    String string2 = string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1).toLowerCase(Locale.ENGLISH);
                }
                validName.append((String)var6_6);
            }
            identifier = validName.toString();
        }
        return identifier.substring(0, 1).toLowerCase(Locale.ENGLISH) + identifier.substring(1);
    }
}

