/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.xslt;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.XmlUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BIterator;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlItem;
import io.ballerina.runtime.api.values.BXmlSequence;
import io.ballerina.stdlib.xslt.ModuleUtils;
import java.io.ByteArrayInputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.BasicTransformerFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XsltTransformer {
    private static final Logger log = LoggerFactory.getLogger(XsltTransformer.class);
    private static final PrintStream errStream = System.err;
    private static final String OPERATION = "Failed to perform XSL transformation: ";

    public static Object transform(BXml xmlInput, BXml xslInput, BMap<BString, Object> paramInput) {
        try {
            boolean unwrap = false;
            if (xmlInput.getNodeType() == XmlNodeType.SEQUENCE) {
                BXmlItem wrapper = ValueCreator.createXmlItem((QName)new QName("root"), (BXmlSequence)((BXmlSequence)xmlInput));
                xmlInput = wrapper;
                unwrap = true;
            }
            String input = xmlInput.toString();
            if (unwrap) {
                input = input.substring(6, input.length() - 7).trim();
            }
            String xsl = xslInput.toString();
            OMElement omXML = AXIOMUtil.stringToOM((String)input);
            OMElement omXSL = AXIOMUtil.stringToOM((String)xsl);
            StAXSource xmlSource = new StAXSource(omXML.getXMLStreamReader());
            StAXSource xslSource = new StAXSource(omXSL.getXMLStreamReader());
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            new BasicTransformerFactory();
            Transformer transformer = BasicTransformerFactory.newInstance().newTransformer(xslSource);
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            XsltTransformer.applyParameters(transformer, paramInput);
            transformer.transform(xmlSource, streamResult);
            String resultStr = stringWriter.getBuffer().toString().trim();
            if (log.isDebugEnabled()) {
                log.debug("Transformed result : {}", (Object)resultStr);
            }
            if (resultStr.isEmpty()) {
                return XsltTransformer.createTransformError("Failed to perform XSL transformation: empty result");
            }
            return XsltTransformer.parseToXML(resultStr);
        }
        catch (ClassCastException e) {
            return XsltTransformer.createTransformError("Failed to perform XSL transformation: invalid inputs(s)");
        }
        catch (Exception e) {
            String errMsg = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            return XsltTransformer.createTransformError(OPERATION + errMsg);
        }
    }

    private static void applyParameters(Transformer transformer, BMap<BString, Object> paramInput) throws Exception {
        BIterator iterator = paramInput.getIterator();
        while (iterator.hasNext()) {
            BArray next = (BArray)iterator.next();
            BString key = (BString)next.get(0L);
            Object value = next.get(1L) instanceof BXmlItem ? XsltTransformer.convertToDocument(next.get(1L).toString()) : next.get(1L);
            transformer.setParameter(key.getValue(), value);
        }
    }

    private static BXmlSequence parseToXML(String xmlStr) throws XMLStreamException {
        return (BXmlSequence)XmlUtils.parse((String)xmlStr);
    }

    private static BError createTransformError(String errMsg) {
        return ErrorCreator.createDistinctError((String)"TransformError", (Module)ModuleUtils.getModule(), (BString)StringUtils.fromString((String)errMsg));
    }

    public static Document convertToDocument(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }
}

