/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint.validators;

import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.constraint.Constants;
import io.ballerina.stdlib.constraint.ConstraintErrorInfo;
import io.ballerina.stdlib.constraint.InternalValidationException;
import io.ballerina.stdlib.constraint.validators.interfaces.DateValidator;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

public class DateConstraintValidator
implements DateValidator {
    private final List<ConstraintErrorInfo> failedConstraintsInfo;

    public DateConstraintValidator(List<ConstraintErrorInfo> failedConstraintsInfo) {
        this.failedConstraintsInfo = failedConstraintsInfo;
    }

    public void validate(BMap<BString, Object> constraints, Object fieldValue, String path, boolean isMemberValue) {
        LocalDate date = this.createLocalDate(fieldValue, path, this.getDateErrorMessage(constraints), isMemberValue);
        if (date == null) {
            return;
        }
        for (Map.Entry constraint : constraints.entrySet()) {
            this.validate(constraint, date, isMemberValue, this.failedConstraintsInfo, path);
        }
    }

    String getDateErrorMessage(BMap<BString, Object> constraints) {
        String message = null;
        for (Map.Entry constraint : constraints.entrySet()) {
            if (!((BString)constraint.getKey()).getValue().equals("message")) continue;
            message = ((BString)constraint.getValue()).getValue();
        }
        return message;
    }

    LocalDate createLocalDate(Object dateValue, String path, String message, boolean isMemberValue) {
        if (!(dateValue instanceof BMap)) {
            throw new InternalValidationException("Invalid field type found for constraint:Date");
        }
        BMap dateMap = (BMap)dateValue;
        Integer[] dateArray = this.getValidDateFields(dateMap, path, message, isMemberValue);
        if (dateArray.length == 3) {
            try {
                return LocalDate.of((int)dateArray[0], dateArray[1], (int)dateArray[2]);
            }
            catch (DateTimeException e) {
                this.failedConstraintsInfo.add(new ConstraintErrorInfo(path + ".day", message, "validDate", isMemberValue));
            }
        }
        return null;
    }

    Integer[] getValidDateFields(BMap date, String path, String message, boolean isMemberValue) {
        Integer year = this.getValidDateField(date.getIntValue(Constants.DATE_RECORD_YEAR_BSTRING), LocalDate.MIN.getYear(), LocalDate.MAX.getYear(), path, "year", message, isMemberValue);
        Integer month = this.getValidDateField(date.getIntValue(Constants.DATE_RECORD_MONTH_BSTRING), LocalDate.MIN.getMonthValue(), LocalDate.MAX.getMonthValue(), path, "month", message, isMemberValue);
        Integer day = this.getValidDateField(date.getIntValue(Constants.DATE_RECORD_DAY_BSTRING), LocalDate.MIN.getDayOfMonth(), LocalDate.MAX.getDayOfMonth(), path, "day", message, isMemberValue);
        if (year == null || month == null || day == null) {
            return new Integer[0];
        }
        return new Integer[]{year, month, day};
    }

    Integer getValidDateField(Long yearValue, int minValue, int maxValue, String path, String fieldName, String message, boolean isMemberValue) {
        try {
            int year = Math.toIntExact(yearValue);
            if (year < minValue || year > maxValue) {
                this.failedConstraintsInfo.add(new ConstraintErrorInfo(path + "." + fieldName, message, "validDate", isMemberValue));
                return null;
            }
            return year;
        }
        catch (ArithmeticException e) {
            this.failedConstraintsInfo.add(new ConstraintErrorInfo(path + "." + fieldName, message, "validDate", isMemberValue));
            return null;
        }
    }
}

