/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint.validators.interfaces;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BRegexpValue;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.constraint.Constants;
import io.ballerina.stdlib.constraint.ConstraintErrorInfo;
import java.util.List;
import java.util.Map;
import org.ballerinalang.langlib.regexp.Matches;

public interface PatternValidator {
    default public void validate(Map.Entry<BString, Object> constraint, Object fieldValue, boolean isMemberValue, List<ConstraintErrorInfo> failedConstraints, String path) {
        Object constraintValue = constraint.getValue();
        String message = null;
        if (constraintValue instanceof BMap) {
            message = ((BMap)constraintValue).getStringValue(Constants.MESSAGE).getValue();
            constraintValue = ((BMap)constraintValue).get((Object)Constants.VALUE);
        }
        if (constraint.getKey().getValue().equals("pattern") && !PatternValidator.validatePattern(fieldValue, constraintValue)) {
            failedConstraints.add(new ConstraintErrorInfo(path, message, "pattern", isMemberValue));
        }
    }

    public static boolean validatePattern(Object fieldValue, Object constraintValue) {
        return Matches.isFullMatch((BRegexpValue)((BRegexpValue)constraintValue), (BString)StringUtils.fromString((String)((String)fieldValue)));
    }
}

