/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.example.parameter;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.example.CommonUtils;
import io.ballerina.openapi.service.mapper.example.ExamplesAnnotationMapper;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class ParameterExampleMapper
extends ExamplesAnnotationMapper {
    Parameter parameterSchema;
    List<AnnotationAttachmentSymbol> annotations;
    List<OpenAPIMapperDiagnostic> diagnostics;
    String paramName;
    Location location;
    String paramTypeName;
    TypeSymbol paramType;

    ParameterExampleMapper(List<AnnotationAttachmentSymbol> annotations, Parameter parameterSchema, SemanticModel semanticModel, List<OpenAPIMapperDiagnostic> diagnostics, String paramName, Location location, String paramTypeName, TypeSymbol paramType) {
        super(semanticModel);
        this.parameterSchema = parameterSchema;
        this.annotations = annotations;
        this.diagnostics = diagnostics;
        this.paramName = paramName;
        this.location = location;
        this.paramTypeName = paramTypeName;
        this.paramType = paramType;
    }

    @Override
    public void setExample() {
        try {
            this.setExampleForInlineRecord();
            Optional<Object> exampleValue = this.extractExample(this.annotations);
            if (exampleValue.isEmpty()) {
                return;
            }
            this.parameterSchema.setExample(exampleValue.get());
        }
        catch (JsonProcessingException exception) {
            this.diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_134, this.location, "example", this.paramTypeName, this.paramName));
        }
    }

    private void setExampleForInlineRecord() {
        Schema schema = this.parameterSchema.getSchema();
        CommonUtils.setExampleForInlineRecordFields(this.paramType, schema, this.getSemanticModel(), this.diagnostics);
    }

    @Override
    public void setExamples() {
        try {
            Optional<Map<String, Example>> exampleValues = this.extractExamples(this.annotations);
            if (exampleValues.isEmpty()) {
                return;
            }
            this.parameterSchema.setExamples(exampleValues.get());
        }
        catch (JsonProcessingException exception) {
            this.diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_134, this.location, "examples", this.paramTypeName, this.paramName));
        }
    }
}

