/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.interceptor.pipeline;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.interceptor.model.RequestParameterInfo;
import io.ballerina.openapi.service.mapper.interceptor.pipeline.InterceptorPipeline;
import io.ballerina.openapi.service.mapper.interceptor.types.Interceptor;
import io.ballerina.openapi.service.mapper.interceptor.types.TargetResource;
import java.util.List;
import java.util.Objects;

public final class RequestParameterCollector {
    private RequestParameterCollector() {
    }

    public static RequestParameterInfo getRequestParameterInfo(InterceptorPipeline pipeline, ResourceMethodSymbol targetResource) {
        SemanticModel semanticModel = pipeline.getSemanticModel();
        Interceptor initReqInterceptor = pipeline.getInitReqInterceptor();
        List<OpenAPIMapperDiagnostic> diagnostics = pipeline.getDiagnostics();
        RequestParameterInfo requestParameterInfoFromInterceptors = new RequestParameterInfo(semanticModel);
        TargetResource target = new TargetResource(targetResource, semanticModel);
        if (Objects.isNull(initReqInterceptor)) {
            return requestParameterInfoFromInterceptors;
        }
        RequestParameterCollector.processReqInterceptor(initReqInterceptor, requestParameterInfoFromInterceptors, target, diagnostics);
        return requestParameterInfoFromInterceptors;
    }

    private static void processReqInterceptor(Interceptor interceptor, RequestParameterInfo requestParameterInfo, TargetResource targetResource, List<OpenAPIMapperDiagnostic> diagnostics) {
        if (Objects.isNull(interceptor)) {
            return;
        }
        if (interceptor.isContinueExecution() || !interceptor.isInvokable(targetResource)) {
            RequestParameterCollector.processReqInterceptor(interceptor.getNextInReqPath(), requestParameterInfo, targetResource, diagnostics);
            if (!interceptor.isInvokable(targetResource)) {
                return;
            }
        }
        requestParameterInfo.addReqParameters(interceptor.getParameterNodes(), diagnostics, false);
        if (interceptor.hasErrorReturn()) {
            RequestParameterCollector.updateErrorReturnTypeInReqPath(interceptor, requestParameterInfo, targetResource, diagnostics);
        }
    }

    private static void updateErrorReturnTypeInReqPath(Interceptor interceptor, RequestParameterInfo responseInfo, TargetResource targetResource, List<OpenAPIMapperDiagnostic> diagnostics) {
        Interceptor nextErrorInterceptor = interceptor.getNextInReqErrorPath();
        if (Objects.nonNull(nextErrorInterceptor) && nextErrorInterceptor.isInvokable(targetResource)) {
            RequestParameterCollector.processReqInterceptor(nextErrorInterceptor, responseInfo, targetResource, diagnostics);
        }
    }
}

