/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.interceptor.resource;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.openapi.service.mapper.interceptor.resource.PathSegments;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;

public final class ResourceMatcher {
    private ResourceMatcher() {
    }

    public static boolean match(ResourceMethodSymbol refResource, ResourceMethodSymbol targetResource, SemanticModel semanticModel) {
        String targetResourceMethod = MapperCommonUtils.unescapeIdentifier(targetResource.getName().orElse(""));
        String refResourceMethod = MapperCommonUtils.unescapeIdentifier(refResource.getName().orElse(""));
        if (refResourceMethod.equalsIgnoreCase("default") || targetResourceMethod.equalsIgnoreCase(refResourceMethod)) {
            return ResourceMatcher.matchResourcePath(refResource.resourcePath(), targetResource.resourcePath(), semanticModel);
        }
        return false;
    }

    private static boolean matchResourcePath(ResourcePath refResourcePath, ResourcePath targetResourcePath, SemanticModel semanticModel) {
        PathSegments targetPathSegments = PathSegments.build(targetResourcePath);
        PathSegments refPathSegments = PathSegments.build(refResourcePath);
        return targetPathSegments.matches(refPathSegments, semanticModel);
    }
}

