/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.model;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.openapi.service.mapper.model.ServiceContractType;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

public class ModuleMemberVisitor
extends NodeVisitor {
    Set<TypeDefinitionNode> typeDefinitionNodes = new LinkedHashSet<TypeDefinitionNode>();
    Set<ListenerDeclarationNode> listenerDeclarationNodes = new LinkedHashSet<ListenerDeclarationNode>();
    Set<ClassDefinitionNode> interceptorServiceClassNodes = new LinkedHashSet<ClassDefinitionNode>();
    Set<ServiceContractType> serviceContractTypeNodes = new LinkedHashSet<ServiceContractType>();
    SemanticModel semanticModel;

    public ModuleMemberVisitor(SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
    }

    public void visit(TypeDefinitionNode typeDefinitionNode) {
        this.typeDefinitionNodes.add(typeDefinitionNode);
        Node descriptorNode = MapperCommonUtils.getTypeDescriptor(typeDefinitionNode);
        if (descriptorNode.kind().equals((Object)SyntaxKind.OBJECT_TYPE_DESC) && MapperCommonUtils.isHttpServiceContract(descriptorNode, this.semanticModel)) {
            this.serviceContractTypeNodes.add(new ServiceContractType(typeDefinitionNode));
        }
    }

    public void visit(ListenerDeclarationNode listenerDeclarationNode) {
        this.listenerDeclarationNodes.add(listenerDeclarationNode);
    }

    public void visit(ClassDefinitionNode classDefinitionNode) {
        this.interceptorServiceClassNodes.add(classDefinitionNode);
    }

    public Set<ListenerDeclarationNode> getListenerDeclarationNodes() {
        return this.listenerDeclarationNodes;
    }

    public Optional<TypeDefinitionNode> getTypeDefinitionNode(String typeName) {
        for (TypeDefinitionNode typeDefinitionNode : this.typeDefinitionNodes) {
            if (!MapperCommonUtils.unescapeIdentifier(typeDefinitionNode.typeName().text()).equals(typeName)) continue;
            return Optional.of(typeDefinitionNode);
        }
        return Optional.empty();
    }

    public Optional<ClassDefinitionNode> getInterceptorServiceClassNode(String typeName) {
        for (ClassDefinitionNode classDefinitionNode : this.interceptorServiceClassNodes) {
            if (!MapperCommonUtils.unescapeIdentifier(classDefinitionNode.className().text()).equals(typeName)) continue;
            return Optional.of(classDefinitionNode);
        }
        return Optional.empty();
    }

    public Set<ServiceContractType> getServiceContractTypeNodes() {
        return this.serviceContractTypeNodes;
    }
}

