/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.model;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.Objects;

public class OperationInventory {
    private Operation operation = new Operation();
    private String path;
    private String httpOperation;

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = !path.startsWith("/") ? "/" + path : path;
    }

    public String getHttpOperation() {
        return this.httpOperation;
    }

    public void setHttpOperation(String httpOperation) {
        this.httpOperation = httpOperation;
    }

    public boolean hasDataBinding() {
        return Objects.nonNull(this.operation.getRequestBody()) || Objects.nonNull(this.operation.getParameters());
    }

    public void setParameter(Parameter parameter) {
        this.operation.addParametersItem(parameter);
    }

    public void setRequestBody(RequestBody requestBody) {
        if (Objects.isNull(this.operation.getRequestBody())) {
            this.operation.setRequestBody(requestBody);
        }
    }

    public void overrideRequestBody(RequestBody requestBody) {
        this.operation.setRequestBody(requestBody);
    }

    public void setApiResponses(ApiResponses apiResponses) {
        this.operation.setResponses(apiResponses);
    }

    public void setOperationId(String operationId) {
        this.operation.setOperationId(operationId);
    }

    public void setSummary(String summary) {
        this.operation.setSummary(summary);
    }
}

