/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.parameter;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.openapi.service.mapper.model.OperationInventory;
import io.ballerina.openapi.service.mapper.parameter.ParameterMapperException;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractParameterMapper {
    final OperationInventory operationInventory;

    abstract Parameter getParameterSchema() throws ParameterMapperException;

    protected AbstractParameterMapper(OperationInventory operationInventory) {
        this.operationInventory = operationInventory;
    }

    public List<Parameter> getParameterSchemaList() throws ParameterMapperException {
        Parameter parameter = this.getParameterSchema();
        if (Objects.nonNull(parameter)) {
            return List.of(parameter);
        }
        return List.of();
    }

    public void setParameter() throws ParameterMapperException {
        List<Parameter> parameterList = this.getParameterSchemaList();
        parameterList.forEach(this.operationInventory::setParameter);
    }

    static Object getDefaultValue(DefaultableParameterNode parameterNode, SemanticModel semanticModel) {
        Node defaultValueExpression = parameterNode.expression();
        Optional symbol = semanticModel.symbol(defaultValueExpression);
        Optional<Object> constantValues = MapperCommonUtils.getConstantValues(symbol);
        if (constantValues.isPresent()) {
            return constantValues.get();
        }
        if (MapperCommonUtils.isNotSimpleValueLiteralKind(defaultValueExpression.kind())) {
            return null;
        }
        return MapperCommonUtils.parseBalSimpleLiteral(defaultValueExpression.toString().trim());
    }

    static boolean hasObjectType(SemanticModel semanticModel, TypeSymbol parameterType) {
        MapTypeSymbol mapOfAnydata = semanticModel.types().builder().MAP_TYPE.withTypeParam(semanticModel.types().ANYDATA).build();
        ArrayTypeSymbol arrayOfMapOfAnydata = semanticModel.types().builder().ARRAY_TYPE.withType((TypeSymbol)mapOfAnydata).build();
        return parameterType.subtypeOf((TypeSymbol)semanticModel.types().builder().UNION_TYPE.withMemberTypes(new TypeSymbol[]{mapOfAnydata, arrayOfMapOfAnydata, semanticModel.types().NIL}).build());
    }
}

