/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.type.extension;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.service.mapper.type.extension.BallerinaPackage;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class BallerinaTypeExtensioner {
    private static final String X_BALLERINA_TYPE = "x-ballerina-type";

    private BallerinaTypeExtensioner() {
    }

    public static void addExtension(Schema schema, TypeSymbol typeSymbol) {
        BallerinaTypeExtensioner.getBallerinaPackage(typeSymbol).ifPresent(ballerinaPackage -> schema.addExtension(X_BALLERINA_TYPE, ballerinaPackage));
    }

    public static void removeExtensions(OpenAPI openAPI) {
        BallerinaTypeExtensioner.removeExtensionsFromOpenAPI(openAPI, (extensions, orgName, moduleName) -> true);
    }

    public static void removeCurrentModuleTypeExtensions(OpenAPI openAPI, ModuleID moduleID) {
        String orgName = moduleID.orgName();
        String moduleName = moduleID.moduleName();
        BallerinaTypeExtensioner.removeExtensionsFromOpenAPI(openAPI, (extensions, org, mod) -> BallerinaTypeExtensioner.fromSameModule(extensions, orgName, moduleName));
    }

    private static void removeExtensionsFromOpenAPI(OpenAPI openAPI, ExtensionRemovalCondition condition) {
        Components components = openAPI.getComponents();
        if (Objects.isNull(components)) {
            return;
        }
        BallerinaTypeExtensioner.removeExtensionFromComponents(components, condition);
    }

    public static void removeExtensionFromComponents(Components components) {
        BallerinaTypeExtensioner.removeExtensionFromComponents(components, (extensions, orgName, moduleName) -> true);
    }

    private static void removeExtensionFromComponents(Components components, ExtensionRemovalCondition condition) {
        Map schemas = components.getSchemas();
        if (Objects.isNull(schemas)) {
            return;
        }
        schemas.forEach((key, schema) -> BallerinaTypeExtensioner.removeExtensionFromSchema(schema, condition));
    }

    public static void removeExtensionFromSchema(Schema schema) {
        BallerinaTypeExtensioner.removeExtensionFromSchema(schema, (extensions, orgName, moduleName) -> true);
    }

    private static void removeExtensionFromSchema(Schema schema, ExtensionRemovalCondition condition) {
        List anyOfSchemas;
        List oneOfSchemas;
        List allOfSchemas;
        Map properties;
        Map extensions = schema.getExtensions();
        if (Objects.nonNull(extensions) && condition.shouldRemove(extensions, null, null)) {
            extensions.remove(X_BALLERINA_TYPE);
        }
        if (Objects.nonNull(properties = schema.getProperties())) {
            properties.values().forEach(value -> BallerinaTypeExtensioner.removeExtensionFromSchema(value, condition));
        }
        if (Objects.nonNull(allOfSchemas = schema.getAllOf())) {
            allOfSchemas.forEach(value -> BallerinaTypeExtensioner.removeExtensionFromSchema(value, condition));
        }
        if (Objects.nonNull(oneOfSchemas = schema.getOneOf())) {
            oneOfSchemas.forEach(value -> BallerinaTypeExtensioner.removeExtensionFromSchema(value, condition));
        }
        if (Objects.nonNull(anyOfSchemas = schema.getAnyOf())) {
            anyOfSchemas.forEach(value -> BallerinaTypeExtensioner.removeExtensionFromSchema(value, condition));
        }
    }

    private static boolean fromSameModule(Map<?, ?> extensions, String orgName, String moduleName) {
        BallerinaPackage ballerinaPkg;
        Object obj = extensions.get(X_BALLERINA_TYPE);
        return obj instanceof BallerinaPackage && orgName.equals((ballerinaPkg = (BallerinaPackage)obj).orgName()) && moduleName.equals(ballerinaPkg.moduleName());
    }

    public static Optional<BallerinaPackage> getExtension(Schema schema) {
        Map extensions = schema.getExtensions();
        if (Objects.isNull(extensions)) {
            return Optional.empty();
        }
        Object ballerinaExt = extensions.get(X_BALLERINA_TYPE);
        if (Objects.isNull(ballerinaExt) || !(ballerinaExt instanceof BallerinaPackage)) {
            return Optional.empty();
        }
        BallerinaPackage ballerinaPkg = (BallerinaPackage)ballerinaExt;
        return Optional.of(ballerinaPkg);
    }

    static Optional<BallerinaPackage> getBallerinaPackage(TypeSymbol typeSymbol) {
        Optional module = typeSymbol.getModule();
        if (module.isEmpty()) {
            return Optional.empty();
        }
        ModuleID moduleID = ((ModuleSymbol)module.get()).id();
        return Optional.of(new BallerinaPackage(moduleID.orgName(), moduleID.packageName(), moduleID.moduleName(), moduleID.version(), moduleID.modulePrefix(), typeSymbol.getName().orElse(null)));
    }

    @FunctionalInterface
    private static interface ExtensionRemovalCondition {
        public boolean shouldRemove(Map<?, ?> var1, String var2, String var3);
    }
}

