/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;

public final class CodegenUtils {
    private static final String LINE_SEPARATOR = System.lineSeparator();

    public static Path getImplPath(String pkg, Path srcPath) {
        return pkg == null || pkg.isEmpty() ? srcPath : srcPath.getParent();
    }

    public static void writeFile(Path filePath, String content) throws IOException {
        try (FileWriter writer = new FileWriter(filePath.toString(), StandardCharsets.UTF_8);){
            writer.write(content);
        }
    }

    public static <T extends InputStream, E extends OutputStream> void copyContent(T inputStream, E outStream) throws IOException {
        byte[] data = new byte[1024];
        int bytesRead = inputStream.read(data);
        while (bytesRead != -1) {
            outStream.write(data, 0, bytesRead);
            bytesRead = inputStream.read(data);
        }
    }

    public static String resolveContractFileName(Path outPath, String openApiName, Boolean isJson) {
        File[] listFiles;
        if (outPath != null && Files.exists(outPath, new LinkOption[0]) && (listFiles = new File(String.valueOf(outPath)).listFiles()) != null) {
            openApiName = CodegenUtils.checkAvailabilityOfGivenName(openApiName, listFiles, isJson);
        }
        return openApiName;
    }

    private static String checkAvailabilityOfGivenName(String openApiName, File[] listFiles, Boolean isJson) {
        for (File file : listFiles) {
            String userInput;
            if (System.console() == null || !file.getName().equals(openApiName) || Objects.equals((userInput = System.console().readLine("There is already a file named ' " + file.getName() + "' in the target location. Do you want to overwrite the file? [y/N] ", new Object[0])).toLowerCase(Locale.ENGLISH), "y")) continue;
            openApiName = CodegenUtils.setGeneratedFileName(listFiles, openApiName, isJson);
        }
        return openApiName;
    }

    private static String setGeneratedFileName(File[] listFiles, String fileName, boolean isJson) {
        int duplicateCount = 0;
        for (File listFile : listFiles) {
            String listFileName = listFile.getName();
            if (!listFileName.contains(".") || listFileName.split("\\.").length < 2 || !listFileName.split("\\.")[0].equals(fileName.split("\\.")[0])) continue;
            ++duplicateCount;
        }
        if (isJson) {
            return fileName.split("\\.")[0] + "." + duplicateCount + ".json";
        }
        return fileName.split("\\.")[0] + "." + duplicateCount + ".yaml";
    }
}

