/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli;

import io.ballerina.cli.task.Task;
import io.ballerina.projects.Project;
import java.util.LinkedList;
import java.util.List;

public class TaskExecutor {
    private final List<Task> tasks = new LinkedList<Task>();

    private TaskExecutor() {
    }

    public void executeTasks(Project project) {
        for (Task task : this.tasks) {
            task.execute(project);
        }
    }

    public static class TaskBuilder {
        private final TaskExecutor taskExecutor = new TaskExecutor();

        public TaskBuilder addTask(Task task) {
            this.taskExecutor.tasks.add(task);
            return this;
        }

        public TaskBuilder addTask(Task task, boolean skip) {
            if (!skip) {
                this.taskExecutor.tasks.add(task);
            }
            return this;
        }

        public TaskExecutor build() {
            return this.taskExecutor;
        }
    }
}

