/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.projects.util.ProjectUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import picocli.CommandLine;

@CommandLine.Command(name="add", description={"Add a new Ballerina module to the current package"})
public class AddCommand
implements BLauncherCmd {
    private final Path userDir;
    private final PrintStream errStream;
    private final boolean exitWhenFinish;
    private static final String TEST_FILE_SUFFIX = "_test.bal";
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--template", "-t"})
    private String template = "lib";

    public AddCommand() {
        this.userDir = Path.of(System.getProperty("user.dir"), new String[0]);
        this.errStream = System.err;
        this.exitWhenFinish = true;
        CommandUtil.initJarFs();
    }

    public AddCommand(Path userDir, PrintStream errStream, boolean exitWhenFinish) {
        this.userDir = userDir;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        CommandUtil.initJarFs();
    }

    @Override
    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("add");
            this.errStream.println(commandUsageInfo);
            return;
        }
        Path projectPath = ProjectUtils.findProjectRoot((Path)this.userDir);
        if (null == projectPath) {
            CommandUtil.printError(this.errStream, "not a Ballerina project (or any parent up to mount point)\nYou should run this command inside a Ballerina project.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (null == this.argList) {
            CommandUtil.printError(this.errStream, "module name is not provided.", "bal add <module-name> [-t|--template <template-name>]", true);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (1 != this.argList.size()) {
            CommandUtil.printError(this.errStream, "too many arguments", "bal add <module-name>", true);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String moduleName = this.argList.get(0);
        boolean matches = ProjectUtils.validateModuleName((String)moduleName);
        if (!matches) {
            CommandUtil.printError(this.errStream, "invalid module name : '" + moduleName + "' :\nModule name can only contain alphanumerics, underscores and periods.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!ProjectUtils.validateNameLength((String)moduleName)) {
            CommandUtil.printError(this.errStream, "invalid module name : '" + moduleName + "' :\nMaximum length of module name is 256 characters.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!ProjectUtils.validateUnderscoresOfName((String)moduleName)) {
            CommandUtil.printError(this.errStream, "invalid module name : '" + moduleName + "' :\n" + ProjectUtils.getValidateUnderscoreError((String)moduleName, (String)"Module"), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!ProjectUtils.validateInitialNumericsOfName((String)moduleName)) {
            CommandUtil.printError(this.errStream, "invalid module name : '" + moduleName + "' :\nModule name cannot have initial numeric characters.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (ProjectUtils.isModuleExist((Path)projectPath, (String)moduleName)) {
            CommandUtil.printError(this.errStream, "a module already exists with the given name : '" + moduleName + "' :\nExisting module path " + String.valueOf(projectPath.resolve("modules").resolve(moduleName)), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!this.template.equalsIgnoreCase("service") && !this.template.equalsIgnoreCase("lib")) {
            CommandUtil.printError(this.errStream, "unsupported template provided. run 'bal add --help' to see available templates.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        try {
            Path moduleDirPath = projectPath.resolve("modules");
            if (!Files.exists(moduleDirPath, new LinkOption[0])) {
                Files.createDirectory(moduleDirPath, new FileAttribute[0]);
            }
            this.createModule(projectPath, moduleName, this.template);
        }
        catch (AccessDeniedException e) {
            CommandUtil.printError(this.errStream, "error occurred while creating module : Insufficient Permission" + e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        catch (IOException | URISyntaxException e) {
            CommandUtil.printError(this.errStream, "error occurred while creating module : " + e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        this.errStream.println("Added new Ballerina module at " + String.valueOf(this.userDir.relativize(projectPath.resolve("modules").resolve(moduleName))));
    }

    @Override
    public String getName() {
        return "add";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("add"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("  bal add <module-name> [-t|--template <template-name>]\n");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private void createModule(Path projectPath, String moduleName, String template) throws IOException, URISyntaxException {
        Path modulePath = projectPath.resolve("modules").resolve(moduleName);
        Files.createDirectories(modulePath, new FileAttribute[0]);
        CommandUtil.applyTemplate(modulePath, template, false);
        this.modifyTestFileName(projectPath, moduleName, template);
    }

    private void modifyTestFileName(Path projectPath, String moduleName, String template) throws IOException {
        String validModuleName = ProjectUtils.guessModuleName((String)moduleName);
        String templateLowerCase = template.toLowerCase(Locale.getDefault());
        Path modulePath = projectPath.resolve("modules").resolve(moduleName);
        Path source = modulePath.resolve(templateLowerCase + ".bal");
        Files.move(source, source.resolveSibling(validModuleName + ".bal"), StandardCopyOption.REPLACE_EXISTING);
        Path testSource = modulePath.resolve("tests").resolve(templateLowerCase + TEST_FILE_SUFFIX);
        Files.move(testSource, testSource.resolveSibling(validModuleName + TEST_FILE_SUFFIX), StandardCopyOption.REPLACE_EXISTING);
    }
}

