/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.launcher.BLauncherException;
import io.ballerina.projects.util.FileUtils;
import io.ballerina.projects.util.ProjectUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="new", description={"Create a new Ballerina package"})
public class NewCommand
implements BLauncherCmd {
    private final PrintStream errStream;
    private final boolean exitWhenFinish;
    Path homeCache = RepoUtils.createAndGetHomeReposPath();
    @CommandLine.Parameters
    public List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--template", "-t"}, description={"Acceptable values: [main, service, lib] default: default"})
    public String template = "default";

    public NewCommand() {
        this.errStream = System.err;
        this.exitWhenFinish = true;
        CommandUtil.initJarFs();
    }

    public NewCommand(PrintStream errStream, boolean exitWhenFinish) {
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        CommandUtil.initJarFs();
    }

    public NewCommand(PrintStream errStream, boolean exitWhenFinish, Path customHomeCache) {
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        CommandUtil.initJarFs();
        this.homeCache = customHomeCache;
    }

    @Override
    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("new");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (null == this.argList) {
            CommandUtil.printError(this.errStream, "project path is not provided.", "bal new <project-path>", true);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (1 != this.argList.size()) {
            CommandUtil.printError(this.errStream, "too many arguments", "bal new <project-path>", true);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        Path packagePath = Path.of(this.argList.get(0), new String[0]);
        Path currentDir = Path.of(System.getProperty("user.dir"), new String[0]);
        if (!packagePath.isAbsolute()) {
            packagePath = Path.of(currentDir.toString(), packagePath.toString()).normalize();
        }
        ArrayList<Path> filesInDir = new ArrayList();
        CommandUtil.setPrintStream(this.errStream);
        Optional<Path> optionalPackageName = Optional.ofNullable(packagePath.getFileName());
        if (optionalPackageName.isEmpty()) {
            CommandUtil.printError(this.errStream, "package name could not be derived", "bal new <project-path>", true);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String packageName = optionalPackageName.get().toString();
        boolean balFilesExist = false;
        if (Files.exists(packagePath, new LinkOption[0])) {
            if (ProjectUtils.isBallerinaProject((Path)packagePath)) {
                CommandUtil.printError(this.errStream, "directory is already a Ballerina project.", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            if (FileUtils.checkBallerinaTomlInExistingDir((Path)packagePath)) {
                CommandUtil.printError(this.errStream, "directory already contains a Ballerina project", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            String packageFiles = CommandUtil.checkPackageFilesExists(packagePath);
            if (!packageFiles.isEmpty() && !this.template.equals("default")) {
                CommandUtil.printError(this.errStream, "existing " + packageFiles.substring(0, packageFiles.length() - 2) + " file/directory(s) were found. Please use a different directory or remove existing files.", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            try {
                balFilesExist = CommandUtil.balFilesExists(packagePath);
                if (balFilesExist && !this.template.equals("default")) {
                    CommandUtil.printError(this.errStream, "existing .bal files found. Please use a different directory or remove existing files.", null, false);
                    CommandUtil.exitError(this.exitWhenFinish);
                    return;
                }
            }
            catch (IOException e) {
                CommandUtil.printError(this.errStream, "error occurred while looking for existing package files: " + e.getMessage(), null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            Path packageDirectory = packagePath;
            filesInDir = FileUtils.getFilesInDirectory((Path)packageDirectory);
        } else {
            Path parent = packagePath.getParent();
            if (parent == null) {
                CommandUtil.printError(this.errStream, "destination '" + String.valueOf(packagePath) + "' does not exist.", "bal new <project-path>", true);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            if (!Files.exists(parent, new LinkOption[0])) {
                CommandUtil.printError(this.errStream, "destination '" + String.valueOf(parent) + "' does not exist.", "bal new <project-path>", true);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            if (ProjectUtils.isBallerinaProject((Path)parent)) {
                CommandUtil.printError(this.errStream, "directory is already within the Ballerina project '" + String.valueOf(parent) + "'", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
        }
        Path projectRoot = ProjectUtils.findProjectRoot((Path)packagePath);
        if (projectRoot != null) {
            CommandUtil.printError(this.errStream, "directory is already within the Ballerina project '" + String.valueOf(projectRoot) + "'", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!ProjectUtils.validateNameLength((String)packageName)) {
            CommandUtil.printError(this.errStream, "invalid package name : '" + packageName + "' :\nMaximum length of package name is 256 characters.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!ProjectUtils.validatePackageName((String)packageName)) {
            packageName = ProjectUtils.guessPkgName((String)packageName, (String)this.template);
            this.errStream.println("Package name is derived as '" + packageName + "'. Edit the Ballerina.toml to change it.");
            this.errStream.println();
        }
        try {
            if (CommandUtil.getTemplates().contains(this.template)) {
                String existingFiles;
                if (Files.exists(packagePath, new LinkOption[0]) && !(existingFiles = CommandUtil.checkTemplateFilesExists(this.template, packagePath)).isEmpty()) {
                    CommandUtil.printError(this.errStream, "existing " + existingFiles.substring(0, existingFiles.length() - 2) + " file/directory(s) were found. Please use a different directory or remove existing files.", null, false);
                    CommandUtil.exitError(this.exitWhenFinish);
                    return;
                }
                CommandUtil.initPackageByTemplate(packagePath, packageName, this.template, balFilesExist);
            } else {
                Path balaCache = this.homeCache.resolve("repositories").resolve("central.ballerina.io").resolve("bala");
                CommandUtil.initPackageFromCentral(balaCache, packagePath, packageName, this.template, filesInDir);
            }
        }
        catch (AccessDeniedException e) {
            CommandUtil.printError(this.errStream, "error occurred while creating project : Insufficient Permission : " + e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
        }
        catch (BLauncherException e) {
            if (Files.exists(packagePath, new LinkOption[0])) {
                try {
                    Files.delete(packagePath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            CommandUtil.printError(this.errStream, e.getDetailedMessages().get(0), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
        }
        catch (IOException | URISyntaxException e) {
            CommandUtil.printError(this.errStream, "error occurred while creating project : " + e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
        }
        if (Files.exists(packagePath, new LinkOption[0])) {
            if (!Path.of(this.argList.get(0), new String[0]).isAbsolute()) {
                packagePath = Path.of(this.argList.get(0), new String[0]);
            }
            this.errStream.println("Created new package '" + packageName + "' at " + String.valueOf(packagePath) + ".");
        }
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    @Override
    public String getName() {
        return "new";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("new"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("  bal new <project-path> \n");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

