/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.TaskExecutor;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.task.CleanTargetDirTask;
import io.ballerina.cli.task.CompileTask;
import io.ballerina.cli.task.CreateBalaTask;
import io.ballerina.cli.task.DumpBuildTimeTask;
import io.ballerina.cli.task.ResolveMavenDependenciesTask;
import io.ballerina.cli.task.RunBuildToolsTask;
import io.ballerina.cli.utils.BuildTime;
import io.ballerina.cli.utils.FileUtils;
import io.ballerina.projects.BallerinaToml;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.internal.ManifestBuilder;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="pack", description={"Create distribution format of the current package"})
public class PackCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private final boolean exitWhenFinish;
    private final boolean skipCopyLibsFromDist;
    @CommandLine.Option(names={"--offline"}, description={"Build/Compile offline without downloading dependencies."})
    private Boolean offline;
    @CommandLine.Parameters(arity="0..1")
    private final Path projectPath;
    @CommandLine.Option(names={"--dump-bir"}, hidden=true)
    private boolean dumpBIR;
    @CommandLine.Option(names={"--dump-bir-file"}, hidden=true)
    private Boolean dumpBIRFile;
    @CommandLine.Option(names={"--dump-graph"}, hidden=true)
    private boolean dumpGraph;
    @CommandLine.Option(names={"--dump-raw-graphs"}, hidden=true)
    private boolean dumpRawGraphs;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental language features."})
    private boolean experimentalFlag;
    @CommandLine.Option(names={"--debug"}, description={"run tests in remote debugging mode"})
    private String debugPort;
    @CommandLine.Option(names={"--dump-build-time"}, hidden=true, description={"calculate and dump build time"})
    private Boolean dumpBuildTime;
    @CommandLine.Option(names={"--sticky"}, description={"stick to exact versions locked (if exists)"})
    private Boolean sticky;
    @CommandLine.Option(names={"--target-dir"}, description={"target directory path"})
    private Path targetDir;
    @CommandLine.Option(names={"--generate-config-schema"}, hidden=true)
    private Boolean configSchemaGen;
    @CommandLine.Option(names={"--enable-cache"}, description={"enable caches for the compilation"}, hidden=true)
    private Boolean enableCache;
    @CommandLine.Option(names={"--disable-syntax-tree-caching"}, hidden=true, description={"disable syntax tree caching for source files"}, defaultValue="false")
    private Boolean disableSyntaxTreeCaching;
    @CommandLine.Option(names={"--show-dependency-diagnostics"}, description={"Show the diagnostics generated by the dependencies"})
    private Boolean showDependencyDiagnostics;
    @CommandLine.Option(names={"--optimize-dependency-compilation"}, hidden=true, description={"experimental memory optimization for large projects"})
    private Boolean optimizeDependencyCompilation;
    @CommandLine.Option(names={"--locking-mode"}, hidden=true, description={"allow passing the package locking mode."})
    private String lockingMode;

    public PackCommand() {
        this.projectPath = Path.of(System.getProperty("user.dir"), new String[0]);
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = true;
        this.skipCopyLibsFromDist = false;
    }

    PackCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, boolean skipCopyLibsFromDist) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.skipCopyLibsFromDist = skipCopyLibsFromDist;
        this.offline = true;
    }

    PackCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, boolean skipCopyLibsFromDist, Boolean optimizeDependencyCompilation) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.skipCopyLibsFromDist = skipCopyLibsFromDist;
        this.optimizeDependencyCompilation = optimizeDependencyCompilation;
        this.offline = true;
    }

    PackCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, boolean skipCopyLibsFromDist, Path targetDir) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.skipCopyLibsFromDist = skipCopyLibsFromDist;
        this.targetDir = targetDir;
        this.offline = true;
    }

    @Override
    public void execute() {
        BuildProject project;
        long start = 0L;
        boolean isSingleFileBuild = false;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("pack");
            this.errStream.println(commandUsageInfo);
            return;
        }
        BuildOptions buildOptions = this.constructBuildOptions();
        if (FileUtils.hasExtension(this.projectPath)) {
            CommandUtil.printError(this.errStream, "bal pack can only be used with a Ballerina package.", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        try {
            if (buildOptions.dumpBuildTime()) {
                BuildTime.getInstance().timestamp = start = System.currentTimeMillis();
            }
            project = BuildProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
            if (buildOptions.dumpBuildTime()) {
                BuildTime.getInstance().projectLoadDuration = System.currentTimeMillis() - start;
            }
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.errStream, e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (((BallerinaToml)project.currentPackage().ballerinaToml().get()).tomlDocument().toml().getTable("package").isEmpty()) {
            CommandUtil.printError(this.errStream, "'package' information not found in Ballerina.toml", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        TomlTableNode pkgNode = (TomlTableNode)((BallerinaToml)project.currentPackage().ballerinaToml().get()).tomlDocument().toml().rootNode().entries().get("package");
        if (pkgNode == null || pkgNode.kind() == TomlType.NONE) {
            CommandUtil.printError(this.errStream, "'package' information not found in Ballerina.toml", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        ArrayList<String> pkgErrors = new ArrayList<String>();
        if ("".equals(ManifestBuilder.getStringValueFromTomlTableNode((TomlTableNode)pkgNode, (String)"org", (String)""))) {
            pkgErrors.add("'org'");
        }
        if ("".equals(ManifestBuilder.getStringValueFromTomlTableNode((TomlTableNode)pkgNode, (String)"name", (String)""))) {
            pkgErrors.add("'name'");
        }
        if ("".equals(ManifestBuilder.getStringValueFromTomlTableNode((TomlTableNode)pkgNode, (String)"version", (String)""))) {
            pkgErrors.add("'version'");
        }
        if (!pkgErrors.isEmpty()) {
            if (pkgErrors.size() == 1) {
                CommandUtil.printError(this.errStream, "to build a package " + (String)pkgErrors.get(0) + " field of the package is required in Ballerina.toml", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            String pkgErrorsString = pkgErrors.size() == 2 ? (String)pkgErrors.get(0) + " and " + (String)pkgErrors.get(1) : (String)pkgErrors.get(0) + ", " + (String)pkgErrors.get(1) + " and " + (String)pkgErrors.get(2);
            CommandUtil.printError(this.errStream, "to build a package " + pkgErrorsString + " fields of the package are required in Ballerina.toml", null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!project.buildOptions().skipTests() && this.debugPort != null) {
            System.setProperty("debug", this.debugPort);
        }
        RepoUtils.readSettings();
        boolean isPackageModified = ProjectUtils.isProjectUpdated((Project)project);
        Optional<Diagnostic> deprecatedDocWarning = ProjectUtils.getProjectLoadingDiagnostic().stream().filter(diagnostic -> diagnostic.diagnosticInfo().code().equals(ProjectDiagnosticErrorCode.DEPRECATED_DOC_FILE.diagnosticId())).findAny();
        deprecatedDocWarning.ifPresent(this.errStream::println);
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CleanTargetDirTask(isPackageModified, buildOptions.enableCache()), isSingleFileBuild).addTask(new RunBuildToolsTask(this.outStream), isSingleFileBuild).addTask(new ResolveMavenDependenciesTask(this.outStream)).addTask(new CompileTask(this.outStream, this.errStream, true, false, isPackageModified, buildOptions.enableCache())).addTask(new CreateBalaTask(this.outStream)).addTask(new DumpBuildTimeTask(this.outStream), !project.buildOptions().dumpBuildTime()).build();
        taskExecutor.executeTasks((Project)project);
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    private BuildOptions constructBuildOptions() {
        BuildOptions.BuildOptionsBuilder buildOptionsBuilder = BuildOptions.builder();
        buildOptionsBuilder.setExperimental(Boolean.valueOf(this.experimentalFlag)).setOffline(this.offline).setDumpBir(Boolean.valueOf(this.dumpBIR)).setDumpBirFile(this.dumpBIRFile).setDumpGraph(Boolean.valueOf(this.dumpGraph)).setDumpRawGraphs(Boolean.valueOf(this.dumpRawGraphs)).setDumpBuildTime(this.dumpBuildTime).setSticky(this.sticky).setConfigSchemaGen(this.configSchemaGen).setEnableCache(this.enableCache).disableSyntaxTreeCaching(this.disableSyntaxTreeCaching).setShowDependencyDiagnostics(this.showDependencyDiagnostics).setOptimizeDependencyCompilation(this.optimizeDependencyCompilation).setLockingMode(this.lockingMode);
        if (this.targetDir != null) {
            buildOptionsBuilder.targetDir(this.targetDir.toString());
        }
        return buildOptionsBuilder.build();
    }

    @Override
    public String getName() {
        return "pack";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("pack"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("  bal pack [--offline] \\n\" +\n            \"       [<package-path>]");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

