/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.launcher;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.launcher.BLauncherException;
import io.ballerina.cli.launcher.CustomToolClassLoader;
import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.launcher.RuntimePanicException;
import io.ballerina.cli.launcher.util.BalToolsUtil;
import io.ballerina.runtime.internal.utils.RuntimeUtils;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import org.ballerinalang.compiler.BLangCompilerException;
import picocli.CommandLine;

public final class Main {
    private static final String UNMATCHED_ARGUMENT_PREFIX = "Unmatched argument";
    private static final String MISSING_REQUIRED_PARAMETER_PREFIX = "Missing required parameter";
    private static final String COMPILATION_ERROR_MESSAGE = "compilation contains errors";
    private static final PrintStream errStream = System.err;
    private static final PrintStream outStream = System.out;

    private Main() {
    }

    public static void main(String ... args) {
        try {
            Optional<BLauncherCmd> optionalInvokedCmd = Main.getInvokedCmd(args);
            optionalInvokedCmd.ifPresent(BLauncherCmd::execute);
        }
        catch (BLangCompilerException e) {
            if (!e.getMessage().contains(COMPILATION_ERROR_MESSAGE)) {
                errStream.println(LauncherUtils.prepareCompilerErrorMessage(e.getMessage()));
            }
            Runtime.getRuntime().exit(1);
        }
        catch (BLauncherException e) {
            LauncherUtils.printLauncherException(e, errStream);
            Runtime.getRuntime().exit(1);
        }
        catch (RuntimePanicException e) {
            Runtime.getRuntime().exit(e.getExitCode());
        }
        catch (Throwable e) {
            RuntimeUtils.logBadSad((Throwable)e);
            Runtime.getRuntime().exit(1);
        }
    }

    private static Optional<BLauncherCmd> getInvokedCmd(String ... args) {
        try {
            DefaultCmd defaultCmd = new DefaultCmd();
            CommandLine cmdParser = new CommandLine((Object)defaultCmd);
            defaultCmd.setParentCmdParser(cmdParser);
            cmdParser.setStopAtPositional(true);
            ServiceLoader<BLauncherCmd> bCmds = Main.loadAdditionalCommands(args);
            for (BLauncherCmd bCmd : bCmds) {
                cmdParser.addSubcommand(bCmd.getName(), (Object)bCmd);
                bCmd.setParentCmdParser(cmdParser);
            }
            HelpCmd helpCmd = new HelpCmd();
            cmdParser.addSubcommand("help", (Object)helpCmd);
            helpCmd.setParentCmdParser(cmdParser);
            ((CommandLine)cmdParser.getSubcommands().get("run")).setStopAtUnmatched(true).setStopAtPositional(true).setUnmatchedOptionsArePositionalParams(true).setEndOfOptionsDelimiter("");
            ((CommandLine)cmdParser.getSubcommands().get("build")).setStopAtUnmatched(false).setStopAtPositional(true);
            ((CommandLine)cmdParser.getSubcommands().get("test")).setStopAtUnmatched(true).setStopAtPositional(true).setUnmatchedOptionsArePositionalParams(true).setEndOfOptionsDelimiter("");
            VersionCmd versionCmd = new VersionCmd();
            cmdParser.addSubcommand("version", (Object)versionCmd);
            versionCmd.setParentCmdParser(cmdParser);
            HomeCmd homeCmd = new HomeCmd();
            cmdParser.addSubcommand("home", (Object)homeCmd);
            homeCmd.setParentCmdParser(cmdParser);
            cmdParser.setCommandName("bal");
            cmdParser.setPosixClusteredShortOptionsAllowed(false);
            List parsedCommands = cmdParser.parse(args);
            if (!defaultCmd.argList.isEmpty() && cmdParser.getSubcommands().get(defaultCmd.argList.get(0)) == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown command '" + defaultCmd.argList.get(0) + "'");
            }
            if (parsedCommands.isEmpty() || defaultCmd.helpFlag) {
                if (parsedCommands.size() > 1) {
                    defaultCmd.argList.add(((CommandLine)parsedCommands.get(1)).getCommandName());
                }
                return Optional.of(defaultCmd);
            }
            return Optional.of((BLauncherCmd)((CommandLine)parsedCommands.get(parsedCommands.size() - 1)).getCommand());
        }
        catch (CommandLine.UnmatchedArgumentException e) {
            String errorMessage = e.getMessage();
            if (errorMessage == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("internal error occurred");
            }
            if (errorMessage.contains(UNMATCHED_ARGUMENT_PREFIX)) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown command " + Main.getFirstUnknownArg(errorMessage));
            }
            throw LauncherUtils.createUsageExceptionWithHelp(LauncherUtils.makeFirstLetterLowerCase(errorMessage));
        }
        catch (CommandLine.ParameterException e) {
            String msg = e.getMessage();
            if (msg == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("internal error occurred");
            }
            if (msg.startsWith(MISSING_REQUIRED_PARAMETER_PREFIX)) {
                throw LauncherUtils.createUsageExceptionWithHelp("flag " + msg.substring(msg.indexOf("'")) + " needs an argument");
            }
            throw LauncherUtils.createUsageExceptionWithHelp(LauncherUtils.makeFirstLetterLowerCase(msg));
        }
    }

    private static ServiceLoader<BLauncherCmd> loadAdditionalCommands(String ... args) {
        BalToolsUtil.updateOldBalToolsToml();
        if (null != args && args.length > 0 && BalToolsUtil.isToolCommand(args[0])) {
            String commandName = args[0];
            BalToolsUtil.addToolIfCommandIsABuiltInTool(commandName);
            CustomToolClassLoader customToolClassLoader = BalToolsUtil.getCustomToolClassLoader(commandName);
            Thread.currentThread().setContextClassLoader(customToolClassLoader);
            return ServiceLoader.load(BLauncherCmd.class, customToolClassLoader);
        }
        if (null == args || args.length == 0 || Arrays.asList("help", "--help", "-h").contains(args[0])) {
            CustomToolClassLoader customToolClassLoader = BalToolsUtil.getCustomToolClassLoader("help");
            Thread.currentThread().setContextClassLoader(customToolClassLoader);
            return ServiceLoader.load(BLauncherCmd.class, customToolClassLoader);
        }
        return ServiceLoader.load(BLauncherCmd.class);
    }

    private static void printUsageInfo(String commandName) {
        String usageInfo = BLauncherCmd.getCommandUsageInfo(commandName);
        errStream.println(usageInfo);
    }

    private static void printVersionInfo() {
        try (InputStream inputStream = Main.class.getResourceAsStream("/META-INF/tool.properties");){
            Properties properties = new Properties();
            properties.load(inputStream);
            String version = properties.getProperty("ballerina.packVersion").split("-")[0];
            int minorVersion = Integer.parseInt(version.split("\\.")[1]);
            Object updateVersionText = minorVersion > 0 ? " Update " + minorVersion : "";
            String output = "Ballerina " + version + " (" + properties.getProperty("ballerina.channel") + (String)updateVersionText + ")\n";
            output = output + "Language specification " + properties.getProperty("spec.version") + "\n";
            outStream.print(output);
        }
        catch (Throwable ignore) {
            throw LauncherUtils.createUsageExceptionWithHelp("version info not available");
        }
    }

    private static void printBallerinaDistPath() {
        String balHome = System.getProperty("ballerina.home");
        if (balHome == null) {
            throw LauncherUtils.createUsageExceptionWithHelp("home info not available");
        }
        outStream.print(balHome + "\n");
    }

    private static String getFirstUnknownArg(String errorMessage) {
        String optionsString = errorMessage.split(":")[1];
        return optionsString.split(",")[0].trim();
    }

    @CommandLine.Command(description={"Default Command."}, name="default")
    private static class DefaultCmd
    implements BLauncherCmd {
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true, description={"for more information"})
        private boolean helpFlag;
        @CommandLine.Option(names={"--debug"}, description={"start Ballerina in remote debugging mode"})
        private String debugPort;
        @CommandLine.Option(names={"--version", "-v"}, hidden=true)
        private boolean versionFlag;
        @CommandLine.Parameters(arity="0..1")
        private List<String> argList = new ArrayList<String>();
        private CommandLine parentCmdParser;

        private DefaultCmd() {
        }

        @Override
        public void execute() {
            Map subCommands = this.parentCmdParser.getSubcommands();
            if (this.versionFlag) {
                Main.printVersionInfo();
                return;
            }
            if (!this.argList.isEmpty()) {
                String commandHelp = LauncherUtils.generateCommandHelp(this.argList.get(0), subCommands);
                outStream.println(commandHelp);
                return;
            }
            String generalHelp = LauncherUtils.generateGeneralHelp(subCommands);
            outStream.println(generalHelp);
        }

        @Override
        public String getName() {
            return "default";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }

    @CommandLine.Command(name="help", description={"print usage information"})
    private static class HelpCmd
    implements BLauncherCmd {
        @CommandLine.Parameters(description={"Command name"})
        private List<String> helpCommands;
        private CommandLine parentCmdParser;

        private HelpCmd() {
        }

        @Override
        public void execute() {
            Map subCommands = this.parentCmdParser.getSubcommands();
            if (this.helpCommands == null) {
                String generalHelp = LauncherUtils.generateGeneralHelp(subCommands);
                outStream.println(generalHelp);
                return;
            }
            if (this.helpCommands.size() > 1) {
                throw LauncherUtils.createUsageExceptionWithHelp("too many arguments given");
            }
            String userCommand = this.helpCommands.get(0);
            if (this.parentCmdParser.getSubcommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown help topic `" + userCommand + "`");
            }
            String commandHelp = LauncherUtils.generateCommandHelp(userCommand, subCommands);
            outStream.println(commandHelp);
        }

        @Override
        public String getName() {
            return "help";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }

    @CommandLine.Command(name="version", description={"Print the Ballerina version"})
    private static class VersionCmd
    implements BLauncherCmd {
        @CommandLine.Parameters(description={"Command name"})
        private List<String> versionCommands;
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
        private boolean helpFlag;
        private CommandLine parentCmdParser;

        private VersionCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("version");
                return;
            }
            if (this.versionCommands == null) {
                Main.printVersionInfo();
            }
        }

        @Override
        public String getName() {
            return "version";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
            out.append(BLauncherCmd.getCommandUsageInfo("version"));
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("Print the Ballerina version");
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }

    @CommandLine.Command(name="home", description={"Prints the path of current Ballerina dist"})
    private static class HomeCmd
    implements BLauncherCmd {
        @CommandLine.Parameters(description={"Command name"})
        private List<String> homeCommands;
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
        private boolean helpFlag;
        private CommandLine parentCmdParser;

        private HomeCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("home");
                return;
            }
            if (this.homeCommands == null) {
                Main.printBallerinaDistPath();
                return;
            }
            if (this.homeCommands.size() > 1) {
                throw LauncherUtils.createUsageExceptionWithHelp("too many arguments given");
            }
            String userCommand = this.homeCommands.get(0);
            if (this.parentCmdParser.getSubcommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown command " + userCommand);
            }
        }

        @Override
        public String getName() {
            return "home";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("  bal home\n");
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }
}

