/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.task.Task;
import io.ballerina.cli.utils.BuildTime;
import io.ballerina.projects.CodeGeneratorResult;
import io.ballerina.projects.CodeModifierResult;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.PlatformLibraryScope;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.directory.SingleFileProject;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.internal.PackageDiagnostic;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.wso2.ballerinalang.util.RepoUtils;

public class CompileTask
implements Task {
    private final transient PrintStream out;
    private final transient PrintStream err;
    private final boolean compileForBalPack;
    private final boolean compileForBalBuild;
    private final boolean isPackageModified;
    private final boolean cachesEnabled;

    public CompileTask(PrintStream out, PrintStream err) {
        this(out, err, false, false, true, false);
    }

    public CompileTask(PrintStream out, PrintStream err, boolean compileForBalPack, boolean compileForBalBuild, boolean isPackageModified, boolean cachesEnabled) {
        this.out = out;
        this.err = err;
        this.compileForBalPack = compileForBalPack;
        this.compileForBalBuild = compileForBalBuild;
        this.isPackageModified = isPackageModified;
        this.cachesEnabled = cachesEnabled;
    }

    @Override
    public void execute(Project project) {
        if (ProjectUtils.isProjectEmpty((Project)project) && this.skipCompilationForBalPack(project)) {
            throw LauncherUtils.createLauncherException("package is empty. Please add at least one .bal file.");
        }
        this.out.println("Compiling source");
        Object sourceName = project instanceof SingleFileProject ? project.currentPackage().getDefaultModule().document((DocumentId)project.currentPackage().getDefaultModule().documentIds().iterator().next()).name() : project.currentPackage().packageOrg().toString() + "/" + project.currentPackage().packageName().toString() + ":" + String.valueOf(project.currentPackage().packageVersion());
        this.out.println("\t" + (String)sourceName);
        System.setProperty("enableOutputStream", "true");
        try {
            this.printWarningForHigherDistribution(project);
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
            if (this.compileForBalBuild) {
                this.addDiagnosticForProvidedPlatformLibs(project, diagnostics);
            }
            long start = 0L;
            if (project.currentPackage().compilationOptions().dumpGraph().booleanValue() || project.currentPackage().compilationOptions().dumpRawGraphs().booleanValue()) {
                this.out.println();
                this.out.println("Resolving dependencies");
            }
            if (project.buildOptions().dumpBuildTime()) {
                start = System.currentTimeMillis();
            }
            Set packageImports = ProjectUtils.getPackageImports((Package)project.currentPackage());
            PackageResolution packageResolution = project.currentPackage().getResolution();
            if (project.buildOptions().dumpBuildTime()) {
                BuildTime.getInstance().packageResolutionDuration = System.currentTimeMillis() - start;
            }
            if (project.currentPackage().compilationOptions().dumpRawGraphs().booleanValue()) {
                packageResolution.dumpGraphs(this.out);
            }
            if (project.buildOptions().dumpBuildTime()) {
                BuildTime.getInstance().codeGeneratorPluginDuration = 0L;
                BuildTime.getInstance().codeModifierPluginDuration = 0L;
                start = System.currentTimeMillis();
            }
            if (!(project.currentPackage().getResolution().diagnosticResult().hasErrors() || project.kind().equals((Object)ProjectKind.BALA_PROJECT) || project.kind().equals((Object)ProjectKind.BALA_PROJECT) || this.isPackCmdForATemplatePkg(project) || !this.isPackageModified && this.cachesEnabled)) {
                CodeGeneratorResult codeGeneratorResult = project.currentPackage().runCodeGeneratorPlugins();
                diagnostics.addAll(codeGeneratorResult.reportedDiagnostics().diagnostics());
                if (project.buildOptions().dumpBuildTime()) {
                    BuildTime.getInstance().codeGeneratorPluginDuration = System.currentTimeMillis() - start;
                    start = System.currentTimeMillis();
                }
                CodeModifierResult codeModifierResult = project.currentPackage().runCodeModifierPlugins();
                diagnostics.addAll(codeModifierResult.reportedDiagnostics().diagnostics());
                if (project.buildOptions().dumpBuildTime()) {
                    BuildTime.getInstance().codeModifierPluginDuration = System.currentTimeMillis() - start;
                }
            }
            Set newPackageImports = ProjectUtils.getPackageImports((Package)project.currentPackage());
            ResolutionOptions resolutionOptions = ResolutionOptions.builder().setOffline(true).build();
            if (!packageImports.equals(newPackageImports)) {
                resolutionOptions = ResolutionOptions.builder().setOffline(false).build();
            }
            if (packageResolution != project.currentPackage().getResolution(resolutionOptions)) {
                packageResolution = project.currentPackage().getResolution();
                if (project.currentPackage().compilationOptions().dumpRawGraphs().booleanValue()) {
                    packageResolution.dumpGraphs(this.out);
                }
            }
            if (project.currentPackage().compilationOptions().dumpGraph().booleanValue()) {
                packageResolution.dumpGraphs(this.out);
            }
            if (project.currentPackage().getResolution().diagnosticResult().hasErrors()) {
                diagnostics.addAll(project.currentPackage().getResolution().diagnosticResult().diagnostics());
                diagnostics.addAll(project.currentPackage().manifest().diagnostics().diagnostics());
                diagnostics.addAll(project.currentPackage().dependencyManifest().diagnostics().diagnostics());
                diagnostics.forEach(d -> {
                    if (!d.diagnosticInfo().code().startsWith("BCE53")) {
                        this.err.println(d);
                    }
                });
                throw LauncherUtils.createLauncherException("package resolution contains errors");
            }
            project.currentPackage().dependencyManifest().diagnostics().diagnostics().forEach(diagnostic -> {
                if (diagnostic.diagnosticInfo().code().equals(ProjectDiagnosticErrorCode.CORRUPTED_DEPENDENCIES_TOML.diagnosticId())) {
                    diagnostics.add((Diagnostic)diagnostic);
                }
            });
            if (project.buildOptions().dumpBuildTime()) {
                start = System.currentTimeMillis();
            }
            Optional<Diagnostic> projectLoadingDiagnostic = ProjectUtils.getProjectLoadingDiagnostic().stream().filter(diagnostic -> diagnostic.diagnosticInfo().code().equals(ProjectDiagnosticErrorCode.DEPRECATED_RESOURCES_STRUCTURE.diagnosticId())).findAny();
            projectLoadingDiagnostic.ifPresent(this.out::println);
            PackageCompilation packageCompilation = project.currentPackage().getCompilation();
            if (project.buildOptions().dumpBuildTime()) {
                BuildTime.getInstance().packageCompilationDuration = System.currentTimeMillis() - start;
                start = System.currentTimeMillis();
            }
            JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)packageCompilation, (JvmTarget)JvmTarget.JAVA_21);
            if (project.buildOptions().dumpBuildTime()) {
                BuildTime.getInstance().codeGenDuration = System.currentTimeMillis() - start;
            }
            diagnostics.addAll(jBallerinaBackend.diagnosticResult().diagnostics(false));
            diagnostics.forEach(d -> {
                if (d.diagnosticInfo().code() == null || !d.diagnosticInfo().code().equals(ProjectDiagnosticErrorCode.BUILT_WITH_OLDER_SL_UPDATE_DISTRIBUTION.diagnosticId()) && !d.diagnosticInfo().code().startsWith("BCE53")) {
                    this.err.println(d);
                }
            });
            diagnostics.addAll(project.currentPackage().getBuildToolResolution().getDiagnosticList());
            boolean hasErrors = false;
            for (Diagnostic d2 : diagnostics) {
                if (!d2.diagnosticInfo().severity().equals((Object)DiagnosticSeverity.ERROR)) continue;
                hasErrors = true;
            }
            if (hasErrors) {
                throw LauncherUtils.createLauncherException("compilation contains errors");
            }
            project.save();
        }
        catch (ProjectException e) {
            throw LauncherUtils.createLauncherException("compilation failed: " + e.getMessage());
        }
    }

    private boolean isPackCmdForATemplatePkg(Project project) {
        return this.compileForBalPack && project.currentPackage().manifest().template();
    }

    private void printWarningForHigherDistribution(Project project) {
        SemanticVersion prevDistributionVersion = project.currentPackage().dependencyManifest().distributionVersion();
        SemanticVersion currentDistributionVersion = SemanticVersion.from((String)RepoUtils.getBallerinaShortVersion());
        if (project.currentPackage().dependencyManifest().dependenciesTomlVersion() != null) {
            Object prevVersionForDiagnostic;
            Object currentVersionForDiagnostic = String.valueOf(currentDistributionVersion.minor());
            if (currentDistributionVersion.patch() != 0) {
                currentVersionForDiagnostic = (String)currentVersionForDiagnostic + "." + currentDistributionVersion.patch();
            }
            if (null != prevDistributionVersion) {
                prevVersionForDiagnostic = String.valueOf(prevDistributionVersion.minor());
                if (prevDistributionVersion.patch() != 0) {
                    prevVersionForDiagnostic = (String)prevVersionForDiagnostic + "." + prevDistributionVersion.patch();
                }
            } else {
                prevVersionForDiagnostic = "4 or an older Update";
            }
            String warning = null;
            if (prevDistributionVersion == null || ProjectUtils.isNewUpdateDistribution((SemanticVersion)prevDistributionVersion, (SemanticVersion)currentDistributionVersion)) {
                warning = "Detected an attempt to compile this package using Swan Lake Update " + (String)currentVersionForDiagnostic + ". However, this package was built using Swan Lake Update " + (String)prevVersionForDiagnostic + ".";
                warning = project.buildOptions().sticky() ? warning + "\nHINT: Execute the bal command with --sticky=false" : warning + " To ensure compatibility, the Dependencies.toml file will be updated with the latest versions that are compatible with Update " + (String)currentVersionForDiagnostic + ".";
            }
            if (warning != null) {
                DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.BUILT_WITH_OLDER_SL_UPDATE_DISTRIBUTION.diagnosticId(), warning, DiagnosticSeverity.WARNING);
                PackageDiagnostic diagnostic = new PackageDiagnostic(diagnosticInfo, project.currentPackage().descriptor().name().toString());
                this.err.println(diagnostic);
            }
        }
    }

    private void addDiagnosticForProvidedPlatformLibs(Project project, List<Diagnostic> diagnostics) {
        Map platforms = project.currentPackage().manifest().platforms();
        for (PackageManifest.Platform javaPlatform : platforms.values()) {
            if (javaPlatform == null || javaPlatform.dependencies().isEmpty()) continue;
            for (Map dependency : javaPlatform.dependencies()) {
                if (!Objects.equals(dependency.get("scope"), PlatformLibraryScope.PROVIDED.getStringValue())) continue;
                DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.INVALID_PROVIDED_SCOPE_IN_BUILD.diagnosticId(), String.format("'%s' scope for platform dependencies is not allowed with package build%n", PlatformLibraryScope.PROVIDED.getStringValue()), DiagnosticSeverity.ERROR);
                diagnostics.add((Diagnostic)new PackageDiagnostic(diagnosticInfo, project.currentPackage().descriptor().name().toString()));
                return;
            }
        }
    }

    private boolean skipCompilationForBalPack(Project project) {
        return !this.compileForBalPack || project.currentPackage().compilerPluginToml().isEmpty() && project.currentPackage().balToolToml().isEmpty();
    }
}

