/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.task.Task;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.internal.model.Target;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import org.ballerinalang.docgen.docs.BallerinaDocGenerator;

public class CreateDocsTask
implements Task {
    private final transient PrintStream out;
    private Path outputPath;

    public CreateDocsTask(PrintStream out, Path outputPath) {
        this.out = out;
        this.outputPath = outputPath;
    }

    @Override
    public void execute(Project project) {
        Path sourceRootPath = project.targetDir();
        if (this.outputPath == null) {
            try {
                Target target = new Target(sourceRootPath);
                this.outputPath = target.getDocPath();
            }
            catch (ProjectException | IOException e) {
                throw LauncherUtils.createLauncherException("error occurred while generating docs: " + e.getMessage());
            }
        }
        this.out.println("Generating API Documentation");
        try {
            BallerinaDocGenerator.generateAPIDocs((Project)project, (String)this.outputPath.toString(), (boolean)false);
            this.out.println("Saved to: " + sourceRootPath.relativize(this.outputPath).toString());
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException("Unable to generate API Documentation.", e.getCause());
        }
    }
}

