/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.task.Task;
import io.ballerina.cli.utils.BuildTime;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

public class DumpBuildTimeTask
implements Task {
    private static final String BUILD_TIME_JSON = "build-time.json";
    private final transient PrintStream out;
    private final Path currentDir = Path.of(System.getProperty("user.dir"), new String[0]);

    public DumpBuildTimeTask(PrintStream out) {
        this.out = out;
    }

    @Override
    public void execute(Project project) {
        if (project.buildOptions().dumpBuildTime()) {
            BuildTime.getInstance().totalDuration = System.currentTimeMillis() - BuildTime.getInstance().timestamp;
            BuildTime.getInstance().offline = project.buildOptions().offlineBuild();
            Path buildTimeFile = this.getBuildTimeFilePath(project);
            Path buildTimeFileRelativePath = Path.of(System.getProperty("user.dir"), new String[0]).relativize(buildTimeFile);
            this.out.println("\nDumping build time information\n\t" + String.valueOf(buildTimeFileRelativePath));
            this.persistBuildTimeToFile(buildTimeFile);
        }
    }

    private void persistBuildTimeToFile(Path filepath) {
        File jsonFile = new File(filepath.toString());
        try (FileOutputStream fileOutputStream = new FileOutputStream(jsonFile);){
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
                Gson gson = new Gson();
                BuildTime buildTime = BuildTime.getInstance();
                String json = gson.toJson((Object)buildTime);
                writer.write(new String(json.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
                this.printBuildTime(buildTime);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("couldn't write build time to file : " + e.getMessage());
            }
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException("couldn't write build time to file : " + e.getMessage());
        }
    }

    private Path getBuildTimeFilePath(Project project) {
        if (project.kind().equals((Object)ProjectKind.BUILD_PROJECT)) {
            return project.targetDir().resolve(BUILD_TIME_JSON).toAbsolutePath();
        }
        return this.currentDir.resolve(BUILD_TIME_JSON).toAbsolutePath();
    }

    private void printBuildTime(BuildTime buildTime) {
        Gson gson = new Gson();
        JsonObject buildTimeJson = (JsonObject)gson.toJsonTree((Object)buildTime);
        buildTimeJson.entrySet().forEach(entry -> this.out.println("\t" + (String)entry.getKey() + " : " + ((JsonElement)entry.getValue()).toString()));
    }
}

