/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.utils;

import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.utils.BrowserLauncher;
import io.ballerina.cli.utils.TokenUpdater;
import io.ballerina.projects.Settings;
import io.ballerina.projects.util.ProjectUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.ballerinalang.central.client.CentralAPIClient;
import org.wso2.ballerinalang.util.RepoUtils;

public final class CentralUtils {
    private static final String BALLERINA_CENTRAL_PRODUCTION_URL = "https://central.ballerina.io";
    private static final String BALLERINA_CENTRAL_STAGING_URL = "https://staging-central.ballerina.io";
    private static final String BALLERINA_CENTRAL_DEV_URL = "https://dev-central.ballerina.io";

    private CentralUtils() {
    }

    public static void authenticate(PrintStream errStream, String ballerinaCentralCliTokenUrl, Path settingsTomlFilePath, CentralAPIClient client) {
        String accessToken = client.accessToken();
        if (accessToken.isEmpty()) {
            try {
                errStream.println("Opening the web browser to " + ballerinaCentralCliTokenUrl + " for auto token update ...");
                BrowserLauncher.startInDefaultBrowser(ballerinaCentralCliTokenUrl);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("Access token is missing in " + settingsTomlFilePath.toString() + "\nAuto update failed. Please visit https://central.ballerina.io");
            }
            long modifiedTimeOfFileAtStart = CentralUtils.getLastModifiedTimeOfFile(settingsTomlFilePath);
            TokenUpdater.execute(settingsTomlFilePath.toString());
            boolean waitForToken = true;
            while (waitForToken) {
                CentralUtils.pause();
                long modifiedTimeOfFileAfter = CentralUtils.getLastModifiedTimeOfFile(settingsTomlFilePath);
                if (modifiedTimeOfFileAtStart == modifiedTimeOfFileAfter) continue;
                Settings settings = RepoUtils.readSettings();
                accessToken = ProjectUtils.getAccessTokenOfCLI((Settings)settings);
                if (accessToken.isEmpty()) {
                    throw LauncherUtils.createLauncherException("Access token is missing in " + settingsTomlFilePath.toString() + "\nPlease visit https://central.ballerina.io");
                }
                waitForToken = false;
                client.setAccessToken(accessToken);
            }
        }
    }

    private static void pause() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            throw LauncherUtils.createLauncherException("Error occurred while retrieving the access token");
        }
    }

    private static long getLastModifiedTimeOfFile(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return -1L;
        }
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException ex) {
            throw LauncherUtils.createLauncherException("Error occurred when reading file for token " + path.toString());
        }
    }

    public static String getBallerinaCentralCliTokenUrl() {
        if (RepoUtils.SET_BALLERINA_STAGE_CENTRAL) {
            return "https://staging-central.ballerina.io/dashboard?tab=token";
        }
        if (RepoUtils.SET_BALLERINA_DEV_CENTRAL) {
            return "https://dev-central.ballerina.io/dashboard?tab=token";
        }
        return "https://central.ballerina.io/dashboard?tab=token";
    }

    public static String getCentralPackageURL(String org, String pkgName) {
        if (RepoUtils.SET_BALLERINA_STAGE_CENTRAL) {
            return "https://staging-central.ballerina.io/" + org + "/" + pkgName;
        }
        if (RepoUtils.SET_BALLERINA_DEV_CENTRAL) {
            return "https://dev-central.ballerina.io/" + org + "/" + pkgName;
        }
        return "https://central.ballerina.io/" + org + "/" + pkgName;
    }
}

