/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.utils;

import io.ballerina.projects.AnyTarget;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.util.ProjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class GraalVMCompatibilityUtils {
    private GraalVMCompatibilityUtils() {
    }

    private static boolean hasExternalPlatformDependencies(Package pkg) {
        Map platforms = pkg.manifest().platforms();
        for (PackageManifest.Platform platformVal : platforms.values()) {
            if (platformVal.dependencies().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static String otherPlatformGraalvmCompatibleVerified(String target, Map<String, PackageManifest.Platform> platforms) {
        for (Map.Entry<String, PackageManifest.Platform> platform : platforms.entrySet()) {
            if (platform.getKey().equals(target) || platform.getValue().graalvmCompatible() == null) continue;
            return platform.getKey();
        }
        return "";
    }

    private static Boolean isAllPlatformDepsGraalvmCompatible(Map<String, PackageManifest.Platform> platforms) {
        Boolean isAllDepsGraalvmCompatible = true;
        for (PackageManifest.Platform platform : platforms.values()) {
            if (platform.isPlatfromDepsGraalvmCompatible() == null) {
                isAllDepsGraalvmCompatible = null;
                continue;
            }
            if (platform.isPlatfromDepsGraalvmCompatible().booleanValue()) continue;
            return false;
        }
        return isAllDepsGraalvmCompatible;
    }

    public static String getWarningForPackage(Package pkg, String targetPlatform) {
        if (GraalVMCompatibilityUtils.hasExternalPlatformDependencies(pkg)) {
            PackageManifest.Platform platform = pkg.manifest().platform(targetPlatform);
            Boolean allDepsGraalvmCompatible = GraalVMCompatibilityUtils.isAllPlatformDepsGraalvmCompatible(pkg.manifest().platforms());
            String packageName = pkg.manifest().name().value();
            if (platform == null || platform.graalvmCompatible() == null) {
                String graalvmCompatiblePlatform = GraalVMCompatibilityUtils.otherPlatformGraalvmCompatibleVerified(targetPlatform, pkg.manifest().platforms());
                if (graalvmCompatiblePlatform.isEmpty() && allDepsGraalvmCompatible == null) {
                    return String.format("************************************************************%n* WARNING: Package is not verified with GraalVM.           *%n************************************************************%n%nThe GraalVM compatibility property has not been defined for the package '%s'. This could potentially lead to compatibility issues with GraalVM.%n%nTo resolve this warning, please ensure that all Java dependencies of this package are compatible with GraalVM. Subsequently, update the Ballerina.toml file under the section '[platform.%s]' with the attribute 'graalvmCompatible = true'.Or, add 'graalvmCompatible = true' attribute to each Java dependency entry in Ballerina.toml.%n%n************************************************************%n", packageName, targetPlatform);
                }
                if (!graalvmCompatiblePlatform.isEmpty() && !pkg.manifest().platform(graalvmCompatiblePlatform).graalvmCompatible().booleanValue() || allDepsGraalvmCompatible != null && !allDepsGraalvmCompatible.booleanValue()) {
                    return String.format("************************************************************%n* WARNING: Package is not compatible with GraalVM.         *%n************************************************************%n%nThe package '%s' has been marked with its GraalVM compatibility property set to false. This setting suggests potential compatibility issues with GraalVM.%n%nTo ensure this package can function seamlessly with GraalVM, it's recommended to either modify the package dependencies or consider GraalVM-compatible alternatives.%n%n************************************************************%n", packageName);
                }
            } else if (!platform.graalvmCompatible().booleanValue() || allDepsGraalvmCompatible != null && !allDepsGraalvmCompatible.booleanValue()) {
                return String.format("************************************************************%n* WARNING: Package is not compatible with GraalVM.         *%n************************************************************%n%nThe package '%s' has been marked with its GraalVM compatibility property set to false. This setting suggests potential compatibility issues with GraalVM.%n%nTo ensure this package can function seamlessly with GraalVM, it's recommended to either modify the package dependencies or consider GraalVM-compatible alternatives.%n%n************************************************************%n", packageName);
            }
        }
        return null;
    }

    private static String getWarningForDependencies(Package pkg, boolean isTestExec) {
        Collection allDependencies = pkg.getCompilation().getResolution().allDependencies();
        ArrayList<ResolvedPackageDependency> nonGraalVMCompatibleDependencies = new ArrayList<ResolvedPackageDependency>();
        ArrayList<ResolvedPackageDependency> nonVerifiedDependencies = new ArrayList<ResolvedPackageDependency>();
        allDependencies.stream().filter(dependency -> !ProjectUtils.isLangLibPackage((PackageOrg)dependency.packageInstance().descriptor().org(), (PackageName)dependency.packageInstance().descriptor().name())).forEach(dependency -> {
            Map platformMap = dependency.packageInstance().manifest().platforms();
            Optional platform = platformMap.entrySet().stream().findFirst();
            if (platform.isPresent() && !AnyTarget.ANY.code().equals(((Map.Entry)platform.get()).getKey())) {
                Boolean isGraalVMCompatible = ((PackageManifest.Platform)((Map.Entry)platform.get()).getValue()).graalvmCompatible();
                if (isGraalVMCompatible == null) {
                    if (!((PackageManifest.Platform)((Map.Entry)platform.get()).getValue()).dependencies().isEmpty()) {
                        nonVerifiedDependencies.add((ResolvedPackageDependency)dependency);
                    }
                } else if (!isGraalVMCompatible.booleanValue()) {
                    nonGraalVMCompatibleDependencies.add((ResolvedPackageDependency)dependency);
                }
            }
        });
        return GraalVMCompatibilityUtils.getDependenciesWarningMessage(GraalVMCompatibilityUtils.getDependenciesList(nonGraalVMCompatibleDependencies, isTestExec), GraalVMCompatibilityUtils.getDependenciesList(nonVerifiedDependencies, isTestExec));
    }

    public static String getAllWarnings(Package pkg, String targetPlatform, boolean isTestExec) {
        String dependencyWarning;
        StringBuilder warnings = new StringBuilder();
        String packageWarning = GraalVMCompatibilityUtils.getWarningForPackage(pkg, targetPlatform);
        if (packageWarning != null) {
            warnings.append(packageWarning);
        }
        if ((dependencyWarning = GraalVMCompatibilityUtils.getWarningForDependencies(pkg, isTestExec)) != null) {
            if (!warnings.isEmpty()) {
                warnings.append(System.lineSeparator());
            }
            warnings.append(dependencyWarning);
        }
        return warnings.toString();
    }

    private static String getDependenciesWarningMessage(String nonGraalVMCompatibleDependencies, String nonVerifiedDependencies) {
        if (nonGraalVMCompatibleDependencies.isEmpty() && nonVerifiedDependencies.isEmpty()) {
            return null;
        }
        StringBuilder warning = new StringBuilder(String.format("*************************************************************%n* WARNING: Some dependencies may not be GraalVM compatible. *%n*************************************************************%n%nThe following Ballerina dependencies in your project could pose compatibility issues with GraalVM.%n", new Object[0]));
        if (!nonVerifiedDependencies.isEmpty()) {
            warning.append("\nPackages pending compatibility verification with GraalVM:");
            warning.append(nonVerifiedDependencies);
            warning.append("\n");
        }
        if (!nonGraalVMCompatibleDependencies.isEmpty()) {
            warning.append("\nPackages marked as incompatible with GraalVM:");
            warning.append(nonGraalVMCompatibleDependencies);
            warning.append("\n");
        }
        warning.append(String.format("%nPlease note that generating a GraalVM native image may fail or result in runtime issues if these packages rely on features that are not supported by GraalVM's native image generation process.%n%nIt is recommended to review the API documentation or contact the maintainers of these packages for more information on their GraalVM compatibility status. You may need to adjust or find alternatives for these packages before proceeding with GraalVM native image generation.%n%n************************************************************%n", new Object[0]));
        return warning.toString();
    }

    private static String getDependenciesList(List<ResolvedPackageDependency> dependencies, boolean includeAllScopes) {
        StringBuilder dependenciesList = new StringBuilder();
        for (ResolvedPackageDependency dependency : dependencies) {
            if (!includeAllScopes && PackageDependencyScope.TEST_ONLY.equals((Object)dependency.scope())) continue;
            dependenciesList.append(System.lineSeparator()).append(GraalVMCompatibilityUtils.getDependencyDetail(dependency));
        }
        return dependenciesList.toString();
    }

    private static String getDependencyDetail(ResolvedPackageDependency dependency) {
        StringBuilder dependencyDetail = new StringBuilder("\t" + dependency.packageInstance().descriptor().toString());
        if (PackageDependencyScope.TEST_ONLY.equals((Object)dependency.scope())) {
            dependencyDetail.append(" [scope=").append(PackageDependencyScope.TEST_ONLY.getValue()).append("]");
        }
        return dependencyDetail.toString();
    }
}

