/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.utils;

import io.ballerina.projects.BalToolsManifest;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.ballerinalang.central.client.model.Package;
import org.ballerinalang.central.client.model.Tool;

public final class PrintUtils {
    private static final PrintStream outStream = System.out;

    private PrintUtils() {
    }

    public static void printLocalTools(List<BalToolsManifest.Tool> tools, String terminalWidth) {
        int rightMargin = 3;
        int width = Integer.parseInt(terminalWidth) - rightMargin;
        int maxToolIdNameLength = 0;
        for (BalToolsManifest.Tool tool : tools) {
            if (maxToolIdNameLength >= tool.id().length()) continue;
            maxToolIdNameLength = tool.id().length();
        }
        int versionColWidth = 15;
        int repositoryColWidth = 10;
        int padding = 2;
        int minimumToolIdColWidth = 20;
        int remainingWidth = Math.max(minimumToolIdColWidth, width - versionColWidth);
        int toolIdColWidth = Math.max(minimumToolIdColWidth, Math.min(maxToolIdNameLength, remainingWidth)) + padding;
        PrintUtils.printListLocalTableHeader(toolIdColWidth, versionColWidth, repositoryColWidth);
        for (BalToolsManifest.Tool tool : tools) {
            String repository = "local".equals(tool.repository()) ? "local" : "central";
            String activeIndicator = tool.active() != false ? "* " : "  ";
            PrintUtils.printInCLI("|" + tool.id(), toolIdColWidth);
            PrintUtils.printInCLI(activeIndicator + tool.version(), versionColWidth);
            PrintUtils.printInCLI(repository, repositoryColWidth);
            outStream.println();
        }
        outStream.println();
        outStream.println(tools.size() + " tools found.");
    }

    private static void printListLocalTableHeader(int toolIdColWidth, int versionColWidth, int repositoryColWidth) {
        PrintUtils.printInCLI("|TOOL ID", toolIdColWidth);
        PrintUtils.printInCLI("VERSION", versionColWidth);
        PrintUtils.printInCLI("REPO", repositoryColWidth);
        outStream.println();
        PrintUtils.printCharacter("|-", toolIdColWidth, "-", true);
        PrintUtils.printCharacter("-", versionColWidth, "-", true);
        PrintUtils.printCharacter("-", repositoryColWidth, "-", true);
        outStream.println();
    }

    public static void printPackages(List<Package> packages, String terminalWidth) {
        int[] columnWidths;
        String[] columnNames;
        int rightMargin = 3;
        int width = Integer.parseInt(terminalWidth) - rightMargin;
        int dateColWidth = 15;
        int authorsColWidth = 15;
        double nameColFactor = 7.0;
        double descColFactor = 14.0;
        double versionColFactor = 4.0;
        int additionalSpace = 7;
        double remainingWidth = (double)width - (double)(dateColWidth + additionalSpace);
        int nameColWidth = PrintUtils.getColWidth(remainingWidth, nameColFactor, descColFactor, versionColFactor);
        int descColWidth = PrintUtils.getColWidth(remainingWidth, descColFactor, nameColFactor, versionColFactor);
        int versionColWidth = PrintUtils.getColWidth(remainingWidth, versionColFactor, nameColFactor, descColFactor);
        int minDescColWidth = 60;
        if (descColWidth >= minDescColWidth) {
            columnNames = new String[]{"NAME", "DESCRIPTION", "AUTHOR", "DATE", "VERSION"};
            columnWidths = new int[]{nameColWidth, descColWidth - authorsColWidth, authorsColWidth, dateColWidth, versionColWidth};
        } else {
            columnNames = new String[]{"NAME", "DESCRIPTION", "DATE", "VERSION"};
            columnWidths = new int[]{nameColWidth, descColWidth, dateColWidth, versionColWidth};
        }
        PrintUtils.printBallerinaCentralTitle();
        PrintUtils.printPackageSearchTableHeader(columnNames, columnWidths);
        for (Package aPackage : packages) {
            outStream.print("|");
            PrintUtils.printPackage(aPackage, dateColWidth, versionColWidth, authorsColWidth, nameColWidth - 1, descColWidth, minDescColWidth);
            outStream.println();
        }
        outStream.println();
        outStream.println(packages.size() + " packages found");
    }

    public static void printTools(List<Tool> tools, String terminalWidth) {
        int[] columnWidths;
        String[] columnNames;
        int rightMargin = 3;
        int width = Integer.parseInt(terminalWidth) - rightMargin;
        int dateColWidth = 15;
        int authorsColWidth = 15;
        double idColFactor = 7.0;
        double nameColFactor = 7.0;
        double descColFactor = 14.0;
        double versionColFactor = 4.0;
        int additionalSpace = 7;
        double remainingWidth = (double)width - (double)(dateColWidth + additionalSpace);
        int idColWidth = PrintUtils.getColWidth(remainingWidth, idColFactor, nameColFactor, descColFactor, versionColFactor);
        int nameColWidth = PrintUtils.getColWidth(remainingWidth, idColFactor, nameColFactor, descColFactor, versionColFactor);
        int descColWidth = PrintUtils.getColWidth(remainingWidth, idColFactor, descColFactor, nameColFactor, versionColFactor);
        int versionColWidth = PrintUtils.getColWidth(remainingWidth, idColFactor, versionColFactor, nameColFactor, descColFactor);
        int minDescColWidth = 60;
        if (descColWidth >= minDescColWidth) {
            columnNames = new String[]{"ID", "PACKAGE", "DESCRIPTION", "AUTHOR", "DATE", "VERSION"};
            columnWidths = new int[]{idColWidth, nameColWidth, descColWidth - authorsColWidth, authorsColWidth, dateColWidth, versionColWidth};
        } else {
            columnNames = new String[]{"ID", "PACKAGE", "DESCRIPTION", "DATE", "VERSION"};
            columnWidths = new int[]{idColWidth, nameColWidth, descColWidth, dateColWidth, versionColWidth};
        }
        PrintUtils.printBallerinaCentralTitle();
        PrintUtils.printPackageSearchTableHeader(columnNames, columnWidths);
        for (Tool tool : tools) {
            PrintUtils.printInCLI("|" + tool.getBalToolId(), idColWidth);
            PrintUtils.printTool(tool, dateColWidth, versionColWidth, authorsColWidth, nameColWidth, descColWidth, minDescColWidth);
            outStream.println();
        }
        outStream.println();
        outStream.println(tools.size() + " tools found.");
    }

    private static void printPackage(Package aPackage, int dateColWidth, int versionColWidth, int authorsColWidth, int nameColWidth, int descColWidth, int minDescColWidth) {
        PrintUtils.printInCLI(aPackage.getOrganization() + "/" + aPackage.getName(), nameColWidth);
        String summary = PrintUtils.getSummary(aPackage);
        if (descColWidth >= minDescColWidth) {
            PrintUtils.printInCLI(summary, descColWidth - authorsColWidth);
            Object authors = "";
            List authorsArr = aPackage.getAuthors();
            if (!authorsArr.isEmpty()) {
                for (int j = 0; j < authorsArr.size(); ++j) {
                    authors = j == 0 ? (String)authorsArr.get(j) : (j == authorsArr.size() - 1 ? (String)authorsArr.get(j) : ", " + (String)authorsArr.get(j));
                }
            }
            PrintUtils.printInCLI((String)authors, authorsColWidth);
        } else {
            PrintUtils.printInCLI(summary, descColWidth);
        }
        PrintUtils.printInCLI(PrintUtils.getDateCreated(aPackage.getCreatedDate()), dateColWidth);
        PrintUtils.printInCLI(aPackage.getVersion(), versionColWidth);
    }

    private static void printTool(Tool tool, int dateColWidth, int versionColWidth, int authorsColWidth, int nameColWidth, int descColWidth, int minDescColWidth) {
        PrintUtils.printInCLI(tool.getOrganization() + "/" + tool.getName(), nameColWidth);
        String summary = PrintUtils.getSummary(tool);
        if (descColWidth >= minDescColWidth) {
            PrintUtils.printInCLI(summary, descColWidth - authorsColWidth);
            Object authors = "";
            List authorsArr = tool.getAuthors();
            if (!authorsArr.isEmpty()) {
                for (int j = 0; j < authorsArr.size(); ++j) {
                    authors = j == 0 ? (String)authorsArr.get(j) : (j == authorsArr.size() - 1 ? (String)authorsArr.get(j) : ", " + (String)authorsArr.get(j));
                }
            }
            PrintUtils.printInCLI((String)authors, authorsColWidth);
        } else {
            PrintUtils.printInCLI(summary, descColWidth);
        }
        PrintUtils.printInCLI(PrintUtils.getDateCreated(tool.getCreatedDate()), dateColWidth);
        PrintUtils.printInCLI(tool.getVersion(), versionColWidth);
    }

    private static void printBallerinaCentralTitle() {
        outStream.println();
        outStream.println("Ballerina Central");
        outStream.println("=================");
        outStream.println();
    }

    private static void printInCLI(String element, int charactersAllowed) {
        int lengthOfElement = element.length();
        if (lengthOfElement > charactersAllowed || lengthOfElement == charactersAllowed) {
            int margin = 3;
            String trimmedElement = element.substring(0, charactersAllowed - margin) + "...";
            outStream.print(trimmedElement + " |");
        } else {
            PrintUtils.printCharacter(element, charactersAllowed, " ", false);
        }
    }

    private static void printCharacter(String element, int charactersAllowed, String separator, boolean isDashElement) {
        int lengthOfElement = element.length();
        StringBuilder print = new StringBuilder(element);
        for (int i = 0; i < charactersAllowed - lengthOfElement; ++i) {
            print.append(separator);
        }
        if (isDashElement) {
            outStream.print(String.valueOf(print) + "-|");
        } else {
            outStream.print(String.valueOf(print) + " |");
        }
    }

    private static String getDateCreated(long timeInMillis) {
        Date date = new Date(timeInMillis);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-E");
        return df.format(date);
    }

    private static void printPackageSearchTableHeader(String[] columnNames, int[] columnWidths) {
        PrintUtils.printHeadingRow(columnNames, columnWidths);
        PrintUtils.printDashRow(columnWidths);
    }

    private static void printHeadingRow(String[] columnNames, int[] columnWidths) {
        PrintUtils.printInCLI("|" + columnNames[0], columnWidths[0]);
        for (int i = 1; i < columnNames.length; ++i) {
            PrintUtils.printInCLI(columnNames[i], columnWidths[i]);
        }
        outStream.println();
    }

    private static void printDashRow(int[] columnWidths) {
        PrintUtils.printCharacter("|-", columnWidths[0], "-", true);
        for (int i = 1; i < columnWidths.length; ++i) {
            PrintUtils.printCharacter("-", columnWidths[i], "-", true);
        }
        outStream.println();
    }

    private static String getSummary(Package aPackage) {
        String summary = aPackage.getSummary();
        if (summary == null) {
            String readme = aPackage.getReadme();
            if (readme == null) {
                return "";
            }
            summary = readme.substring(0, readme.indexOf(10));
        }
        return summary;
    }

    private static String getSummary(Tool tool) {
        String summary = tool.getSummary();
        if (summary == null) {
            String readme = tool.getReadme();
            if (readme == null) {
                return "";
            }
            summary = readme.substring(0, readme.indexOf(10));
        }
        return summary;
    }

    private static int getColWidth(double remainingWidth, double colFactor, double ... otherColFactors) {
        return (int)Math.round(remainingWidth * (colFactor / (colFactor + Arrays.stream(otherColFactors).sum())));
    }
}

