/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.utils;

import io.ballerina.cli.cmd.RunCommand;
import io.ballerina.cli.launcher.BLauncherException;
import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.launcher.RuntimePanicException;
import io.ballerina.runtime.internal.utils.RuntimeUtils;
import java.io.PrintStream;
import org.ballerinalang.compiler.BLangCompilerException;

public class RunCommandExecutor
extends Thread {
    private static final String COMPILATION_ERROR_MESSAGE = "compilation contains errors";
    private final RunCommand runCommand;
    private final PrintStream outStream;
    private volatile boolean runtimePanic;

    public RunCommandExecutor(RunCommand runCommand, PrintStream outStream) {
        this.runCommand = runCommand;
        this.outStream = outStream;
        this.runtimePanic = false;
    }

    @Override
    public void run() {
        try {
            this.runCommand.unsetWatch();
            this.runCommand.execute();
        }
        catch (BLangCompilerException e) {
            if (!e.getMessage().contains(COMPILATION_ERROR_MESSAGE)) {
                this.outStream.println(LauncherUtils.prepareCompilerErrorMessage(e.getMessage()));
            }
        }
        catch (BLauncherException e) {
            LauncherUtils.printLauncherException(e, this.outStream);
        }
        catch (RuntimePanicException ignored) {
            this.runtimePanic = true;
        }
        catch (Throwable e) {
            RuntimeUtils.logBadSad((Throwable)e);
            this.runtimePanic = true;
        }
    }

    public synchronized void terminate() {
        this.runCommand.killProcess();
        this.interrupt();
    }

    public synchronized boolean shouldWatch() {
        return this.runCommand.containsService() && !this.runtimePanic;
    }
}

