/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.table;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BIterator;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Next {
    private static final BString MUTATED_TABLE_ERROR_DETAIL = StringUtils.fromString((String)"Table was mutated after the iterator was created");

    private Next() {
    }

    public static Object next(BObject t) {
        BIterator tableIterator = (BIterator)t.getNativeData("&iterator&");
        BTable table = (BTable)t.get(StringUtils.fromString((String)"t"));
        BArray keys = (BArray)t.get(StringUtils.fromString((String)"keys"));
        long initialSize = (Long)t.get(StringUtils.fromString((String)"size"));
        if (tableIterator == null) {
            tableIterator = table.getIterator();
            t.addNativeData("&iterator&", (Object)tableIterator);
            t.addNativeData("&returnedKeys&", new ArrayList());
        }
        ArrayList returnedKeys = (ArrayList)t.getNativeData("&returnedKeys&");
        Next.handleMutation(table, keys, returnedKeys, initialSize);
        if (tableIterator.hasNext()) {
            BArray keyValueTuple = (BArray)tableIterator.next();
            returnedKeys.add(keyValueTuple.get(0L));
            return ValueCreator.createRecordValue((BMap)ValueCreator.createRecordValue((RecordType)((RecordType)table.getIteratorNextReturnType())), (Object[])new Object[]{keyValueTuple.get(1L)});
        }
        return null;
    }

    private static void handleMutation(BTable<?, ?> table, BArray keys, List<Object> returnedKeys, long initialSize) {
        if (initialSize < (long)table.size() || initialSize > 0L && table.isEmpty()) {
            throw ErrorCreator.createError((BString)ErrorReasons.ITERATOR_MUTABILITY_ERROR, (BString)MUTATED_TABLE_ERROR_DETAIL);
        }
        if (keys.isEmpty()) {
            return;
        }
        ArrayList<Object> currentKeys = new ArrayList<Object>(Arrays.asList(table.getKeys()));
        for (Object returnedValue : returnedKeys) {
            if (!TypeChecker.isEqual(currentKeys.get(0), (Object)returnedValue)) continue;
            currentKeys.remove(0);
        }
        BArray currentKeyArray = ValueCreator.createArrayValue((ArrayType)((ArrayType)TypeUtils.getImpliedType((Type)keys.getType())));
        for (int i = 0; i < currentKeys.size(); ++i) {
            Object key = currentKeys.get(i);
            currentKeyArray.add((long)i, key);
        }
        if (!TypeChecker.isEqual((Object)currentKeyArray, (Object)keys)) {
            throw ErrorCreator.createError((BString)ErrorReasons.ITERATOR_MUTABILITY_ERROR, (BString)MUTATED_TABLE_ERROR_DETAIL);
        }
        keys.shift();
    }
}

