/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.validator;

import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.openapi.validator.NodeValidator;
import io.ballerina.openapi.validator.TypeValidatorUtils;
import io.ballerina.openapi.validator.ValidatorContext;
import io.ballerina.openapi.validator.ValidatorUtils;
import io.ballerina.openapi.validator.error.CompilationError;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HeaderValidator
extends NodeValidator {
    private final Map<String, Node> balHeaders;
    private final List<Parameter> oasParameters;

    public HeaderValidator(ValidatorContext validatorContext, Map<String, Node> balHeaders, List<Parameter> oasParameters) {
        super(validatorContext);
        this.balHeaders = balHeaders;
        this.oasParameters = oasParameters;
    }

    @Override
    public void validateBallerinaToOpenAPI() {
        for (Map.Entry<String, Node> balHeader : this.balHeaders.entrySet()) {
            List<String> headers;
            NodeList annotations;
            String ballerinaType;
            Node headerNode = balHeader.getValue();
            String headerName = ValidatorUtils.unescapeIdentifier(balHeader.getKey());
            if (headerNode instanceof RequiredParameterNode) {
                RequiredParameterNode requireParam = (RequiredParameterNode)headerNode;
                ballerinaType = requireParam.typeName().toString().trim();
                annotations = requireParam.annotations();
            } else {
                DefaultableParameterNode defaultParam = (DefaultableParameterNode)headerNode;
                ballerinaType = defaultParam.typeName().toString().trim();
                annotations = defaultParam.annotations();
            }
            if (!annotations.isEmpty() && !(headers = ValidatorUtils.extractAnnotationFieldDetails("http:Header", "name", (NodeList<AnnotationNode>)annotations, this.validatorContext.getContext().semanticModel())).isEmpty()) {
                headerName = headers.get(0);
            }
            boolean isHeaderDocumented = false;
            if (this.oasParameters != null) {
                for (Parameter oasParameter : this.oasParameters) {
                    ArraySchema arraySchema;
                    String items;
                    Optional<String> arrayItemType;
                    if (!(oasParameter instanceof HeaderParameter) || !headerName.equals(oasParameter.getName())) continue;
                    isHeaderDocumented = true;
                    Schema schema = oasParameter.getSchema();
                    String headerType = ValidatorUtils.getNumberFormatType(schema);
                    if (schema instanceof ArraySchema && ((arrayItemType = TypeValidatorUtils.convertOpenAPITypeToBallerina(items = (arraySchema = (ArraySchema)schema).getItems().getType())).isEmpty() || !ballerinaType.equals(arrayItemType.get() + "[]"))) {
                        ValidatorUtils.reportDiagnostic(this.validatorContext.getContext(), CompilationError.TYPE_MISMATCH_HEADER_PARAMETER, (Location)headerNode.location(), this.validatorContext.getSeverity(), items + "[]", ballerinaType, headerName, this.validatorContext.getMethod(), ValidatorUtils.getNormalizedPath(this.validatorContext.getPath()));
                        break;
                    }
                    Optional<String> type = TypeValidatorUtils.convertOpenAPITypeToBallerina(headerType);
                    if (!type.isEmpty() && ballerinaType.equals(type.get())) continue;
                    ValidatorUtils.reportDiagnostic(this.validatorContext.getContext(), CompilationError.TYPE_MISMATCH_HEADER_PARAMETER, (Location)headerNode.location(), this.validatorContext.getSeverity(), headerType, ballerinaType, headerName, this.validatorContext.getMethod(), ValidatorUtils.getNormalizedPath(this.validatorContext.getPath()));
                    break;
                }
            }
            if (isHeaderDocumented) continue;
            ValidatorUtils.reportDiagnostic(this.validatorContext.getContext(), CompilationError.UNDEFINED_HEADER, (Location)balHeader.getValue().location(), this.validatorContext.getSeverity(), headerName, this.validatorContext.getMethod(), ValidatorUtils.getNormalizedPath(this.validatorContext.getPath()));
        }
    }

    @Override
    public void validateOpenAPIToBallerina() {
        if (this.oasParameters == null) {
            return;
        }
        this.oasParameters.forEach(parameter -> {
            if (parameter.get$ref() != null) {
                Optional<String> parameterName = ValidatorUtils.extractReferenceType(parameter.get$ref());
                if (parameterName.isEmpty()) {
                    return;
                }
                parameter = this.validatorContext.getOpenAPI().getComponents().getParameters().get(parameterName.get());
            }
            if (parameter instanceof HeaderParameter || parameter.getIn() != null && parameter.getIn().equals("header")) {
                boolean isHeaderExist = false;
                for (Map.Entry<String, Node> header : this.balHeaders.entrySet()) {
                    if (!parameter.getName().equals(header.getKey())) continue;
                    isHeaderExist = true;
                }
                if (!isHeaderExist) {
                    ValidatorUtils.reportDiagnostic(this.validatorContext, CompilationError.MISSING_HEADER, parameter.getName(), this.validatorContext.getMethod(), this.validatorContext.getPath());
                }
            }
        });
    }
}

