/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.validator.model;

import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.List;

public class Filter {
    private final List<String> tag;
    private final List<String> excludeTag;
    private final List<String> operation;
    private final List<String> excludeOperation;
    private final DiagnosticSeverity kind;

    public Filter(FilterBuilder filterBuilder) {
        this.tag = filterBuilder.tag;
        this.excludeTag = filterBuilder.excludeTag;
        this.operation = filterBuilder.operation;
        this.excludeOperation = filterBuilder.excludeOperation;
        this.kind = filterBuilder.kind;
    }

    public List<String> getTag() {
        return this.tag;
    }

    public List<String> getExcludeTag() {
        return this.excludeTag;
    }

    public List<String> getOperation() {
        return this.operation;
    }

    public List<String> getExcludeOperation() {
        return this.excludeOperation;
    }

    public DiagnosticSeverity getKind() {
        return this.kind;
    }

    public static class FilterBuilder {
        private List<String> tag;
        private List<String> excludeTag;
        private List<String> operation;
        private List<String> excludeOperation;
        private DiagnosticSeverity kind = DiagnosticSeverity.ERROR;

        public FilterBuilder withTag(List<String> tag) {
            this.tag = tag;
            return this;
        }

        public FilterBuilder withExcludeTag(List<String> excludeTag) {
            this.excludeTag = excludeTag;
            return this;
        }

        public FilterBuilder withOperation(List<String> operation) {
            this.operation = operation;
            return this;
        }

        public FilterBuilder withExcludeOperation(List<String> excludeOperation) {
            this.excludeOperation = excludeOperation;
            return this;
        }

        public FilterBuilder withKind(DiagnosticSeverity kind) {
            this.kind = kind;
            return this;
        }

        public Filter build() {
            Filter filter = new Filter(this);
            return filter;
        }
    }
}

