/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c;

import io.ballerina.c2c.CloudTomlResolver;
import io.ballerina.c2c.exceptions.KubernetesPluginException;
import io.ballerina.c2c.handlers.ChoreoHandler;
import io.ballerina.c2c.handlers.ConfigMapHandler;
import io.ballerina.c2c.handlers.DeploymentHandler;
import io.ballerina.c2c.handlers.DockerHandler;
import io.ballerina.c2c.handlers.HPAHandler;
import io.ballerina.c2c.handlers.JobHandler;
import io.ballerina.c2c.handlers.SecretHandler;
import io.ballerina.c2c.handlers.ServiceHandler;
import io.ballerina.c2c.models.DeploymentModel;
import io.ballerina.c2c.models.DockerModel;
import io.ballerina.c2c.models.KubernetesContext;
import io.ballerina.c2c.models.KubernetesDataHolder;
import io.ballerina.c2c.models.ServiceModel;
import io.ballerina.c2c.utils.KubernetesUtils;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArtifactManager {
    private static final Map<String, String> instructions = new LinkedHashMap<String, String>();
    private static final PrintStream OUT = System.out;
    private final KubernetesDataHolder kubernetesDataHolder = KubernetesContext.getInstance().getDataHolder();

    public void createArtifacts(String cloudType, boolean isNative) throws KubernetesPluginException {
        if (cloudType.equals("k8s")) {
            this.createKubernetesArtifacts(isNative);
        } else if (cloudType.equals("docker")) {
            this.createDockerArtifacts(isNative);
        } else {
            this.createChoreoArtifacts(isNative);
        }
    }

    public void createKubernetesArtifacts(boolean isNative) throws KubernetesPluginException {
        this.setDefaultKubernetesInstructions();
        OUT.println("\nGenerating artifacts\n");
        if (this.kubernetesDataHolder.getJobModel() != null) {
            new CloudTomlResolver().resolveToml(this.kubernetesDataHolder.getJobModel());
            new ConfigMapHandler().createArtifacts();
            new SecretHandler().createArtifacts();
            new JobHandler().createArtifacts();
        } else {
            new CloudTomlResolver().resolveToml(this.kubernetesDataHolder.getDeploymentModel());
            new ServiceHandler().createArtifacts();
            new ConfigMapHandler().createArtifacts();
            new SecretHandler().createArtifacts();
            new DeploymentHandler().createArtifacts();
            new HPAHandler().createArtifacts();
        }
        new DockerHandler(isNative).createArtifacts();
        this.printInstructions();
    }

    public void createDockerArtifacts(boolean isNative) throws KubernetesPluginException {
        OUT.println("\nGenerating artifacts\n");
        DockerModel dockerModel = this.getDockerModel(false);
        this.kubernetesDataHolder.setDockerModel(dockerModel);
        new DockerHandler(isNative).createArtifacts();
        String dockerRunCommand = "docker run -d " + this.generatePortInstruction(dockerModel.getPorts()) + dockerModel.getName();
        if (dockerModel.isTest()) {
            OUT.println("\nRunning the generated Docker image\n");
            KubernetesUtils.runCommand(dockerModel.getName());
            KubernetesUtils.deleteDockerImage(dockerModel.getName());
        } else {
            instructions.put("Execute the below command to run the generated Docker image: ", "\t" + dockerRunCommand);
            this.printInstructions();
        }
    }

    private DockerModel getDockerModel(boolean isTomlSkipped) throws KubernetesPluginException {
        List<ServiceModel> serviceModels = this.kubernetesDataHolder.getServiceModelList();
        DeploymentModel deploymentModel = this.kubernetesDataHolder.getDeploymentModel();
        for (ServiceModel serviceModel : serviceModels) {
            ContainerPort containerPort = ((ContainerPortBuilder)((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName(serviceModel.getPortName())).withContainerPort(serviceModel.getTargetPort())).withProtocol("TCP")).build();
            deploymentModel.addPort(containerPort);
        }
        if (!isTomlSkipped) {
            KubernetesUtils.resolveDockerToml(this.kubernetesDataHolder.getDeploymentModel());
        }
        return KubernetesUtils.getDockerModel(deploymentModel);
    }

    public void createChoreoArtifacts(boolean isNative) throws KubernetesPluginException {
        DockerModel dockerModel = this.getDockerModel(true);
        dockerModel.setBuildImage(false);
        this.kubernetesDataHolder.setDockerModel(dockerModel);
        new DockerHandler(isNative).createArtifacts();
        new ChoreoHandler().createArtifacts();
    }

    private String generatePortInstruction(Set<Integer> ports) {
        if (ports.size() == 0) {
            return "";
        }
        StringBuilder output = new StringBuilder();
        for (Integer port : ports) {
            output.append("-p ").append(port).append(":").append(port).append(" ");
        }
        return output.toString();
    }

    private void printInstructions() {
        for (Map.Entry<String, String> instruction : instructions.entrySet()) {
            KubernetesUtils.printInstruction(instruction.getKey());
            KubernetesUtils.printInstruction(instruction.getValue());
            KubernetesUtils.printInstruction("");
        }
    }

    public void populateDeploymentModel() {
        DeploymentModel deploymentModel = this.kubernetesDataHolder.getDeploymentModel();
        String deploymentName = this.kubernetesDataHolder.getOutputName();
        if (KubernetesUtils.isBlank(deploymentModel.getName()) && deploymentName != null) {
            deploymentModel.setName(KubernetesUtils.getValidName(deploymentName) + "-deployment");
        }
        if (KubernetesUtils.isBlank(deploymentModel.getImage())) {
            deploymentModel.setImage(deploymentName + ":latest");
        }
        deploymentModel.addLabel("app", deploymentName);
        this.kubernetesDataHolder.setDeploymentModel(deploymentModel);
    }

    private void setDefaultKubernetesInstructions() {
        instructions.put("Execute the below command to deploy the Kubernetes artifacts: ", "\tkubectl apply -f " + String.valueOf(this.kubernetesDataHolder.getK8sArtifactOutputPath().toAbsolutePath()));
        if (!this.kubernetesDataHolder.getServiceModelList().isEmpty()) {
            instructions.put("Execute the below command to access service via NodePort: ", "\tkubectl expose deployment " + this.kubernetesDataHolder.getDeploymentModel().getName() + " --type=NodePort --name=" + this.kubernetesDataHolder.getDeploymentModel().getName().replace("-deployment", "-svc-local"));
        }
    }
}

