/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c;

import io.ballerina.c2c.diagnostics.NullLocation;
import io.ballerina.c2c.exceptions.KubernetesPluginException;
import io.ballerina.c2c.models.ConfigMapModel;
import io.ballerina.c2c.models.DeploymentModel;
import io.ballerina.c2c.models.JobModel;
import io.ballerina.c2c.models.KubernetesContext;
import io.ballerina.c2c.models.KubernetesDataHolder;
import io.ballerina.c2c.models.KubernetesModel;
import io.ballerina.c2c.models.PersistentVolumeClaimModel;
import io.ballerina.c2c.models.SecretModel;
import io.ballerina.c2c.util.C2CDiagnosticCodes;
import io.ballerina.c2c.utils.KubernetesUtils;
import io.ballerina.c2c.utils.TomlHelper;
import io.ballerina.toml.api.Toml;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.Quantity;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;

public class CloudTomlResolver {
    public static final String CLOUD_DEPLOYMENT = "cloud.deployment.";
    KubernetesDataHolder dataHolder = KubernetesContext.getInstance().getDataHolder();

    public void resolveToml(JobModel jobModel) throws KubernetesPluginException {
        Toml ballerinaCloud = this.dataHolder.getBallerinaCloud();
        if (ballerinaCloud != null) {
            this.resolveEnvToml(jobModel, ballerinaCloud);
            this.resolveSettingsToml(ballerinaCloud);
            this.resolveConfigMapToml(ballerinaCloud);
            this.resolveConfigSecretToml(ballerinaCloud);
            this.resolveConfigFilesToml(jobModel, ballerinaCloud);
            this.resolveSecretToml(jobModel, ballerinaCloud);
        }
    }

    public void resolveToml(DeploymentModel deploymentModel) throws KubernetesPluginException {
        Toml ballerinaCloud = this.dataHolder.getBallerinaCloud();
        if (ballerinaCloud != null) {
            this.resolveDeploymentToml(deploymentModel, ballerinaCloud);
            this.resolveSettingsToml(ballerinaCloud);
            this.resolveResourcesToml(deploymentModel, ballerinaCloud);
            this.resolveEnvToml(deploymentModel, ballerinaCloud);
            this.resolveConfigMapToml(ballerinaCloud);
            this.resolveConfigSecretToml(ballerinaCloud);
            this.resolveConfigFilesToml(deploymentModel, ballerinaCloud);
            this.resolveSecretToml(deploymentModel, ballerinaCloud);
            this.resolveVolumes(deploymentModel, ballerinaCloud);
        }
    }

    private void resolveVolumes(DeploymentModel deploymentModel, Toml ballerinaCloud) {
        List volumes = ballerinaCloud.getTables("cloud.deployment.storage.volumes");
        HashSet<PersistentVolumeClaimModel> persistentVolumeClaimModels = new HashSet<PersistentVolumeClaimModel>();
        volumes.forEach(volume -> {
            PersistentVolumeClaimModel pv = new PersistentVolumeClaimModel();
            pv.setName(TomlHelper.getString(volume, "name"));
            pv.setMountPath(TomlHelper.getString(volume, "local_path"));
            pv.setVolumeClaimSizeAmount(TomlHelper.getString(volume, "size"));
            persistentVolumeClaimModels.add(pv);
        });
        deploymentModel.setVolumeClaimModels(persistentVolumeClaimModels);
    }

    private void resolveSettingsToml(Toml ballerinaCloud) {
        this.dataHolder.setSingleYaml(TomlHelper.getBoolean(ballerinaCloud, "settings.singleYAML", true));
        this.dataHolder.getDockerModel().setBuildImage(TomlHelper.getBoolean(ballerinaCloud, "settings.buildImage", true));
        this.dataHolder.getDockerModel().setThinJar(KubernetesUtils.isThinJar(ballerinaCloud, this.dataHolder.getDockerModel()));
    }

    private void resolveDeploymentToml(DeploymentModel deploymentModel, Toml ballerinaCloud) {
        deploymentModel.setReplicas(Math.toIntExact(TomlHelper.getLong(ballerinaCloud, "cloud.deployment.replicas", deploymentModel.getReplicas())));
        Optional probeToml = ballerinaCloud.getTable("cloud.deployment.probes.readiness");
        probeToml.ifPresent(toml -> deploymentModel.setReadinessProbe(this.resolveProbeToml((Toml)toml)));
        probeToml = ballerinaCloud.getTable("cloud.deployment.probes.liveness");
        probeToml.ifPresent(toml -> deploymentModel.setLivenessProbe(this.resolveProbeToml((Toml)toml)));
        deploymentModel.setInternalDomainName(TomlHelper.getString(ballerinaCloud, "cloud.deployment.internal_domain_name"));
    }

    private void resolveEnvToml(KubernetesModel model, Toml ballerinaCloud) {
        List envs = ballerinaCloud.getTables("cloud.config.envs");
        for (Toml env : envs) {
            EnvVar envVar = ((EnvVarBuilder)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.ConfigMapKeyRefNested)((EnvVarSourceFluent.ConfigMapKeyRefNested)((EnvVarBuilder)new EnvVarBuilder().withName(TomlHelper.getString(env, "name"))).withNewValueFrom().withNewConfigMapKeyRef().withKey(TomlHelper.getString(env, "key_ref"))).withName(TomlHelper.getString(env, "config_name"))).endConfigMapKeyRef()).endValueFrom()).build();
            if (KubernetesUtils.isBlank(envVar.getName())) {
                envVar.setName(TomlHelper.getString(env, "key_ref"));
            }
            model.addEnv(envVar);
        }
        List secrets = ballerinaCloud.getTables("cloud.secret.envs");
        for (Toml secret : secrets) {
            EnvVar envVar = ((EnvVarBuilder)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.SecretKeyRefNested)((EnvVarSourceFluent.SecretKeyRefNested)((EnvVarBuilder)new EnvVarBuilder().withName(TomlHelper.getString(secret, "name"))).withNewValueFrom().withNewSecretKeyRef().withKey(TomlHelper.getString(secret, "key_ref"))).withName(TomlHelper.getString(secret, "secret_name"))).endSecretKeyRef()).endValueFrom()).build();
            if (KubernetesUtils.isBlank(envVar.getName())) {
                envVar.setName(TomlHelper.getString(secret, "key_ref"));
            }
            model.addEnv(envVar);
        }
    }

    private void resolveResourcesToml(DeploymentModel deploymentModel, Toml deploymentToml) {
        Map<String, Quantity> requests = deploymentModel.getResourceRequirements().getRequests();
        String minMemory = TomlHelper.getString(deploymentToml, "cloud.deployment.min_memory");
        String minCPU = TomlHelper.getString(deploymentToml, "cloud.deployment.min_cpu");
        if (minMemory != null) {
            requests.put("memory", new Quantity(minMemory));
        }
        if (minCPU != null) {
            requests.put("cpu", new Quantity(minCPU));
        }
        Map<String, Quantity> limits = deploymentModel.getResourceRequirements().getLimits();
        String maxMemory = TomlHelper.getString(deploymentToml, "cloud.deployment.max_memory");
        String maxCPU = TomlHelper.getString(deploymentToml, "cloud.deployment.max_cpu");
        if (maxMemory != null) {
            limits.put("memory", new Quantity(maxMemory));
        }
        if (maxCPU != null) {
            limits.put("cpu", new Quantity(maxCPU));
        }
        deploymentModel.getResourceRequirements().setLimits(limits);
        deploymentModel.getResourceRequirements().setRequests(requests);
    }

    private void resolveConfigSecretToml(Toml toml) throws KubernetesPluginException {
        List secrets = toml.getTables("cloud.config.secrets");
        int secretsSize = secrets.size();
        for (int i = 0; i < secretsSize; ++i) {
            Toml secret = (Toml)secrets.get(i);
            Path path = Paths.get(Objects.requireNonNull(TomlHelper.getString(secret, "file")), new String[0]);
            String defaultValue = KubernetesUtils.getValidName("Config.toml".replace(".toml", "")) + "-secret";
            String name = TomlHelper.getString(secret, "name", defaultValue);
            SecretModel secretModel = new SecretModel();
            secretModel.setName(name);
            secretModel.setData(this.getData(path.toString(), true));
            secretModel.setMountPath(this.getSecretMountPath(i));
            secretModel.setBallerinaConf(true);
            this.dataHolder.addSecrets(Collections.singleton(secretModel));
        }
    }

    private String getSecretMountPath(int secretCount) {
        if (secretCount == 0) {
            return "/home/ballerina/secrets/";
        }
        return "/home/ballerina/secrets" + secretCount + "/";
    }

    private void resolveConfigMapToml(Toml toml) throws KubernetesPluginException {
        List configFiles = toml.getTables("cloud.config.files");
        int configFilesSize = configFiles.size();
        for (int i = 0; i < configFilesSize; ++i) {
            Toml configFile = (Toml)configFiles.get(i);
            ConfigMapModel configMapModel = new ConfigMapModel();
            String defaultValue = KubernetesUtils.getValidName("Config.toml".replace(".toml", "")) + "-config-map";
            String name = TomlHelper.getString(configFile, "name", defaultValue);
            Path path = Paths.get(Objects.requireNonNull(TomlHelper.getString(configFile, "file")), new String[0]);
            Path fileName = path.getFileName();
            if (fileName == null) {
                Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.INVALID_CONFIG_NAME, new NullLocation(), new Object[0]);
                throw new KubernetesPluginException(diagnostic);
            }
            Path dataFilePath = path;
            if (!path.isAbsolute()) {
                dataFilePath = KubernetesContext.getInstance().getDataHolder().getSourceRoot().resolve(dataFilePath).normalize();
            }
            String content = new String(KubernetesUtils.readFileContent(dataFilePath), StandardCharsets.UTF_8);
            Optional<ConfigMapModel> configMap = this.getConfigMapModel(name);
            if (configMap.isEmpty()) {
                configMapModel.setName(name);
                configMapModel.setMountPath(this.getConfMountPath(i));
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.put(fileName.toString(), content);
                configMapModel.setData(dataMap);
                configMapModel.setBallerinaConf(true);
                configMapModel.setReadOnly(false);
                configMapModel.setDir(false);
                this.dataHolder.addConfigMaps(Collections.singleton(configMapModel));
                continue;
            }
            ConfigMapModel existingConfigMap = configMap.get();
            Map<String, String> data = existingConfigMap.getData();
            if (data.containsKey(fileName.toString())) {
                Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.INVALID_CONFIG_FILE_NAME_TAKEN, new NullLocation(), new Object[0]);
                throw new KubernetesPluginException(diagnostic);
            }
            data.put(fileName.toString(), content);
        }
    }

    private String getConfMountPath(int confCount) {
        if (confCount == 0) {
            return "/home/ballerina/conf/";
        }
        return "/home/ballerina/conf" + confCount + "/";
    }

    private void resolveSecretToml(KubernetesModel kubernetesModel, Toml toml) throws KubernetesPluginException {
        List secrets = toml.getTables("cloud.secret.files");
        if (secrets.size() != 0) {
            String deploymentName = kubernetesModel.getName().replace("-deployment", "");
            int secretsSize = secrets.size();
            for (int i = 0; i < secretsSize; ++i) {
                Toml secret = (Toml)secrets.get(i);
                Path path = Paths.get(Objects.requireNonNull(TomlHelper.getString(secret, "file")), new String[0]);
                Path mountPath = Paths.get(Objects.requireNonNull(TomlHelper.getString(secret, "mount_dir", this.getSecretMountPath(i))), new String[0]);
                Path fileName = this.validatePaths(path, mountPath);
                File file = path.toFile();
                KubernetesUtils.validateFileExistence(file);
                SecretModel secretModel = new SecretModel();
                if (!mountPath.isAbsolute()) {
                    mountPath = Paths.get("/home/ballerina", mountPath.toString());
                }
                String mountPathSr = mountPath.toString();
                if (file.isDirectory()) {
                    secretModel.setDir(true);
                } else {
                    mountPathSr = this.getModifiedMountPath(mountPath.toString(), fileName.toString());
                }
                secretModel.setName(deploymentName + "-" + KubernetesUtils.getValidName(fileName.toString()) + "-secret" + i);
                secretModel.setData(this.getData(path.toString(), true));
                secretModel.setMountPath(mountPathSr);
                this.dataHolder.addSecrets(Collections.singleton(secretModel));
            }
        }
    }

    private String getModifiedMountPath(String mountDir, String fileName) {
        if (mountDir.endsWith("/")) {
            return mountDir + fileName;
        }
        return mountDir + "/" + fileName;
    }

    private Optional<ConfigMapModel> getConfigMapModel(String name) {
        Set<ConfigMapModel> configMapModelSet = this.dataHolder.getConfigMapModelSet();
        for (ConfigMapModel configMapModel : configMapModelSet) {
            if (!configMapModel.getName().equals(name)) continue;
            return Optional.of(configMapModel);
        }
        return Optional.empty();
    }

    public void resolveConfigFilesToml(KubernetesModel kubernetesModel, Toml toml) throws KubernetesPluginException {
        List configFiles = toml.getTables("cloud.config.maps");
        if (configFiles.size() != 0) {
            String deploymentName = kubernetesModel.getName().replace("-deployment", "");
            for (int i = 0; i < configFiles.size(); ++i) {
                Toml configFile = (Toml)configFiles.get(i);
                Path path = Paths.get(Objects.requireNonNull(TomlHelper.getString(configFile, "file")), new String[0]);
                Path mountPath = Paths.get(Objects.requireNonNull(TomlHelper.getString(configFile, "mount_dir")), new String[0]);
                Path fileName = this.validatePaths(path, mountPath);
                ConfigMapModel configMapModel = new ConfigMapModel();
                if (!mountPath.isAbsolute()) {
                    mountPath = Paths.get("/home/ballerina", mountPath.toString());
                }
                File file = path.toFile();
                KubernetesUtils.validateFileExistence(file);
                String mountPathSr = mountPath.toString();
                if (file.isDirectory()) {
                    configMapModel.setDir(true);
                } else {
                    mountPathSr = this.getModifiedMountPath(mountPath.toString(), fileName.toString());
                }
                configMapModel.setName(deploymentName + "-" + KubernetesUtils.getValidName(fileName.toString()) + "cfg" + i);
                configMapModel.setData(this.getData(path.toString(), false));
                configMapModel.setMountPath(mountPathSr);
                configMapModel.setBallerinaConf(false);
                this.dataHolder.addConfigMaps(Collections.singleton(configMapModel));
            }
        }
    }

    private Path validatePaths(Path path, Path mountPath) throws KubernetesPluginException {
        Path homePath = Paths.get("/home/ballerina", new String[0]);
        Path runtimePath = Paths.get("/ballerina/runtime", new String[0]);
        Path confPath = Paths.get("/home/ballerina/conf", new String[0]);
        Path secretPath = Paths.get("/home/ballerina/secrets", new String[0]);
        if (mountPath.equals(homePath)) {
            Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.INVALID_MOUNT_PATH_CLOUD, new NullLocation(), "ballerina home", "/home/ballerina");
            throw new KubernetesPluginException(diagnostic);
        }
        if (mountPath.equals(runtimePath)) {
            Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.INVALID_MOUNT_PATH_CLOUD, new NullLocation(), "ballerina runtime", "/ballerina/runtime");
            throw new KubernetesPluginException(diagnostic);
        }
        if (mountPath.equals(confPath)) {
            Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.INVALID_MOUNT_PATH_CLOUD, new NullLocation(), "ballerina conf file mount", "/home/ballerina/conf");
            throw new KubernetesPluginException(diagnostic);
        }
        if (mountPath.equals(secretPath)) {
            Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.INVALID_MOUNT_PATH_CLOUD, new NullLocation(), "ballerina secret file mount", "/home/ballerina/secrets");
            throw new KubernetesPluginException(diagnostic);
        }
        Path fileName = path.getFileName();
        if (fileName == null) {
            Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.EMPTY_PATH_CLOUD, new NullLocation(), "/home/ballerina/conf");
            throw new KubernetesPluginException(diagnostic);
        }
        return fileName;
    }

    private Map<String, String> getData(String path, boolean isSecret) throws KubernetesPluginException {
        File file;
        HashMap<String, String> dataMap = new HashMap<String, String>();
        Path dataFilePath = Paths.get(path, new String[0]);
        if (!dataFilePath.isAbsolute()) {
            dataFilePath = KubernetesContext.getInstance().getDataHolder().getSourceRoot().resolve(dataFilePath);
        }
        if (!(file = dataFilePath.toFile()).isDirectory()) {
            String key = String.valueOf(dataFilePath.getFileName());
            String content = this.getContent(KubernetesUtils.readFileContent(dataFilePath), isSecret);
            dataMap.put(key, content);
            return dataMap;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return dataMap;
        }
        for (File f : files) {
            if (f.isDirectory()) continue;
            String key = f.getName();
            String content = this.getContent(KubernetesUtils.readFileContent(f.toPath()), isSecret);
            dataMap.put(key, content);
        }
        return dataMap;
    }

    private String getContent(byte[] content, boolean isSecret) {
        if (isSecret) {
            return Base64.encodeBase64String(content);
        }
        return new String(content, StandardCharsets.UTF_8);
    }

    private Probe resolveProbeToml(Toml probeToml) {
        Probe probe = new ProbeBuilder().build();
        HTTPGetAction httpGet = new HTTPGetAction();
        Long port = TomlHelper.getLong(probeToml, "port");
        if (port != null) {
            httpGet.setPort(new IntOrString(Math.toIntExact(port)));
        }
        httpGet.setPath(TomlHelper.getString(probeToml, "path"));
        probe.setInitialDelaySeconds(30);
        probe.setHttpGet(httpGet);
        return probe;
    }
}

