/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.choreo;

import io.ballerina.c2c.util.C2CVisitor;
import io.ballerina.c2c.util.ModuleLevelVariableExtractor;
import io.ballerina.c2c.util.ServiceInfo;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

public class ProjectServiceInfo {
    private final List<ServiceInfo> serviceList = new ArrayList<ServiceInfo>();

    public ProjectServiceInfo(Project project, List<Diagnostic> diagnostics) {
        Package currentPackage = project.currentPackage();
        Iterable modules = currentPackage.modules();
        for (Module module : modules) {
            NodeVisitor visitor;
            Node node;
            Document document;
            Collection documentIds = module.documentIds();
            HashMap<String, Node> moduleLevelVariables = new HashMap<String, Node>();
            SemanticModel semanticModel = module.getCompilation().getSemanticModel();
            for (DocumentId doc : documentIds) {
                document = module.document(doc);
                node = document.syntaxTree().rootNode();
                visitor = new ModuleLevelVariableExtractor(moduleLevelVariables);
                node.accept(visitor);
            }
            for (DocumentId doc : documentIds) {
                document = module.document(doc);
                node = document.syntaxTree().rootNode();
                visitor = new C2CVisitor(moduleLevelVariables, semanticModel, diagnostics);
                node.accept(visitor);
                this.serviceList.addAll(visitor.getServices());
            }
        }
        if (this.serviceList.size() > 1) {
            NodeLocation location = this.serviceList.get(1).getNode().location();
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo("C2C_017", "choreo only supports one service at the moment", DiagnosticSeverity.WARNING);
            diagnostics.add(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]));
        }
    }

    @Generated
    public List<ServiceInfo> getServiceList() {
        return this.serviceList;
    }
}

