/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.handlers;

import io.ballerina.c2c.diagnostics.NullLocation;
import io.ballerina.c2c.exceptions.KubernetesPluginException;
import io.ballerina.c2c.handlers.AbstractArtifactHandler;
import io.ballerina.c2c.models.ConfigMapModel;
import io.ballerina.c2c.models.DeploymentModel;
import io.ballerina.c2c.models.PersistentVolumeClaimModel;
import io.ballerina.c2c.models.SecretModel;
import io.ballerina.c2c.util.C2CDiagnosticCodes;
import io.ballerina.c2c.utils.KubernetesUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Lifecycle;
import io.fabric8.kubernetes.api.model.LifecycleBuilder;
import io.fabric8.kubernetes.api.model.LifecycleFluent;
import io.fabric8.kubernetes.api.model.LifecycleHandlerFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DeploymentHandler
extends AbstractArtifactHandler {
    private List<VolumeMount> populateVolumeMounts(DeploymentModel deploymentModel) {
        ArrayList<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
        volumeMounts.addAll(KubernetesUtils.generateSecretVolumeMounts(deploymentModel.getSecretModels()));
        volumeMounts.addAll(KubernetesUtils.generateConfigMapVolumeMounts(deploymentModel.getConfigMapModels()));
        for (PersistentVolumeClaimModel volumeClaimModel : deploymentModel.getVolumeClaimModels()) {
            VolumeMount volumeMount = ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath(volumeClaimModel.getMountPath())).withName(volumeClaimModel.getName() + "-volume")).withReadOnly(volumeClaimModel.isReadOnly())).build();
            volumeMounts.add(volumeMount);
        }
        return volumeMounts;
    }

    private Container generateContainer(DeploymentModel deploymentModel, List<ContainerPort> containerPorts) {
        String dockerRegistry = deploymentModel.getRegistry();
        Object deploymentImageName = deploymentModel.getImage();
        if (null != dockerRegistry && !"".equals(dockerRegistry)) {
            deploymentImageName = dockerRegistry + "/" + (String)deploymentImageName;
        }
        Lifecycle preStop = ((LifecycleBuilder)((LifecycleFluent.PreStopNested)((LifecycleHandlerFluent.ExecNested)new LifecycleBuilder().withNewPreStop().withNewExec().withCommand("sleep", "15")).endExec()).endPreStop()).build();
        return ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(deploymentModel.getName())).withImage((String)deploymentImageName)).withPorts(containerPorts)).withEnv(deploymentModel.getEnvVars())).withVolumeMounts(this.populateVolumeMounts(deploymentModel))).withLivenessProbe(deploymentModel.getLivenessProbe())).withReadinessProbe(deploymentModel.getReadinessProbe())).withResources(deploymentModel.getResourceRequirements())).withLifecycle(preStop)).build();
    }

    private List<Volume> populateVolume(DeploymentModel deploymentModel) {
        Volume volume;
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        for (SecretModel secretModel : deploymentModel.getSecretModels()) {
            volume = ((VolumeBuilder)((VolumeFluent.SecretNested)((VolumeBuilder)new VolumeBuilder().withName(secretModel.getName() + "-volume")).withNewSecret().withSecretName(secretModel.getName())).endSecret()).build();
            if (secretModel.getDefaultMode() > 0) {
                volume.getSecret().setDefaultMode(secretModel.getDefaultMode());
            }
            volumes.add(volume);
        }
        for (ConfigMapModel configMapModel : deploymentModel.getConfigMapModels()) {
            volume = ((VolumeBuilder)((VolumeFluent.ConfigMapNested)((VolumeBuilder)new VolumeBuilder().withName(configMapModel.getName() + "-volume")).withNewConfigMap().withName(configMapModel.getName())).endConfigMap()).build();
            if (configMapModel.getDefaultMode() > 0) {
                volume.getConfigMap().setDefaultMode(configMapModel.getDefaultMode());
            }
            volumes.add(volume);
        }
        for (PersistentVolumeClaimModel volumeClaimModel : deploymentModel.getVolumeClaimModels()) {
            volume = ((VolumeBuilder)((VolumeFluent.PersistentVolumeClaimNested)((VolumeBuilder)new VolumeBuilder().withName(volumeClaimModel.getName() + "-volume")).withNewPersistentVolumeClaim().withClaimName(volumeClaimModel.getName())).endPersistentVolumeClaim()).build();
            volumes.add(volume);
        }
        return volumes;
    }

    private List<LocalObjectReference> getImagePullSecrets(DeploymentModel deploymentModel) {
        ArrayList<LocalObjectReference> imagePullSecrets = new ArrayList<LocalObjectReference>();
        for (String imagePullSecret : deploymentModel.getImagePullSecrets()) {
            imagePullSecrets.add(((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(imagePullSecret)).build());
        }
        return imagePullSecrets;
    }

    private void generate(DeploymentModel deploymentModel) throws KubernetesPluginException {
        List<ContainerPort> containerPorts = null;
        if (deploymentModel.getPorts() != null) {
            containerPorts = deploymentModel.getPorts();
        }
        Container container = this.generateContainer(deploymentModel, containerPorts);
        Deployment deployment = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(deploymentModel.getName())).withLabels(deploymentModel.getLabels())).withAnnotations(deploymentModel.getAnnotations())).withNamespace(this.dataHolder.getNamespace())).endMetadata()).withNewSpec().withNewSelector().withMatchLabels(deploymentModel.getLabels())).endSelector()).withStrategy(deploymentModel.getStrategy())).withReplicas(deploymentModel.getReplicas())).withNewTemplate().withNewMetadata().addToLabels(deploymentModel.getLabels())).addToAnnotations(deploymentModel.getPodAnnotations())).endMetadata()).withNewSpec().withContainers(container)).withImagePullSecrets(this.getImagePullSecrets(deploymentModel))).withVolumes(this.populateVolume(deploymentModel))).withNodeSelector(deploymentModel.getNodeSelector())).endSpec()).endTemplate()).endSpec()).build();
        try {
            String deploymentContent = KubernetesUtils.asYaml(deployment);
            Object outputFileName = "_deployment.yaml";
            if (this.dataHolder.isSingleYaml()) {
                outputFileName = deployment.getMetadata().getName() + ".yaml";
            }
            KubernetesUtils.writeToFile(deploymentContent, (String)outputFileName);
        }
        catch (IOException e) {
            Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.ARTIFACT_GEN_FAILED, new NullLocation(), "deployment", deploymentModel.getName());
            throw new KubernetesPluginException(diagnostic);
        }
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        DeploymentModel deploymentModel = this.dataHolder.getDeploymentModel();
        deploymentModel.setPodAutoscalerModel(this.dataHolder.getPodAutoscalerModel());
        deploymentModel.setSecretModels(this.dataHolder.getSecretModelSet());
        deploymentModel.setConfigMapModels(this.dataHolder.getConfigMapModelSet());
        if (null != deploymentModel.getLivenessProbe() && deploymentModel.getLivenessProbe().getHttpGet().getPort().getIntVal() == 0) {
            if (deploymentModel.getPorts().size() == 0) {
                Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.INVALID_PROBE, new NullLocation(), "liveness");
                throw new KubernetesPluginException(diagnostic);
            }
            deploymentModel.getLivenessProbe().getHttpGet().setPort(new IntOrString(deploymentModel.getPorts().iterator().next().getContainerPort()));
        }
        if (null != deploymentModel.getReadinessProbe() && deploymentModel.getReadinessProbe().getHttpGet().getPort().getIntVal() == 0) {
            if (deploymentModel.getPorts().size() == 0) {
                Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.INVALID_PROBE, new NullLocation(), "readiness");
                throw new KubernetesPluginException(diagnostic);
            }
            deploymentModel.getReadinessProbe().getHttpGet().setPort(new IntOrString(deploymentModel.getPorts().iterator().next().getContainerPort()));
        }
        KubernetesUtils.resolveDockerToml(deploymentModel);
        this.generate(deploymentModel);
        this.dataHolder.setDockerModel(KubernetesUtils.getDockerModel(deploymentModel));
        OUT.println("\t@kubernetes:Deployment");
    }
}

