/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.handlers;

import io.ballerina.c2c.diagnostics.NullLocation;
import io.ballerina.c2c.exceptions.KubernetesPluginException;
import io.ballerina.c2c.handlers.AbstractArtifactHandler;
import io.ballerina.c2c.models.DeploymentModel;
import io.ballerina.c2c.models.JobModel;
import io.ballerina.c2c.models.SecretModel;
import io.ballerina.c2c.util.C2CDiagnosticCodes;
import io.ballerina.c2c.utils.KubernetesUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public class SecretHandler
extends AbstractArtifactHandler {
    private void generate(SecretModel secretModel) throws KubernetesPluginException {
        Secret secret = ((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withNamespace(this.dataHolder.getNamespace())).withName(secretModel.getName())).endMetadata()).withData(secretModel.getData())).build();
        try {
            String secretContent = KubernetesUtils.asYaml(secret);
            Object outputFileName = "_secret.yaml";
            if (this.dataHolder.isSingleYaml()) {
                outputFileName = secret.getMetadata().getName() + ".yaml";
            }
            KubernetesUtils.writeToFile(secretContent, (String)outputFileName);
        }
        catch (IOException e) {
            Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.ARTIFACT_GEN_FAILED, new NullLocation(), "secret", secretModel.getName());
            throw new KubernetesPluginException(diagnostic);
        }
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        Set<SecretModel> secretModels = this.dataHolder.getSecretModelSet();
        StringBuilder configTomlEnv = new StringBuilder();
        for (SecretModel secretModel : secretModels) {
            if (secretModel.isBallerinaConf()) {
                configTomlEnv.append(this.getBALConfigFiles(secretModel));
            }
            this.generate(secretModel);
        }
        if (configTomlEnv.length() > 0) {
            List<EnvVar> envVars;
            JobModel jobModel = this.dataHolder.getJobModel();
            if (jobModel == null) {
                DeploymentModel deploymentModel = this.dataHolder.getDeploymentModel();
                envVars = deploymentModel.getEnvVars();
            } else {
                envVars = jobModel.getEnvVars();
            }
            if (this.isBalConfigFilesEnvExist(envVars)) {
                for (EnvVar envVar : envVars) {
                    if (!envVar.getName().equals("BAL_CONFIG_FILES")) continue;
                    String value = envVar.getValue() + String.valueOf(configTomlEnv);
                    envVar.setValue(value);
                }
            } else {
                EnvVar ballerinaConfEnv = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("BAL_CONFIG_FILES")).withValue(configTomlEnv.toString())).build();
                if (jobModel == null) {
                    DeploymentModel deploymentModel = this.dataHolder.getDeploymentModel();
                    deploymentModel.addEnv(ballerinaConfEnv);
                    this.dataHolder.setDeploymentModel(deploymentModel);
                } else {
                    jobModel.addEnv(ballerinaConfEnv);
                    this.dataHolder.setJobModel(jobModel);
                }
            }
        }
        OUT.println("\t@kubernetes:Secret");
    }

    private String getBALConfigFiles(SecretModel secretModel) {
        StringBuilder configPaths = new StringBuilder();
        for (String key : secretModel.getData().keySet()) {
            configPaths.append(secretModel.getMountPath()).append(key).append(":");
        }
        return configPaths.toString();
    }

    private boolean isBalConfigFilesEnvExist(List<EnvVar> envVars) {
        for (EnvVar envVar : envVars) {
            if (!envVar.getName().equals("BAL_CONFIG_FILES")) continue;
            return true;
        }
        return false;
    }
}

