/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.models;

import io.ballerina.c2c.models.ConfigMapModel;
import io.ballerina.c2c.models.KubernetesModel;
import io.ballerina.c2c.models.PersistentVolumeClaimModel;
import io.ballerina.c2c.models.PodAutoscalerModel;
import io.ballerina.c2c.models.SecretModel;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class DeploymentModel
extends KubernetesModel {
    private Map<String, String> podAnnotations;
    private int replicas = 1;
    private Probe livenessProbe;
    private Probe readinessProbe;
    private String namespace;
    private String image;
    private boolean buildImage;
    private String dockerHost;
    private String dockerCertPath;
    private List<ContainerPort> ports;
    private PodAutoscalerModel podAutoscalerModel;
    private Set<SecretModel> secretModels;
    private Set<ConfigMapModel> configMapModels;
    private Set<PersistentVolumeClaimModel> volumeClaimModels;
    private Set<String> imagePullSecrets;
    private String commandArgs;
    private String registry;
    private DeploymentStrategy strategy;
    private Map<String, String> nodeSelector;
    private String dockerConfigPath;
    private ResourceRequirements resourceRequirements;
    private String internalDomainName;

    public DeploymentModel() {
        this.envVars = new ArrayList();
        this.buildImage = true;
        this.labels = new LinkedHashMap();
        this.nodeSelector = new LinkedHashMap<String, String>();
        this.ports = new ArrayList<ContainerPort>();
        this.secretModels = new HashSet<SecretModel>();
        this.configMapModels = new HashSet<ConfigMapModel>();
        this.volumeClaimModels = new HashSet<PersistentVolumeClaimModel>();
        this.imagePullSecrets = new HashSet<String>();
        this.commandArgs = "";
        this.registry = "";
        HashMap<String, Quantity> limit = new HashMap<String, Quantity>();
        limit.put("cpu", new Quantity("500m"));
        limit.put("memory", new Quantity("512Mi"));
        HashMap<String, Quantity> resource = new HashMap<String, Quantity>();
        resource.put("cpu", new Quantity("200m"));
        resource.put("memory", new Quantity("100Mi"));
        this.resourceRequirements = ((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)new ResourceRequirementsBuilder().withLimits(limit)).withRequests(resource)).build();
    }

    public Map<String, String> getPodAnnotations() {
        return this.podAnnotations;
    }

    public void setLivenessProbe(Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    public void setReadinessProbe(Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    public void addPort(ContainerPort port) {
        this.ports.add(port);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeploymentModel)) {
            return false;
        }
        DeploymentModel other = (DeploymentModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getReplicas() != other.getReplicas()) {
            return false;
        }
        if (this.isBuildImage() != other.isBuildImage()) {
            return false;
        }
        Map<String, String> this$podAnnotations = this.getPodAnnotations();
        Map<String, String> other$podAnnotations = other.getPodAnnotations();
        if (this$podAnnotations == null ? other$podAnnotations != null : !((Object)this$podAnnotations).equals(other$podAnnotations)) {
            return false;
        }
        Probe this$livenessProbe = this.getLivenessProbe();
        Probe other$livenessProbe = other.getLivenessProbe();
        if (this$livenessProbe == null ? other$livenessProbe != null : !((Object)this$livenessProbe).equals(other$livenessProbe)) {
            return false;
        }
        Probe this$readinessProbe = this.getReadinessProbe();
        Probe other$readinessProbe = other.getReadinessProbe();
        if (this$readinessProbe == null ? other$readinessProbe != null : !((Object)this$readinessProbe).equals(other$readinessProbe)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$dockerHost = this.getDockerHost();
        String other$dockerHost = other.getDockerHost();
        if (this$dockerHost == null ? other$dockerHost != null : !this$dockerHost.equals(other$dockerHost)) {
            return false;
        }
        String this$dockerCertPath = this.getDockerCertPath();
        String other$dockerCertPath = other.getDockerCertPath();
        if (this$dockerCertPath == null ? other$dockerCertPath != null : !this$dockerCertPath.equals(other$dockerCertPath)) {
            return false;
        }
        List<ContainerPort> this$ports = this.getPorts();
        List<ContainerPort> other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        PodAutoscalerModel this$podAutoscalerModel = this.getPodAutoscalerModel();
        PodAutoscalerModel other$podAutoscalerModel = other.getPodAutoscalerModel();
        if (this$podAutoscalerModel == null ? other$podAutoscalerModel != null : !((Object)this$podAutoscalerModel).equals(other$podAutoscalerModel)) {
            return false;
        }
        Set<SecretModel> this$secretModels = this.getSecretModels();
        Set<SecretModel> other$secretModels = other.getSecretModels();
        if (this$secretModels == null ? other$secretModels != null : !((Object)this$secretModels).equals(other$secretModels)) {
            return false;
        }
        Set<ConfigMapModel> this$configMapModels = this.getConfigMapModels();
        Set<ConfigMapModel> other$configMapModels = other.getConfigMapModels();
        if (this$configMapModels == null ? other$configMapModels != null : !((Object)this$configMapModels).equals(other$configMapModels)) {
            return false;
        }
        Set<PersistentVolumeClaimModel> this$volumeClaimModels = this.getVolumeClaimModels();
        Set<PersistentVolumeClaimModel> other$volumeClaimModels = other.getVolumeClaimModels();
        if (this$volumeClaimModels == null ? other$volumeClaimModels != null : !((Object)this$volumeClaimModels).equals(other$volumeClaimModels)) {
            return false;
        }
        Set<String> this$imagePullSecrets = this.getImagePullSecrets();
        Set<String> other$imagePullSecrets = other.getImagePullSecrets();
        if (this$imagePullSecrets == null ? other$imagePullSecrets != null : !((Object)this$imagePullSecrets).equals(other$imagePullSecrets)) {
            return false;
        }
        String this$commandArgs = this.getCommandArgs();
        String other$commandArgs = other.getCommandArgs();
        if (this$commandArgs == null ? other$commandArgs != null : !this$commandArgs.equals(other$commandArgs)) {
            return false;
        }
        String this$registry = this.getRegistry();
        String other$registry = other.getRegistry();
        if (this$registry == null ? other$registry != null : !this$registry.equals(other$registry)) {
            return false;
        }
        DeploymentStrategy this$strategy = this.getStrategy();
        DeploymentStrategy other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !((Object)this$strategy).equals(other$strategy)) {
            return false;
        }
        Map<String, String> this$nodeSelector = this.getNodeSelector();
        Map<String, String> other$nodeSelector = other.getNodeSelector();
        if (this$nodeSelector == null ? other$nodeSelector != null : !((Object)this$nodeSelector).equals(other$nodeSelector)) {
            return false;
        }
        String this$dockerConfigPath = this.getDockerConfigPath();
        String other$dockerConfigPath = other.getDockerConfigPath();
        if (this$dockerConfigPath == null ? other$dockerConfigPath != null : !this$dockerConfigPath.equals(other$dockerConfigPath)) {
            return false;
        }
        ResourceRequirements this$resourceRequirements = this.getResourceRequirements();
        ResourceRequirements other$resourceRequirements = other.getResourceRequirements();
        if (this$resourceRequirements == null ? other$resourceRequirements != null : !((Object)this$resourceRequirements).equals(other$resourceRequirements)) {
            return false;
        }
        String this$internalDomainName = this.getInternalDomainName();
        String other$internalDomainName = other.getInternalDomainName();
        return !(this$internalDomainName == null ? other$internalDomainName != null : !this$internalDomainName.equals(other$internalDomainName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeploymentModel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getReplicas();
        result = result * 59 + (this.isBuildImage() ? 79 : 97);
        Map<String, String> $podAnnotations = this.getPodAnnotations();
        result = result * 59 + ($podAnnotations == null ? 43 : ((Object)$podAnnotations).hashCode());
        Probe $livenessProbe = this.getLivenessProbe();
        result = result * 59 + ($livenessProbe == null ? 43 : ((Object)$livenessProbe).hashCode());
        Probe $readinessProbe = this.getReadinessProbe();
        result = result * 59 + ($readinessProbe == null ? 43 : ((Object)$readinessProbe).hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $dockerHost = this.getDockerHost();
        result = result * 59 + ($dockerHost == null ? 43 : $dockerHost.hashCode());
        String $dockerCertPath = this.getDockerCertPath();
        result = result * 59 + ($dockerCertPath == null ? 43 : $dockerCertPath.hashCode());
        List<ContainerPort> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        PodAutoscalerModel $podAutoscalerModel = this.getPodAutoscalerModel();
        result = result * 59 + ($podAutoscalerModel == null ? 43 : ((Object)$podAutoscalerModel).hashCode());
        Set<SecretModel> $secretModels = this.getSecretModels();
        result = result * 59 + ($secretModels == null ? 43 : ((Object)$secretModels).hashCode());
        Set<ConfigMapModel> $configMapModels = this.getConfigMapModels();
        result = result * 59 + ($configMapModels == null ? 43 : ((Object)$configMapModels).hashCode());
        Set<PersistentVolumeClaimModel> $volumeClaimModels = this.getVolumeClaimModels();
        result = result * 59 + ($volumeClaimModels == null ? 43 : ((Object)$volumeClaimModels).hashCode());
        Set<String> $imagePullSecrets = this.getImagePullSecrets();
        result = result * 59 + ($imagePullSecrets == null ? 43 : ((Object)$imagePullSecrets).hashCode());
        String $commandArgs = this.getCommandArgs();
        result = result * 59 + ($commandArgs == null ? 43 : $commandArgs.hashCode());
        String $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : $registry.hashCode());
        DeploymentStrategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : ((Object)$strategy).hashCode());
        Map<String, String> $nodeSelector = this.getNodeSelector();
        result = result * 59 + ($nodeSelector == null ? 43 : ((Object)$nodeSelector).hashCode());
        String $dockerConfigPath = this.getDockerConfigPath();
        result = result * 59 + ($dockerConfigPath == null ? 43 : $dockerConfigPath.hashCode());
        ResourceRequirements $resourceRequirements = this.getResourceRequirements();
        result = result * 59 + ($resourceRequirements == null ? 43 : ((Object)$resourceRequirements).hashCode());
        String $internalDomainName = this.getInternalDomainName();
        result = result * 59 + ($internalDomainName == null ? 43 : $internalDomainName.hashCode());
        return result;
    }

    @Generated
    public int getReplicas() {
        return this.replicas;
    }

    @Generated
    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    @Generated
    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getImage() {
        return this.image;
    }

    @Generated
    public boolean isBuildImage() {
        return this.buildImage;
    }

    @Generated
    public String getDockerHost() {
        return this.dockerHost;
    }

    @Generated
    public String getDockerCertPath() {
        return this.dockerCertPath;
    }

    @Generated
    public List<ContainerPort> getPorts() {
        return this.ports;
    }

    @Generated
    public PodAutoscalerModel getPodAutoscalerModel() {
        return this.podAutoscalerModel;
    }

    @Generated
    public Set<SecretModel> getSecretModels() {
        return this.secretModels;
    }

    @Generated
    public Set<ConfigMapModel> getConfigMapModels() {
        return this.configMapModels;
    }

    @Generated
    public Set<PersistentVolumeClaimModel> getVolumeClaimModels() {
        return this.volumeClaimModels;
    }

    @Generated
    public Set<String> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    @Generated
    public String getCommandArgs() {
        return this.commandArgs;
    }

    @Generated
    public String getRegistry() {
        return this.registry;
    }

    @Generated
    public DeploymentStrategy getStrategy() {
        return this.strategy;
    }

    @Generated
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Generated
    public String getDockerConfigPath() {
        return this.dockerConfigPath;
    }

    @Generated
    public ResourceRequirements getResourceRequirements() {
        return this.resourceRequirements;
    }

    @Generated
    public String getInternalDomainName() {
        return this.internalDomainName;
    }

    @Generated
    public void setPodAnnotations(Map<String, String> podAnnotations) {
        this.podAnnotations = podAnnotations;
    }

    @Generated
    public void setReplicas(int replicas) {
        this.replicas = replicas;
    }

    @Generated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Generated
    public void setImage(String image) {
        this.image = image;
    }

    @Generated
    public void setBuildImage(boolean buildImage) {
        this.buildImage = buildImage;
    }

    @Generated
    public void setDockerHost(String dockerHost) {
        this.dockerHost = dockerHost;
    }

    @Generated
    public void setDockerCertPath(String dockerCertPath) {
        this.dockerCertPath = dockerCertPath;
    }

    @Generated
    public void setPorts(List<ContainerPort> ports) {
        this.ports = ports;
    }

    @Generated
    public void setPodAutoscalerModel(PodAutoscalerModel podAutoscalerModel) {
        this.podAutoscalerModel = podAutoscalerModel;
    }

    @Generated
    public void setSecretModels(Set<SecretModel> secretModels) {
        this.secretModels = secretModels;
    }

    @Generated
    public void setConfigMapModels(Set<ConfigMapModel> configMapModels) {
        this.configMapModels = configMapModels;
    }

    @Generated
    public void setVolumeClaimModels(Set<PersistentVolumeClaimModel> volumeClaimModels) {
        this.volumeClaimModels = volumeClaimModels;
    }

    @Generated
    public void setImagePullSecrets(Set<String> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    @Generated
    public void setCommandArgs(String commandArgs) {
        this.commandArgs = commandArgs;
    }

    @Generated
    public void setRegistry(String registry) {
        this.registry = registry;
    }

    @Generated
    public void setStrategy(DeploymentStrategy strategy) {
        this.strategy = strategy;
    }

    @Generated
    public void setNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    @Generated
    public void setDockerConfigPath(String dockerConfigPath) {
        this.dockerConfigPath = dockerConfigPath;
    }

    @Generated
    public void setResourceRequirements(ResourceRequirements resourceRequirements) {
        this.resourceRequirements = resourceRequirements;
    }

    @Generated
    public void setInternalDomainName(String internalDomainName) {
        this.internalDomainName = internalDomainName;
    }

    @Override
    @Generated
    public String toString() {
        return "DeploymentModel(podAnnotations=" + String.valueOf(this.getPodAnnotations()) + ", replicas=" + this.getReplicas() + ", livenessProbe=" + String.valueOf(this.getLivenessProbe()) + ", readinessProbe=" + String.valueOf(this.getReadinessProbe()) + ", namespace=" + this.getNamespace() + ", image=" + this.getImage() + ", buildImage=" + this.isBuildImage() + ", dockerHost=" + this.getDockerHost() + ", dockerCertPath=" + this.getDockerCertPath() + ", ports=" + String.valueOf(this.getPorts()) + ", podAutoscalerModel=" + String.valueOf(this.getPodAutoscalerModel()) + ", secretModels=" + String.valueOf(this.getSecretModels()) + ", configMapModels=" + String.valueOf(this.getConfigMapModels()) + ", volumeClaimModels=" + String.valueOf(this.getVolumeClaimModels()) + ", imagePullSecrets=" + String.valueOf(this.getImagePullSecrets()) + ", commandArgs=" + this.getCommandArgs() + ", registry=" + this.getRegistry() + ", strategy=" + String.valueOf(this.getStrategy()) + ", nodeSelector=" + String.valueOf(this.getNodeSelector()) + ", dockerConfigPath=" + this.getDockerConfigPath() + ", resourceRequirements=" + String.valueOf(this.getResourceRequirements()) + ", internalDomainName=" + this.getInternalDomainName() + ")";
    }
}

