/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.tasks;

import io.ballerina.c2c.exceptions.KubernetesPluginException;
import io.ballerina.c2c.models.DeploymentModel;
import io.ballerina.c2c.models.JobModel;
import io.ballerina.c2c.models.KubernetesContext;
import io.ballerina.c2c.models.KubernetesDataHolder;
import io.ballerina.c2c.models.PodAutoscalerModel;
import io.ballerina.c2c.models.ServiceModel;
import io.ballerina.c2c.util.ListenerInfo;
import io.ballerina.c2c.util.ProjectServiceInfo;
import io.ballerina.c2c.util.ScheduledTask;
import io.ballerina.c2c.util.ServiceInfo;
import io.ballerina.c2c.util.Task;
import io.ballerina.c2c.utils.KubernetesUtils;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.CompilationAnalysisContext;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.List;

public class C2CAnalysisTask
implements AnalysisTask<CompilationAnalysisContext> {
    public void perform(CompilationAnalysisContext compilationAnalysisContext) {
        Package currentPackage = compilationAnalysisContext.currentPackage();
        Project project = compilationAnalysisContext.currentPackage().project();
        String cloud = project.buildOptions().cloud();
        if (cloud == null || !KubernetesUtils.isBuildOptionDockerOrK8s(cloud)) {
            return;
        }
        KubernetesContext.getInstance().setCurrentPackage(KubernetesUtils.getProjectID(currentPackage));
        KubernetesDataHolder dataHolder = KubernetesContext.getInstance().getDataHolder();
        dataHolder.setPackageID(KubernetesUtils.getProjectID(currentPackage));
        ArrayList<Diagnostic> c2cDiagnostics = new ArrayList<Diagnostic>();
        ProjectServiceInfo projectServiceInfo = new ProjectServiceInfo(currentPackage.project(), c2cDiagnostics);
        List<ServiceInfo> serviceList = projectServiceInfo.getServiceList();
        try {
            this.addServices(serviceList);
        }
        catch (KubernetesPluginException e) {
            compilationAnalysisContext.reportDiagnostic(e.getDiagnostic());
        }
        for (Diagnostic diagnostic : c2cDiagnostics) {
            compilationAnalysisContext.reportDiagnostic(diagnostic);
        }
        this.addDeployments();
        this.addHPA();
        this.addJobs(projectServiceInfo);
    }

    private void addJobs(ProjectServiceInfo projectServiceInfo) {
        if (projectServiceInfo.getTask().isPresent()) {
            String dockerCertPath;
            String dockerHost;
            Task task = projectServiceInfo.getTask().get();
            JobModel jobModel = new JobModel();
            if (task instanceof ScheduledTask) {
                jobModel.setSchedule(((ScheduledTask)task).getSchedule());
            }
            if (!KubernetesUtils.isBlank(dockerHost = System.getenv("DOCKER_HOST"))) {
                jobModel.setDockerHost(dockerHost);
            }
            if (!KubernetesUtils.isBlank(dockerCertPath = System.getenv("DOCKER_CERT_PATH"))) {
                jobModel.setDockerCertPath(dockerCertPath);
            }
            KubernetesContext.getInstance().getDataHolder().setJobModel(jobModel);
        }
    }

    private void addServices(List<ServiceInfo> serviceList) throws KubernetesPluginException {
        for (ServiceInfo serviceInfo : serviceList) {
            List<ListenerInfo> listeners = serviceInfo.getListeners();
            for (ListenerInfo listener : listeners) {
                ServiceModel serviceModel = new ServiceModel();
                if (KubernetesUtils.isBlank(serviceModel.getName())) {
                    serviceModel.setName(KubernetesUtils.getValidName(serviceInfo.getServicePath() + "-svc"));
                }
                int port = listener.getPort();
                if (serviceModel.getPort() == -1) {
                    serviceModel.setPort(port);
                }
                if (serviceModel.getTargetPort() == -1) {
                    serviceModel.setTargetPort(port);
                }
                serviceModel.setProtocol("http");
                KubernetesContext.getInstance().getDataHolder().addServiceModel(serviceModel);
            }
        }
    }

    private void addHPA() {
        PodAutoscalerModel podAutoscalerModel = new PodAutoscalerModel();
        KubernetesContext.getInstance().getDataHolder().setPodAutoscalerModel(podAutoscalerModel);
    }

    private void addDeployments() {
        String dockerCertPath;
        DeploymentModel deploymentModel = new DeploymentModel();
        String dockerHost = System.getenv("DOCKER_HOST");
        if (!KubernetesUtils.isBlank(dockerHost)) {
            deploymentModel.setDockerHost(dockerHost);
        }
        if (!KubernetesUtils.isBlank(dockerCertPath = System.getenv("DOCKER_CERT_PATH"))) {
            deploymentModel.setDockerCertPath(dockerCertPath);
        }
        KubernetesContext.getInstance().getDataHolder().setDeploymentModel(deploymentModel);
    }
}

