/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.util;

import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;

public enum C2CDiagnosticCodes {
    PATH_CONTENT_READ_FAILED("C2C_001", "unable to read contents of the file `%s`", DiagnosticSeverity.ERROR),
    FAILED_PORT_RETRIEVAL("C2C_002", "failed to retrieve port", DiagnosticSeverity.WARNING),
    VALUE_STRING_ONLY_SUPPORTED("C2C_003", "https config extraction only supports basic string paths", DiagnosticSeverity.WARNING),
    CONFIGURABLE_NO_DEFAULT("C2C_005", "default value is not specified for the configurable variable `%s`. cloud artifacts will not be generated for this variable", DiagnosticSeverity.WARNING),
    CONFIGURABLE_OVERRIDE("C2C_006", "default value of configurable variable `%s` could be overridden in runtime", DiagnosticSeverity.WARNING),
    DIRECTORY_DELETE_FAILED("C2C_007", "unable to delete directory: `%s`", DiagnosticSeverity.WARNING),
    DOCKER_FAILED("C2C_008", "error occurred creating docker image", DiagnosticSeverity.ERROR),
    INVALID_MOUNT_PATH("C2C_009", "Invalid mount path: `%s`. Providing relative path in the same level as source file is not supported with code2cloud.Please create a sub folder and provide the relative path. eg: './security/ballerinaKeystore.p12'", DiagnosticSeverity.WARNING),
    ARTIFACT_GEN_FAILED("C2C_010", "error while generating yaml file for `%s`: `%s`", DiagnosticSeverity.WARNING),
    ONLY_ONE_BALLERINA_CONFIG_ALLOWED("C2C_011", "only one ballerina config is allowed", DiagnosticSeverity.ERROR),
    INVALID_PROBE("C2C_012", "unable to detect port for `%s` probe.", DiagnosticSeverity.ERROR),
    INVALID_CONFIG_NAME("C2C_013", "invalid config file name", DiagnosticSeverity.ERROR),
    INVALID_MOUNT_PATH_CLOUD("C2C_014", "Cloud.toml error mount_path cannot be `%s`: `%s`", DiagnosticSeverity.ERROR),
    EMPTY_PATH_CLOUD("C2C_015", "Cloud.toml error invalid path without file name `%s`", DiagnosticSeverity.ERROR),
    PATH_CONTENT_READ_FAILED_WARN("C2C_006", "unable to read contents of the file `%s`", DiagnosticSeverity.WARNING),
    FAILED_VARIABLE_RETRIEVAL("C2C_016", "unable to retrieve the value of variable `%s`", DiagnosticSeverity.WARNING),
    INVALID_CONFIG_FILE_NAME_TAKEN("C2C_017", "duplicate file under the same config map", DiagnosticSeverity.ERROR),
    FAILED_DEFAULTABLE_PORT_RETRIEVAL("C2C_018", "failed to retrieve port. defaultable ports are not supported", DiagnosticSeverity.WARNING);

    private final String code;
    private final String message;
    private final DiagnosticSeverity severity;

    private C2CDiagnosticCodes(String code, String message, DiagnosticSeverity severity) {
        this.code = code;
        this.message = message;
        this.severity = severity;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public DiagnosticSeverity getSeverity() {
        return this.severity;
    }

    public static Diagnostic createDiagnostic(C2CDiagnosticCodes diagnostic, Location location, Object ... args) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnostic.getCode(), String.format(diagnostic.getMessage(), args), diagnostic.getSeverity());
        return DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]);
    }
}

