/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.utils;

import io.ballerina.projects.TomlDocument;
import io.ballerina.toml.api.Toml;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlBooleanValueNode;
import io.ballerina.toml.semantic.ast.TomlLongValueNode;
import io.ballerina.toml.semantic.ast.TomlStringValueNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.diagnostics.DiagnosticComparator;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.toml.syntax.tree.SyntaxTree;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;

public class TomlHelper {
    public static String getString(Toml toml, String key) {
        Optional valueNode = toml.get(key);
        if (valueNode.isEmpty()) {
            return null;
        }
        TomlValueNode tomlValueNode = (TomlValueNode)valueNode.get();
        if (tomlValueNode.kind() == TomlType.STRING) {
            return (String)((TomlStringValueNode)tomlValueNode).getValue();
        }
        return null;
    }

    public static String getString(Toml toml, String key, String defaultValue) {
        String output = TomlHelper.getString(toml, key);
        if (output == null) {
            return defaultValue;
        }
        return output;
    }

    public static Long getLong(Toml toml, String key) {
        Optional valueNode = toml.get(key);
        if (valueNode.isEmpty()) {
            return null;
        }
        TomlValueNode tomlValueNode = (TomlValueNode)valueNode.get();
        if (tomlValueNode.kind() == TomlType.INTEGER) {
            return (Long)((TomlLongValueNode)tomlValueNode).getValue();
        }
        return null;
    }

    public static long getLong(Toml toml, String key, long defaultValue) {
        Long output = TomlHelper.getLong(toml, key);
        if (output == null) {
            return defaultValue;
        }
        return output;
    }

    public static boolean getBoolean(Toml toml, String key, boolean defaultValue) {
        Optional valueNode = toml.get(key);
        if (valueNode.isEmpty()) {
            return defaultValue;
        }
        TomlValueNode tomlValueNode = (TomlValueNode)valueNode.get();
        if (tomlValueNode.kind() == TomlType.BOOLEAN) {
            return (Boolean)((TomlBooleanValueNode)tomlValueNode).getValue();
        }
        return defaultValue;
    }

    public static Toml createK8sTomlFromProject(TomlDocument tomlDocument) {
        TomlTableNode astNode = tomlDocument.toml().rootNode();
        astNode.clearDiagnostics();
        astNode.addSyntaxDiagnostics(TomlHelper.reportSyntaxDiagnostics(tomlDocument.syntaxTree()));
        return new Toml(astNode);
    }

    public static Set<Diagnostic> reportSyntaxDiagnostics(SyntaxTree tree) {
        TreeSet<Diagnostic> diagnostics = new TreeSet<Diagnostic>((Comparator<Diagnostic>)new DiagnosticComparator());
        for (Diagnostic syntaxDiagnostic : tree.diagnostics()) {
            TomlNodeLocation tomlNodeLocation = new TomlNodeLocation(syntaxDiagnostic.location().lineRange(), syntaxDiagnostic.location().textRange());
            TomlDiagnostic tomlDiagnostic = new TomlDiagnostic(tomlNodeLocation, syntaxDiagnostic.diagnosticInfo(), syntaxDiagnostic.message());
            diagnostics.add((Diagnostic)tomlDiagnostic);
        }
        return diagnostics;
    }
}

