/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.config.model;

import java.util.concurrent.TimeUnit;
import org.wso2.carbon.config.annotation.Configuration;
import org.wso2.carbon.config.annotation.Element;

@Configuration(description="Parameters for reservoir implementations")
public class ReservoirParametersConfig {
    @Element(description="The number of measurements to store in SLIDING_WINDOW reservoir or number of samples to keep in UNIFORM reservoir")
    private int size = 1028;
    @Element(description="The window of time in SLIDING_TIME_WINDOW reservoir")
    private long window = 1L;
    @Element(description="The unit of window in SLIDING_TIME_WINDOW reservoir. See java.util.concurrent.TimeUnit")
    private TimeUnit windowUnit = TimeUnit.HOURS;
    @Element(description="The precision to use in the Recorder to be used in HDR_HISTOGRAM reservoir")
    private int numberOfSignificantValueDigits = 2;
    @Element(description="Reset the HdrHistogram when taking a snapshot")
    private boolean resetOnSnapshot;

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public long getWindow() {
        return this.window;
    }

    public void setWindow(long window) {
        this.window = window;
    }

    public TimeUnit getWindowUnit() {
        return this.windowUnit;
    }

    public void setWindowUnit(TimeUnit windowUnit) {
        this.windowUnit = windowUnit;
    }

    public int getNumberOfSignificantValueDigits() {
        return this.numberOfSignificantValueDigits;
    }

    public void setNumberOfSignificantValueDigits(int numberOfSignificantValueDigits) {
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
    }

    public boolean isResetOnSnapshot() {
        return this.resetOnSnapshot;
    }

    public void setResetOnSnapshot(boolean resetOnSnapshot) {
        this.resetOnSnapshot = resetOnSnapshot;
    }
}

