/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.converters;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.ballerina.converters.JsonToRecordConverter;
import io.ballerina.converters.JsonToRecordRequest;
import io.ballerina.converters.exception.JsonToRecordConverterException;
import io.ballerina.jsonmapper.JsonToRecordMapper;
import io.ballerina.jsonmapper.JsonToRecordResponse;
import io.ballerina.jsonmapper.diagnostic.DiagnosticMessage;
import io.ballerina.jsonmapper.diagnostic.DiagnosticUtils;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="jsonToRecord")
public class JsonToRecordConverterService
implements ExtendedLanguageServerService {
    private WorkspaceManager workspaceManager;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager) {
        super.init(langServer, workspaceManager);
        this.workspaceManager = workspaceManager;
    }

    public Class<?> getRemoteInterface() {
        return this.getClass();
    }

    @JsonRequest
    public CompletableFuture<JsonToRecordResponse> convert(JsonToRecordRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            JsonToRecordResponse response;
            block5: {
                response = new JsonToRecordResponse();
                String jsonString = request.getJsonString();
                String recordName = request.getRecordName();
                boolean isRecordTypeDesc = request.getIsRecordTypeDesc();
                boolean isClosed = request.getIsClosed();
                boolean forceFormatRecordFields = request.getForceFormatRecordFields();
                String filePathUri = request.getFilePathUri();
                boolean isNullAsOptional = request.getIsNullAsOptional();
                try {
                    JsonElement parsedJson = JsonParser.parseString(jsonString);
                    if (parsedJson.isJsonObject() && parsedJson.getAsJsonObject().has("$schema")) {
                        try {
                            response.setCodeBlock(JsonToRecordConverter.convert(jsonString, recordName, isRecordTypeDesc, isClosed, forceFormatRecordFields).getCodeBlock());
                            break block5;
                        }
                        catch (JsonToRecordConverterException | IOException | NullPointerException | FormatterException e) {
                            DiagnosticMessage message = DiagnosticMessage.jsonToRecordConverter100(null);
                            return DiagnosticUtils.getDiagnosticResponse(List.of(message), response);
                        }
                    }
                    response = JsonToRecordMapper.convert(jsonString, recordName, isRecordTypeDesc, isClosed, forceFormatRecordFields, filePathUri, this.workspaceManager, isNullAsOptional);
                }
                catch (JsonSyntaxException e) {
                    DiagnosticMessage message = DiagnosticMessage.jsonToRecordConverter100(new String[]{e.getMessage()});
                    return DiagnosticUtils.getDiagnosticResponse(List.of(message), response);
                }
            }
            return response;
        });
    }

    public String getName() {
        return "jsonToRecord";
    }
}

