/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.converters.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.ballerina.converters.exception.JsonToRecordConverterException;
import io.ballerina.converters.util.ErrorMessages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class SchemaGenerator {
    private SchemaGenerator() {
    }

    public static Map<String, Object> generate(JsonNode json) throws JsonToRecordConverterException {
        HashMap<String, Object> schema = new HashMap<String, Object>();
        if (json.getNodeType() == JsonNodeType.MISSING || json.getNodeType() == JsonNodeType.POJO || json.getNodeType() == JsonNodeType.BINARY) {
            throw new JsonToRecordConverterException(ErrorMessages.unsupportedType());
        }
        if (json.getNodeType() == JsonNodeType.STRING) {
            schema.put("type", "string");
            return schema;
        }
        if (json.getNodeType() == JsonNodeType.BOOLEAN) {
            schema.put("type", "boolean");
            return schema;
        }
        if (json.getNodeType() == JsonNodeType.NUMBER) {
            if (json.isInt()) {
                schema.put("type", "integer");
            } else {
                schema.put("type", "number");
            }
            return schema;
        }
        if (json.getNodeType() == JsonNodeType.ARRAY && json instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)json;
            schema.put("type", "array");
            if (array.isEmpty()) {
                schema.put("items", new HashMap());
            } else {
                schema.put("items", SchemaGenerator.generate(array.get(0)));
            }
            return schema;
        }
        if (json.getNodeType() == JsonNodeType.NULL) {
            schema.put("type", "json");
            return schema;
        }
        if (!(json instanceof ObjectNode)) {
            throw new JsonToRecordConverterException(ErrorMessages.parserException(json.toString()));
        }
        ObjectNode object = (ObjectNode)json;
        schema.put("type", "object");
        if (object.isEmpty()) {
            schema.put("properties", new HashMap());
        } else {
            HashMap<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>();
            ArrayList<String> required = new ArrayList<String>();
            Iterator<Map.Entry<String, JsonNode>> iterator = object.fields();
            while (iterator.hasNext()) {
                Map.Entry<String, JsonNode> property = iterator.next();
                properties.put(property.getKey(), SchemaGenerator.generate(property.getValue()));
                required.add(property.getKey());
            }
            schema.put("properties", properties);
            schema.put("required", required);
            schema.put("additionalProperties", false);
        }
        return schema;
    }
}

