/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.syntaxapicallsgen.config;

import com.google.gson.Gson;
import io.ballerina.syntaxapicallsgen.SyntaxApiCallsGen;
import io.ballerina.syntaxapicallsgen.config.SyntaxTreeDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SyntaxApiCallsGenConfig {
    public static final String SYNTAX_TREE_DESCRIPTOR_FILE = "api_gen_syntax_tree_descriptor.json";
    private final File templateFile;
    private final Formatter formatter;
    private final int formatterTabStart;
    private final long parserTimeout;
    private final boolean ignoreMinutiae;
    private final Parser parser;

    private SyntaxApiCallsGenConfig(Builder builder) {
        this.templateFile = builder.templateFile;
        this.formatter = builder.formatter;
        this.formatterTabStart = builder.formatterTabStart;
        this.parserTimeout = builder.parserTimeout;
        this.ignoreMinutiae = builder.ignoreMinutiae;
        this.parser = builder.parser;
    }

    public String readTemplateFile() throws IOException {
        return Files.readString(this.templateFile.toPath(), Charset.defaultCharset());
    }

    public boolean useTemplate() {
        return this.templateFile != null;
    }

    public Formatter formatter() {
        return this.formatter;
    }

    public int formatterTabStart() {
        return this.formatterTabStart;
    }

    public Parser parser() {
        return this.parser;
    }

    public long parserTimeout() {
        return this.parserTimeout;
    }

    public boolean ignoreMinutiae() {
        return this.ignoreMinutiae;
    }

    public Map<String, List<String>> readChildNamesJson() {
        ClassLoader classLoader = SyntaxApiCallsGen.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(SYNTAX_TREE_DESCRIPTOR_FILE);
        Gson gson = new Gson();
        Objects.requireNonNull(inputStream, "File open failed");
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        SyntaxTreeDescriptor syntaxTreeDescriptor = (SyntaxTreeDescriptor)gson.fromJson((Reader)reader, SyntaxTreeDescriptor.class);
        return syntaxTreeDescriptor.getChildNames();
    }

    public static class Builder {
        private File templateFile;
        private Formatter formatter;
        private int formatterTabStart = 0;
        private long parserTimeout = 10000L;
        private boolean ignoreMinutiae = false;
        private Parser parser;

        public Builder templateFile(File templateFile) {
            this.templateFile = templateFile;
            return this;
        }

        public Builder formatter(Formatter formatter) {
            this.formatter = formatter;
            return this;
        }

        public Builder formatterTabStart(int formatterTabStart) {
            this.formatterTabStart = formatterTabStart;
            return this;
        }

        public Builder parser(Parser parser) {
            this.parser = parser;
            return this;
        }

        public Builder parserTimeout(long parserTimeout) {
            this.parserTimeout = parserTimeout;
            return this;
        }

        public Builder ignoreMinutiae(boolean ignoreMinutiae) {
            this.ignoreMinutiae = ignoreMinutiae;
            return this;
        }

        public SyntaxApiCallsGenConfig build() {
            this.parser = Objects.requireNonNullElse(this.parser, Parser.MODULE);
            this.formatter = Objects.requireNonNullElse(this.formatter, Formatter.DEFAULT);
            return new SyntaxApiCallsGenConfig(this);
        }
    }

    public static enum Formatter {
        NONE,
        DEFAULT,
        VARIABLE;

    }

    public static enum Parser {
        EXPRESSION,
        STATEMENT,
        MODULE;

    }
}

