/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.syntaxapicallsgen.formatter;

import io.ballerina.syntaxapicallsgen.formatter.SegmentFormatter;
import io.ballerina.syntaxapicallsgen.segment.Segment;

public class DefaultFormatter
extends SegmentFormatter {
    private static final char OPEN_PAREN = '(';
    private static final char CLOSE_PAREN = ')';
    private static final char COMMA = ',';
    private static final char QUOTE = '\"';
    private static final char ESCAPE = '\\';
    private static final String TAB_CHAR = "    ";

    private boolean commaInsideParenPresent(StringBuilder input, int position) {
        for (int i = position + 1; i < input.length(); ++i) {
            if (input.charAt(i) == ')') {
                return false;
            }
            if (input.charAt(i) != ',' && input.charAt(i) != '(') continue;
            return true;
        }
        return false;
    }

    @Override
    public String format(Segment segment) {
        StringBuilder output = new StringBuilder();
        StringBuilder input = segment.stringBuilder();
        boolean isCurrentlyInStringLiteral = false;
        boolean foundCommaInCurrentParen = false;
        int depth = 0;
        for (int position = 0; position < input.length(); ++position) {
            char character = input.charAt(position);
            if (character == '\"' && input.charAt(position - 1) != '\\') {
                isCurrentlyInStringLiteral = !isCurrentlyInStringLiteral;
                output.append(character);
                continue;
            }
            if (isCurrentlyInStringLiteral) {
                output.append(character);
                continue;
            }
            if (character == '(') {
                output.append(character);
                foundCommaInCurrentParen = this.commaInsideParenPresent(input, position);
                if (!foundCommaInCurrentParen) continue;
                output.append(System.lineSeparator()).append(this.tab(++depth));
                continue;
            }
            if (character == ')') {
                if (input.charAt(position - 1) != '(' && foundCommaInCurrentParen) {
                    output.append(System.lineSeparator()).append(this.tab(--depth));
                }
                foundCommaInCurrentParen = true;
                output.append(character);
                continue;
            }
            if (character == ',') {
                output.append(character).append(System.lineSeparator()).append(this.tab(depth));
                continue;
            }
            output.append(character);
        }
        return output.toString();
    }

    private String tab(int depth) {
        return TAB_CHAR.repeat(depth);
    }
}

