/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.syntaxapicallsgen.segment.factories;

import io.ballerina.compiler.syntax.tree.DocumentationLineToken;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.LiteralValueToken;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.syntaxapicallsgen.segment.NodeFactorySegment;
import io.ballerina.syntaxapicallsgen.segment.factories.MinutiaeSegmentFactory;
import io.ballerina.syntaxapicallsgen.segment.factories.SegmentFactory;

public class TokenSegmentFactory {
    private static final String CREATE_LITERAL_METHOD_NAME = "createLiteralValueToken";
    private static final String CREATE_IDENTIFIER_METHOD_NAME = "createIdentifierToken";
    private static final String CREATE_DOC_LINE_METHOD_NAME = "createDocumentationLineToken";
    private static final String CREATE_TOKEN_METHOD_NAME = "createToken";
    private final boolean ignoreMinutiae;

    public TokenSegmentFactory(boolean ignoreMinutiae) {
        this.ignoreMinutiae = ignoreMinutiae;
    }

    public NodeFactorySegment createTokenSegment(Token token) {
        boolean hasNoMinutiae;
        NodeFactorySegment root;
        boolean canSkipMinutiae = false;
        if (token instanceof LiteralValueToken) {
            root = SegmentFactory.createNodeFactorySegment(CREATE_LITERAL_METHOD_NAME);
            root.addParameter(SegmentFactory.createSyntaxKindSegment(token.kind()));
            root.addParameter(SegmentFactory.createStringSegment(token.text()));
        } else if (token instanceof IdentifierToken) {
            root = SegmentFactory.createNodeFactorySegment(CREATE_IDENTIFIER_METHOD_NAME);
            root.addParameter(SegmentFactory.createStringSegment(token.text()));
            canSkipMinutiae = true;
        } else if (token instanceof DocumentationLineToken) {
            root = SegmentFactory.createNodeFactorySegment(CREATE_DOC_LINE_METHOD_NAME);
            root.addParameter(SegmentFactory.createStringSegment(token.text()));
        } else {
            root = SegmentFactory.createNodeFactorySegment(CREATE_TOKEN_METHOD_NAME);
            root.addParameter(SegmentFactory.createSyntaxKindSegment(token.kind()));
            canSkipMinutiae = true;
        }
        boolean bl = hasNoMinutiae = token.leadingMinutiae().isEmpty() && token.trailingMinutiae().isEmpty();
        if (canSkipMinutiae && (this.ignoreMinutiae || hasNoMinutiae)) {
            return root;
        }
        if (this.ignoreMinutiae) {
            root.addParameter(MinutiaeSegmentFactory.createMinutiaeListSegment(NodeFactory.createEmptyMinutiaeList()));
            root.addParameter(MinutiaeSegmentFactory.createMinutiaeListSegment(NodeFactory.createEmptyMinutiaeList()));
            return root;
        }
        root.addParameter(MinutiaeSegmentFactory.createMinutiaeListSegment(token.leadingMinutiae()));
        root.addParameter(MinutiaeSegmentFactory.createMinutiaeListSegment(token.trailingMinutiae()));
        return root;
    }
}

