/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.syntaxapicallsgen.segment.factories.cache;

import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.syntaxapicallsgen.SyntaxApiCallsGenException;
import io.ballerina.syntaxapicallsgen.segment.factories.cache.NodeFactoryMethodReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class NodeFactoryMethodCache {
    private final Map<String, NodeFactoryMethodReference> cache;

    private NodeFactoryMethodCache(Map<String, NodeFactoryMethodReference> cache) {
        this.cache = cache;
    }

    public static NodeFactoryMethodCache create() {
        Method[] methodNames;
        HashMap<String, NodeFactoryMethodReference> methodCache = new HashMap<String, NodeFactoryMethodReference>();
        for (Method method : methodNames = NodeFactory.class.getMethods()) {
            methodCache.put(method.getName(), new NodeFactoryMethodReference(method));
        }
        return new NodeFactoryMethodCache(methodCache);
    }

    public NodeFactoryMethodReference getMethod(String name) {
        if (this.cache.containsKey(name)) {
            return this.cache.get(name);
        }
        throw new SyntaxApiCallsGenException("Failed to find method " + name);
    }
}

