/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.syntaxapicallsgen.segment.factories.cache;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.syntaxapicallsgen.SyntaxApiCallsGenException;
import io.ballerina.syntaxapicallsgen.segment.NodeFactorySegment;
import io.ballerina.syntaxapicallsgen.segment.factories.SegmentFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class NodeFactoryMethodReference {
    private static final char DOT_CHAR = '.';
    private final Method method;
    private final Type[] parameterTypes;
    private final Type[] parameterGenericTypes;
    private final int offset;

    NodeFactoryMethodReference(Method method) {
        this.method = method;
        this.parameterTypes = method.getParameterTypes();
        this.parameterGenericTypes = method.getGenericParameterTypes();
        this.offset = this.requiresSyntaxKind() ? 1 : 0;
    }

    public String getName() {
        return this.method.getName();
    }

    public Type getParameterType(int parameterIndex) {
        return this.parameterTypes[parameterIndex + this.offset];
    }

    public String getParameterGeneric(int parameterIndex) {
        String fullParameter = this.parameterGenericTypes[parameterIndex + this.offset].getTypeName();
        int lastDot = fullParameter.lastIndexOf(46);
        if (lastDot == -1) {
            throw new SyntaxApiCallsGenException("Attempted to extract generic type of a parameter without generic type");
        }
        return fullParameter.substring(lastDot + 1, fullParameter.length() - 1);
    }

    public NodeFactorySegment toSegment() {
        return SegmentFactory.createNodeFactorySegment(this.getName());
    }

    public final boolean requiresSyntaxKind() {
        if (this.parameterTypes.length == 0) {
            return false;
        }
        return this.parameterTypes[0] == SyntaxKind.class;
    }
}

