/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.xmldata;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlSequence;
import io.ballerina.stdlib.xmldata.XmlToJson;
import io.ballerina.stdlib.xmldata.XmlToRecord;
import io.ballerina.stdlib.xmldata.utils.Constants;
import io.ballerina.stdlib.xmldata.utils.XmlDataUtils;
import java.util.List;
import java.util.Map;

public final class MapFromXml {
    private MapFromXml() {
    }

    public static Object fromXml(BXml xml, BTypedesc type) {
        Type describingType = type.getDescribingType();
        if (describingType.getTag() == 24) {
            try {
                Object output;
                if (describingType.getFlags() != 2049L) {
                    String elementName;
                    String recordName = MapFromXml.getXmlNameFromRecordAnnotation((RecordType)describingType, describingType.getName());
                    if (!recordName.equals(elementName = MapFromXml.getKey(xml))) {
                        return XmlDataUtils.getError("The record type name: " + recordName + " mismatch with given XML name: " + elementName);
                    }
                    output = XmlToRecord.convertToJson(xml, true, "add", type);
                } else {
                    output = XmlToRecord.convertToJson(xml, true, "skip", type);
                }
                if (output instanceof BError) {
                    return XmlDataUtils.getError("XML type mismatch with record type: " + String.valueOf(((BError)output).getErrorMessage()));
                }
                BMap record = (BMap)output;
                output = describingType.getFlags() == 2049L ? output : record.get((Object)((BString[])record.getKeys())[0]);
                return MapFromXml.getOutput(type, output);
            }
            catch (Exception e) {
                return XmlDataUtils.getError("Failed to convert xml to record type: " + e.getMessage());
            }
        }
        try {
            Type valueType = ((MapType)describingType).getConstrainedType();
            MapFromXml.isValidXmlWithOutputType(xml, valueType);
            Object output = XmlToJson.toJson(xml, false, "skip", type.getDescribingType());
            if (valueType.getTag() == 17) {
                TableType tableType = (TableType)valueType;
                BMap tableMap = ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)tableType));
                BMap resultMap = (BMap)output;
                for (Map.Entry entry : resultMap.entrySet()) {
                    BTable tableValue = ValueCreator.createTableValue((TableType)tableType);
                    Type tableValueType = TypeUtils.getReferredType((Type)((TableType)valueType).getConstrainedType());
                    if (tableValueType.getTag() == 24) {
                        tableValue.put(ValueUtils.convert(entry.getValue(), (Type)tableValueType));
                    } else {
                        tableValue.put(entry.getValue());
                    }
                    tableMap.put((Object)((BString)entry.getKey()), (Object)tableValue);
                }
                return tableMap;
            }
            return output;
        }
        catch (Exception e) {
            return XmlDataUtils.getError(e.getMessage());
        }
    }

    private static Object getOutput(BTypedesc type, Object output) {
        try {
            return ValueUtils.convert((Object)output, (Type)type.getDescribingType());
        }
        catch (BError bError) {
            return XmlDataUtils.getError("XML type mismatch with record type: " + ((Map)bError.getDetails()).get(StringUtils.fromString((String)"message")).toString());
        }
    }

    private static String getKey(BXml xml) {
        String elementKey = xml.elements().getElementName();
        int startIndex = 0;
        if (elementKey.contains("}")) {
            startIndex = elementKey.indexOf("}") + 1;
        }
        return elementKey.substring(startIndex);
    }

    private static void isValidXmlWithOutputType(BXml xml, Type type) throws Exception {
        BXml elements;
        int typeTag = type.getTag();
        if (typeTag == 32) {
            typeTag = ((ArrayType)type).getElementType().getTag();
        }
        if (MapFromXml.isPrimitiveType(typeTag) && (elements = xml.elements().children()) instanceof BXmlSequence && MapFromXml.isNotValidXml(((BXmlSequence)elements).getChildrenList())) {
            throw new Exception("Failed to convert the xml:" + String.valueOf(xml.elements().children()) + " to " + String.valueOf(type) + " type.");
        }
    }

    private static boolean isPrimitiveType(int typeTag) {
        return typeTag == 5 || typeTag == 6 || typeTag == 1 || typeTag == 3 || typeTag == 4;
    }

    private static boolean isNotValidXml(List<BXml> sequence) {
        return sequence.size() == 1 && !sequence.get(0).elements().children().isEmpty() || sequence.size() > 1;
    }

    public static String getXmlNameFromRecordAnnotation(RecordType record, String recordName) {
        BMap annotations = record.getAnnotations();
        for (BString annotationsKey : (BString[])annotations.getKeys()) {
            String key = annotationsKey.getValue();
            if (key.contains("$field$.") || !key.endsWith("Name")) continue;
            return ((BMap)annotations.get((Object)annotationsKey)).get((Object)Constants.VALUE).toString();
        }
        return recordName;
    }
}

