/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.xmldata;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlItem;
import io.ballerina.runtime.api.values.BXmlSequence;
import io.ballerina.stdlib.xmldata.utils.Constants;
import io.ballerina.stdlib.xmldata.utils.FieldDetails;
import io.ballerina.stdlib.xmldata.utils.XmlDataUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public class XmlToJson {
    private static final ArrayType STRING_ARRAY_TYPE = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_STRING);
    private static final ArrayType DECIMAL_ARRAY_TYPE = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_DECIMAL);
    private static final ArrayType BOOLEAN_ARRAY_TYPE = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_BOOLEAN);
    private static final ArrayType FLOAT_ARRAY_TYPE = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_FLOAT);
    private static final ArrayType INT_ARRAY_TYPE = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_INT);
    private static final String XMLNS = "xmlns";
    private static final String DOUBLE_QUOTES = "\"";
    private static final String CONTENT = "#content";
    private static final String EMPTY_STRING = "";
    public static final int NS_PREFIX_BEGIN_INDEX = "{http://www.w3.org/2000/xmlns/}".length();
    private static final String COLON = ":";
    public static final String XMLSCHEMA_INSTANCE_NIL = "{http://www.w3.org/2001/XMLSchema-instance}nil";
    public static final BString BSTRING_XMLSCHEMA_INSTANCE_NIL = StringUtils.fromString((String)"{http://www.w3.org/2001/XMLSchema-instance}nil");

    public static Object toJson(BXml xml, BMap<?, ?> options) {
        try {
            String attributePrefix = ((BString)options.get((Object)StringUtils.fromString((String)"attributePrefix"))).getValue();
            boolean preserveNamespaces = (Boolean)options.get((Object)StringUtils.fromString((String)"preserveNamespaces"));
            return XmlToJson.convertToJSON(xml, attributePrefix, preserveNamespaces, null, null, new FieldDetails());
        }
        catch (Exception e) {
            return XmlDataUtils.getError(e.getMessage());
        }
    }

    public static Object toJson(BXml xml, boolean preserveNamespaces, String attributePrefix, Type type) {
        try {
            return XmlToJson.convertToJSON(xml, attributePrefix, preserveNamespaces, type, null, new FieldDetails());
        }
        catch (Exception e) {
            return XmlDataUtils.getError(e.getMessage());
        }
    }

    public static Object convertToJSON(BXml xml, String attributePrefix, boolean preserveNamespaces, Type type, BMap<BString, BString> parentAttributeMap, FieldDetails fieldDetails) throws Exception {
        MapType mapType;
        if (type instanceof MapType && (mapType = (MapType)type).getConstrainedType().getTag() == 16) {
            BMap<BString, Object> map = XmlToJson.createMapValue(type);
            map.put((Object)StringUtils.fromString((String)CONTENT), (Object)xml);
            return map;
        }
        if (xml instanceof BXmlItem) {
            return XmlToJson.convertElement((BXmlItem)xml, attributePrefix, preserveNamespaces, type, parentAttributeMap, fieldDetails);
        }
        if (xml instanceof BXmlSequence) {
            BXmlSequence xmlSequence = (BXmlSequence)xml;
            if (xmlSequence.isEmpty()) {
                return StringUtils.fromString((String)EMPTY_STRING);
            }
            Object seq = XmlToJson.convertBXmlSequence(xmlSequence, attributePrefix, preserveNamespaces, type, parentAttributeMap, fieldDetails);
            if (seq == null) {
                return XmlToJson.createNewJsonList();
            }
            return seq;
        }
        if (xml.getNodeType().equals((Object)XmlNodeType.TEXT)) {
            return XmlToJson.convertValue(xml, type);
        }
        return XmlToJson.createMapValue(type);
    }

    private static Object convertValue(BXml xml, Type type) throws Exception {
        if (type != null) {
            if (type.getTag() == 32) {
                return XmlToJson.convertToArray(type, xml);
            }
            if (type.getTag() == 27) {
                switch (((MapType)type).getConstrainedType().getTag()) {
                    case 1: {
                        return Long.parseLong(xml.toString());
                    }
                    case 6: {
                        return Boolean.parseBoolean(xml.toString());
                    }
                    case 4: {
                        return ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(Double.parseDouble(xml.toString())));
                    }
                    case 3: {
                        return Double.parseDouble(xml.toString());
                    }
                }
            }
        }
        return StringUtils.fromString((String)xml.stringValue(null));
    }

    private static Object convertElement(BXmlItem xmlItem, String attributePrefix, boolean preserveNamespaces, Type type, BMap<BString, BString> parentAttributeMap, FieldDetails fieldDetail) throws Exception {
        BMap<BString, Object> childrenData = XmlToJson.createMapValue(type);
        BMap attributeMap = xmlItem.getAttributesMap();
        String fieldName = XmlToJson.getElementKey(xmlItem, preserveNamespaces);
        XmlToJson.processFieldDetails(fieldName, type, fieldDetail);
        fieldName = fieldDetail.getName();
        Type fieldType = fieldDetail.getType();
        XmlToJson.processAttributeWithAnnotation(xmlItem, attributePrefix, preserveNamespaces, childrenData, fieldType, (BMap<BString, BString>)attributeMap, parentAttributeMap, fieldDetail);
        Object children = XmlToJson.convertBXmlSequence(xmlItem.getChildrenSeq(), attributePrefix, preserveNamespaces, fieldType, (BMap<BString, BString>)attributeMap, fieldDetail);
        BMap<BString, Object> rootNode = XmlToJson.createMapValue(type);
        if (type != null && fieldType instanceof ArrayType && children instanceof BMap && TypeUtils.getReferredType((Type)((ArrayType)fieldType).getElementType()) instanceof RecordType) {
            for (Map.Entry entry : childrenData.entrySet()) {
                ((BMap)children).put((Object)((BString)entry.getKey()), entry.getValue());
            }
            children = XmlToJson.convertToArray(fieldType, children);
        }
        fieldDetail.setParentArrayName(fieldName);
        boolean nilValue = false;
        if (children == null && attributeMap.containsKey((Object)BSTRING_XMLSCHEMA_INSTANCE_NIL)) {
            nilValue = Boolean.parseBoolean(((BString)attributeMap.get((Object)BSTRING_XMLSCHEMA_INSTANCE_NIL)).getValue());
        }
        return XmlToJson.insertDataToMap(childrenData, children, rootNode, fieldName, fieldType, fieldDetail, nilValue);
    }

    private static void processAttributeWithAnnotation(BXmlItem xmlItem, String attributePrefix, boolean preserveNamespaces, BMap<BString, Object> childrenData, Type fieldType, BMap<BString, BString> attributeMap, BMap<BString, BString> parentAttributeMap, FieldDetails fieldDetails) throws Exception {
        if (!attributePrefix.equals("skip")) {
            BMap annotations = null;
            if (attributePrefix.equals("add")) {
                Type annotationType = TypeUtils.getReferredType((Type)fieldType);
                if (fieldType.getTag() == 32) {
                    annotationType = TypeUtils.getReferredType((Type)((ArrayType)fieldType).getElementType());
                } else if (fieldType instanceof UnionType) {
                    UnionType bUnionType = (UnionType)fieldType;
                    for (Type memberType : bUnionType.getMemberTypes()) {
                        Type referMemberType = TypeUtils.getReferredType((Type)memberType);
                        if (referMemberType.getTag() != 24) continue;
                        annotationType = referMemberType;
                    }
                }
                if (annotationType.getTag() == 24) {
                    annotations = ((RecordType)annotationType).getAnnotations();
                }
            }
            XmlToJson.processAttributes(attributeMap, attributePrefix, childrenData, fieldType, parentAttributeMap, xmlItem.getQName().getPrefix(), preserveNamespaces, annotations, fieldDetails);
        }
    }

    private static BMap<BString, Object> insertDataToMap(BMap<BString, Object> childrenData, Object children, BMap<BString, Object> rootNode, String keyValue, Type fieldType, FieldDetails fieldDetails, boolean nilValue) throws Exception {
        if (childrenData.size() > 0) {
            if (children instanceof BMap) {
                BMap data = (BMap)children;
                for (Map.Entry entry : childrenData.entrySet()) {
                    data.put((Object)((BString)entry.getKey()), entry.getValue());
                }
                XmlToJson.put(rootNode, keyValue, data);
            } else if (children == null) {
                XmlToJson.put(rootNode, keyValue, childrenData);
            } else if (children instanceof BArray) {
                XmlToJson.put(rootNode, keyValue, children);
            } else {
                if (children instanceof BString) {
                    XmlToJson.putAsFieldTypes(childrenData, CONTENT, children.toString().trim(), fieldType, fieldDetails);
                    XmlToJson.put(rootNode, keyValue, childrenData);
                    return rootNode;
                }
                XmlToJson.put(rootNode, keyValue, children);
            }
        } else if (children instanceof BMap) {
            XmlToJson.put(rootNode, keyValue, children);
        } else if (children == null) {
            if (fieldType instanceof ReferenceType && TypeUtils.getReferredType((Type)fieldType) instanceof RecordType) {
                XmlToJson.put(rootNode, keyValue, nilValue ? null : ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE));
            } else {
                XmlToJson.putAsFieldTypes(rootNode, keyValue, nilValue ? null : EMPTY_STRING, fieldType, fieldDetails);
            }
        } else if (children instanceof BArray) {
            XmlToJson.put(rootNode, keyValue, children);
        } else if (children instanceof BString) {
            XmlToJson.putAsFieldTypes(rootNode, keyValue, children.toString().trim(), fieldType, fieldDetails);
        } else {
            XmlToJson.put(rootNode, keyValue, children);
        }
        return rootNode;
    }

    private static void processFieldDetails(String fieldName, Type type, FieldDetails fieldDetails) {
        if (type != null) {
            if (type.getTag() == 24) {
                XmlToJson.getRecordFieldTypeAndName(type, fieldName, fieldDetails);
            } else if (type.getTag() == 32) {
                Type fieldType = TypeUtils.getReferredType((Type)((ArrayType)type).getElementType());
                if (fieldType instanceof RecordType) {
                    XmlToJson.getRecordFieldTypeAndName(fieldType, fieldName, fieldDetails);
                } else {
                    XmlToJson.setNameAndTypeIntoFieldDetails(fieldType, fieldName, fieldDetails);
                }
            } else if (type.getTag() == 53) {
                Type referredType = TypeUtils.getReferredType((Type)type);
                if (referredType.getTag() == 24) {
                    XmlToJson.getRecordFieldTypeAndName(referredType, fieldName, fieldDetails);
                } else {
                    XmlToJson.setNameAndTypeIntoFieldDetails(type, fieldName, fieldDetails);
                }
            } else if (type.getTag() == 27) {
                Type valueType = ((MapType)type).getConstrainedType();
                if (valueType.getTag() == 17) {
                    XmlToJson.setNameAndTypeIntoFieldDetails(((TableType)valueType).getConstrainedType(), fieldName, fieldDetails);
                } else {
                    XmlToJson.setNameAndTypeIntoFieldDetails(valueType, fieldName, fieldDetails);
                }
            } else {
                XmlToJson.setNameAndTypeIntoFieldDetails(type, fieldName, fieldDetails);
            }
        } else {
            XmlToJson.setNameAndTypeIntoFieldDetails(null, fieldName, fieldDetails);
        }
    }

    private static void getRecordFieldTypeAndName(Type type, String fieldName, FieldDetails fieldDetails) {
        XmlToJson.setNameAndTypeIntoFieldDetails(type, fieldName, fieldDetails);
        RecordType recordType = (RecordType)type;
        Map fields = recordType.getFields();
        BMap annotations = recordType.getAnnotations();
        for (BString annotationsKey : (BString[])annotations.getKeys()) {
            if (!annotationsKey.getValue().contains("$field$.")) continue;
            BMap annotationsForField = (BMap)annotations.get((Object)annotationsKey);
            for (BString annotationForField : (BString[])annotationsForField.getKeys()) {
                if (!annotationForField.getValue().endsWith("Name")) continue;
                BMap value = (BMap)annotationsForField.get((Object)annotationForField);
                for (Map.Entry entry : value.entrySet()) {
                    if (!entry.getValue().toString().trim().equals(fieldName)) continue;
                    fieldName = annotationsKey.getValue().split("\\.")[1];
                    fieldDetails.setName(fieldName);
                }
            }
        }
        if (fields.get(fieldName) != null) {
            fieldDetails.setType(((Field)fields.get(fieldName)).getFieldType());
        }
    }

    private static void setNameAndTypeIntoFieldDetails(Type type, String fieldName, FieldDetails fieldDetails) {
        fieldDetails.setName(fieldName);
        fieldDetails.setType(type);
    }

    private static void processAttributes(BMap<BString, BString> attributeMap, String attributePrefix, BMap<BString, Object> mapData, Type type, BMap<BString, BString> parentAttributeMap, String prefix, boolean preserveNamespaces, BMap<BString, Object> annotations, FieldDetails fieldDetails) throws Exception {
        ConcurrentHashMap<String, String> nsPrefixMap = XmlToJson.getNamespacePrefixes(attributeMap);
        if (prefix != null && preserveNamespaces && parentAttributeMap != null) {
            for (Map.Entry entry : attributeMap.entrySet()) {
                BString value = (BString)entry.getValue();
                if (XmlToJson.isNamespacePrefixEntry(entry) && XmlToJson.isBelongingToElement(parentAttributeMap, (BString)entry.getKey(), value)) continue;
                String key = XmlToJson.getAttributeKey(attributePrefix, XmlToJson.getKey(entry, nsPrefixMap, preserveNamespaces));
                XmlToJson.processFieldDetails(key, type, fieldDetails);
                XmlToJson.checkAnnotationAndAddAttributes(annotations, mapData, fieldDetails.getType(), fieldDetails.getName(), value.getValue(), attributePrefix, fieldDetails);
            }
        } else {
            for (Map.Entry entry : attributeMap.entrySet()) {
                String key = XmlToJson.getKey(entry, nsPrefixMap, preserveNamespaces);
                if (key == null) continue;
                key = XmlToJson.getAttributeKey(attributePrefix, key);
                XmlToJson.processFieldDetails(key, type, fieldDetails);
                XmlToJson.checkAnnotationAndAddAttributes(annotations, mapData, fieldDetails.getType(), fieldDetails.getName(), ((BString)entry.getValue()).getValue(), attributePrefix, fieldDetails);
            }
        }
    }

    private static String getAttributeKey(String attributePrefix, String key) {
        if (attributePrefix.equals("add")) {
            return key;
        }
        return attributePrefix + key;
    }

    private static void checkAnnotationAndAddAttributes(BMap<BString, Object> annotations, BMap<BString, Object> mapData, Type type, String key, String value, String attributePrefix, FieldDetails fieldDetails) throws Exception {
        if (!attributePrefix.equals("add")) {
            XmlToJson.putAsFieldTypes(mapData, key, value, type, fieldDetails);
        } else if (annotations != null && annotations.size() > 0) {
            BString annotationKey = StringUtils.fromString((String)("$field$." + key).replace(COLON, "\\:"));
            block0: for (BString annotationsKey : (BString[])annotations.getKeys()) {
                if (annotationsKey.getValue().contains("$field$.") && annotationsKey.getValue().equals(annotationKey.getValue())) {
                    BMap annotationsForField = (BMap)annotations.get((Object)annotationsKey);
                    for (BString annotationForField : (BString[])annotationsForField.getKeys()) {
                        if (!annotationForField.getValue().endsWith("Attribute")) continue;
                        XmlToJson.processFieldDetails(key, type, fieldDetails);
                        XmlToJson.putAsFieldTypes(mapData, fieldDetails.getName(), value, fieldDetails.getType(), fieldDetails);
                        continue block0;
                    }
                    continue;
                }
                if (annotationsKey.getValue().contains("$field$.") || !annotationsKey.getValue().endsWith("Namespace")) continue;
                BMap namespaceAnnotation = (BMap)annotations.get((Object)annotationsKey);
                BString prefix = (BString)namespaceAnnotation.get((Object)StringUtils.fromString((String)"prefix"));
                BString uri = (BString)namespaceAnnotation.get((Object)StringUtils.fromString((String)"uri"));
                if ((prefix != null || !key.equals(XMLNS)) && (prefix == null || !key.equals("xmlns:" + prefix.getValue()))) continue;
                String uriValue = uri.getValue().trim();
                if (uriValue.equals(value.trim())) break;
                throw new Exception("The URI['" + uriValue + "'] of the namespace in the expected record definition differs from the XML namespace's['" + key + "'] URI['" + value + "']");
            }
        }
    }

    private static boolean isBelongingToElement(BMap<BString, BString> parentAttributeMap, BString key, BString value) {
        return parentAttributeMap.containsKey((Object)key) && ((BString)parentAttributeMap.get((Object)key)).getValue().equals(value.getValue());
    }

    private static void putAsFieldTypes(BMap<BString, Object> map, String key, String value, Type type, FieldDetails fieldDetails) throws Exception {
        if (type != null) {
            Type fieldType;
            if (type instanceof ArrayType && (fieldType = TypeUtils.getReferredType((Type)((ArrayType)type).getElementType())) instanceof RecordType && ((RecordType)fieldType).getFields().get(key) != null) {
                XmlToJson.getRecordFieldTypeAndName(fieldType, key, fieldDetails);
                key = fieldDetails.getName();
                type = fieldDetails.getType();
            }
            if (type instanceof UnionType) {
                UnionType bUnionType = (UnionType)type;
                boolean isSuccessfullyCast = false;
                for (Type memberType : bUnionType.getMemberTypes()) {
                    try {
                        XmlToJson.convertToRecordType(map, memberType, key, value);
                        isSuccessfullyCast = true;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                if (!isSuccessfullyCast) {
                    throw new Exception("Couldn't convert value: " + value + " to " + String.valueOf(bUnionType));
                }
            } else {
                XmlToJson.convertToRecordType(map, type, key, value);
            }
        } else {
            map.put((Object)StringUtils.fromString((String)key), (Object)StringUtils.fromString((String)value));
        }
    }

    private static void put(BMap<BString, Object> map, String key, Object value) {
        map.put((Object)StringUtils.fromString((String)key), value);
    }

    private static void convertToRecordType(BMap<BString, Object> map, Type valueType, String key, String value) throws Exception {
        try {
            switch (valueType.getTag()) {
                case 1: {
                    map.put((Object)StringUtils.fromString((String)key), (Object)Long.parseLong(value));
                    break;
                }
                case 3: {
                    map.put((Object)StringUtils.fromString((String)key), (Object)Double.parseDouble(value));
                    break;
                }
                case 4: {
                    map.put((Object)StringUtils.fromString((String)key), (Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(Double.parseDouble(value))));
                    break;
                }
                case 6: {
                    map.put((Object)StringUtils.fromString((String)key), (Object)Boolean.parseBoolean(value));
                    break;
                }
                case 32: {
                    BArray array = XmlToJson.convertToArray(valueType, value);
                    map.put((Object)StringUtils.fromString((String)key), (Object)array);
                    break;
                }
                default: {
                    map.put((Object)StringUtils.fromString((String)key), (Object)StringUtils.fromString((String)value));
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error occurred when converting value: " + value + " to " + String.valueOf(valueType));
        }
        catch (Exception e) {
            throw new Exception("Error occurred when converting value. " + e.getMessage());
        }
    }

    private static BArray convertToArray(Type valueType, Object value) throws Exception {
        Type elementType = TypeUtils.getReferredType((Type)((ArrayType)valueType).getElementType());
        String valueString = value.toString();
        try {
            switch (elementType.getTag()) {
                case 1: {
                    BArray arr = ValueCreator.createArrayValue((ArrayType)INT_ARRAY_TYPE);
                    if (!valueString.isEmpty()) {
                        arr.append((Object)Long.parseLong(valueString));
                    }
                    return arr;
                }
                case 3: {
                    BArray arr = ValueCreator.createArrayValue((ArrayType)FLOAT_ARRAY_TYPE);
                    if (!valueString.isEmpty()) {
                        arr.append((Object)Double.parseDouble(valueString));
                    }
                    return arr;
                }
                case 4: {
                    BArray arr = ValueCreator.createArrayValue((ArrayType)DECIMAL_ARRAY_TYPE);
                    if (!valueString.isEmpty()) {
                        arr.append((Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(Double.parseDouble(valueString))));
                    }
                    return arr;
                }
                case 6: {
                    BArray arr = ValueCreator.createArrayValue((ArrayType)BOOLEAN_ARRAY_TYPE);
                    if (!valueString.isEmpty()) {
                        arr.append((Object)Boolean.parseBoolean(valueString));
                    }
                    return arr;
                }
                case 5: {
                    BArray arr = ValueCreator.createArrayValue((ArrayType)STRING_ARRAY_TYPE);
                    if (!valueString.isEmpty()) {
                        arr.append((Object)StringUtils.fromString((String)valueString));
                    }
                    return arr;
                }
            }
            BArray arr = XmlToJson.createNewJsonList();
            if (!valueString.isEmpty()) {
                arr.append(value);
            }
            return arr;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error occurred when converting value:" + String.valueOf(value) + " to " + String.valueOf(valueType));
        }
        catch (Exception e) {
            throw new Exception("Error occurred when converting value:" + e.getMessage());
        }
    }

    private static Object convertBXmlSequence(BXmlSequence xmlSequence, String attributePrefix, boolean preserveNamespaces, Type type, BMap<BString, BString> parentAttributeMap, FieldDetails fieldDetails) throws Exception {
        List sequence = xmlSequence.getChildrenList();
        ArrayList<BXml> newSequence = new ArrayList<BXml>();
        for (BXml value : sequence) {
            String textValue = value.toString();
            if (!textValue.isEmpty() && textValue.trim().isEmpty()) continue;
            newSequence.add(value);
        }
        if (newSequence.isEmpty()) {
            return null;
        }
        if (type != null && type.getTag() == 16) {
            if (newSequence.size() == 1) {
                return newSequence.get(0);
            }
            return xmlSequence.elements();
        }
        return XmlToJson.convertHeterogeneousSequence(attributePrefix, preserveNamespaces, newSequence, type, parentAttributeMap, fieldDetails);
    }

    private static Object convertHeterogeneousSequence(String attributePrefix, boolean preserveNamespaces, List<BXml> sequence, Type type, BMap<BString, BString> parentAttributeMap, FieldDetails fieldDetails) throws Exception {
        if (sequence.size() == 1 && (type == null || type.getTag() != 53)) {
            return XmlToJson.convertToJSON(sequence.get(0), attributePrefix, preserveNamespaces, type, parentAttributeMap, fieldDetails);
        }
        BMap<BString, Object> mapJson = XmlToJson.createMapValue(type);
        for (BXml bxml : sequence) {
            if (XmlToJson.isCommentOrPi(bxml)) continue;
            if (bxml.getNodeType() == XmlNodeType.TEXT) {
                if (mapJson.containsKey((Object)StringUtils.fromString((String)CONTENT))) {
                    BArray jsonList;
                    if (mapJson.get((Object)StringUtils.fromString((String)CONTENT)) instanceof BString) {
                        jsonList = XmlToJson.createNewJsonList();
                        jsonList.append(mapJson.get((Object)StringUtils.fromString((String)CONTENT)));
                        jsonList.append((Object)StringUtils.fromString((String)bxml.toString().trim()));
                        mapJson.put((Object)StringUtils.fromString((String)CONTENT), (Object)jsonList);
                        continue;
                    }
                    jsonList = mapJson.getArrayValue(StringUtils.fromString((String)CONTENT));
                    jsonList.append((Object)StringUtils.fromString((String)bxml.toString().trim()));
                    mapJson.put((Object)StringUtils.fromString((String)CONTENT), (Object)jsonList);
                    continue;
                }
                mapJson.put((Object)StringUtils.fromString((String)CONTENT), (Object)StringUtils.fromString((String)bxml.toString().trim()));
                continue;
            }
            Object processingData = XmlToJson.convertToJSON(bxml, attributePrefix, preserveNamespaces, type, parentAttributeMap, fieldDetails);
            BString elementName = StringUtils.fromString((String)fieldDetails.getParentArrayName());
            Object result = XmlToJson.validateResult(processingData, elementName);
            Object value = mapJson.get((Object)elementName);
            if (value == null) {
                mapJson.put((Object)elementName, result);
                continue;
            }
            if (value instanceof BArray) {
                if (result instanceof BArray) {
                    BArray array = (BArray)result;
                    if (!array.isEmpty()) {
                        ((BArray)value).append(array.get(0L));
                    }
                } else {
                    ((BArray)value).append(result);
                }
                mapJson.put((Object)elementName, value);
                continue;
            }
            BArray arr = value instanceof Long ? ValueCreator.createArrayValue((ArrayType)INT_ARRAY_TYPE) : (value instanceof Boolean ? ValueCreator.createArrayValue((ArrayType)BOOLEAN_ARRAY_TYPE) : (value instanceof Double ? ValueCreator.createArrayValue((ArrayType)FLOAT_ARRAY_TYPE) : (value.getClass().getCanonicalName().contains("DecimalValue") ? ValueCreator.createArrayValue((ArrayType)DECIMAL_ARRAY_TYPE) : (value instanceof BString ? ValueCreator.createArrayValue((ArrayType)STRING_ARRAY_TYPE) : XmlToJson.createNewJsonList()))));
            arr.append(value);
            arr.append(result);
            mapJson.put((Object)elementName, (Object)arr);
        }
        return mapJson;
    }

    private static Object validateResult(Object result, BString elementName) {
        Object validateResult = result == null ? StringUtils.fromString((String)EMPTY_STRING) : (result instanceof BMap && ((BMap)result).containsKey((Object)elementName) ? ((BMap)result).get((Object)elementName) : result);
        return validateResult;
    }

    private static boolean isCommentOrPi(BXml bxml) {
        return bxml.getNodeType() == XmlNodeType.COMMENT || bxml.getNodeType() == XmlNodeType.PI;
    }

    private static BArray createNewJsonList() {
        return ValueCreator.createArrayValue((ArrayType)Constants.JSON_ARRAY_TYPE);
    }

    private static BMap<BString, Object> createMapValue(Type type) {
        if (type != null && type.getTag() == 27) {
            return ValueCreator.createMapValue((MapType)((MapType)type));
        }
        return ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
    }

    private static String getKey(Map.Entry<BString, BString> entry, Map<String, String> nsPrefixMap, boolean preserveNamespaces) {
        if (preserveNamespaces) {
            if (XmlToJson.isNamespacePrefixEntry(entry)) {
                return XmlToJson.getNamespacePrefixAttribute(entry.getKey().getValue());
            }
            return XmlToJson.getAttributePreservingNamespace(nsPrefixMap, entry.getKey().getValue());
        }
        if (XmlToJson.isNonNamespaceAttribute(entry.getKey().getValue()).booleanValue()) {
            return XmlToJson.getAttributePreservingNamespace(nsPrefixMap, entry.getKey().getValue());
        }
        return null;
    }

    private static Boolean isNonNamespaceAttribute(String attributeKey) {
        return !Pattern.matches("\\{.*\\}.*", attributeKey);
    }

    private static String getNamespacePrefixAttribute(String attributeKey) {
        String prefix = attributeKey.substring(NS_PREFIX_BEGIN_INDEX);
        if (prefix.equals(XMLNS)) {
            return prefix;
        }
        return "xmlns:" + prefix;
    }

    private static String getAttributePreservingNamespace(Map<String, String> nsPrefixMap, String attributeKey) {
        int nsEndIndex = attributeKey.lastIndexOf(125);
        if (nsEndIndex > 0) {
            String ns = attributeKey.substring(1, nsEndIndex);
            String local = attributeKey.substring(nsEndIndex + 1);
            String nsPrefix = nsPrefixMap.get(ns);
            if (nsPrefix == null) {
                return local;
            }
            if (nsPrefix.equals(XMLNS)) {
                return XMLNS;
            }
            return nsPrefix + COLON + local;
        }
        return attributeKey;
    }

    private static ConcurrentHashMap<String, String> getNamespacePrefixes(BMap<BString, BString> xmlAttributeMap) {
        ConcurrentHashMap<String, String> nsPrefixMap = new ConcurrentHashMap<String, String>();
        for (Map.Entry entry : xmlAttributeMap.entrySet()) {
            if (!XmlToJson.isNamespacePrefixEntry(entry)) continue;
            String prefix = ((BString)entry.getKey()).getValue().substring(NS_PREFIX_BEGIN_INDEX);
            String ns = ((BString)entry.getValue()).getValue();
            nsPrefixMap.put(ns, prefix);
        }
        return nsPrefixMap;
    }

    private static boolean isNamespacePrefixEntry(Map.Entry<BString, BString> entry) {
        return entry.getKey().getValue().startsWith("{http://www.w3.org/2000/xmlns/}");
    }

    public static String getElementKey(BXmlItem xmlItem, boolean preserveNamespaces) {
        String prefix;
        StringBuilder elementKey = new StringBuilder();
        QName qName = xmlItem.getQName();
        if (preserveNamespaces && (prefix = qName.getPrefix()) != null && !prefix.isEmpty()) {
            elementKey.append(prefix).append(':');
        }
        elementKey.append(qName.getLocalPart());
        return elementKey.toString();
    }

    private XmlToJson() {
    }
}

