/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.commons.toml;

import io.ballerina.toml.validator.schema.Schema;
import io.ballerina.toml.validator.schema.SchemaVisitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.langserver.commons.toml.visitor.TomlNode;
import org.ballerinalang.langserver.commons.toml.visitor.TomlSchemaVisitor;
import org.eclipse.lsp4j.CompletionItem;

public abstract class AbstractTomlSnippetManager {
    private Map<TomlNode, Map<String, CompletionItem>> completions = new HashMap<TomlNode, Map<String, CompletionItem>>();
    private boolean isSchemaVisited = false;

    public Map<TomlNode, Map<String, CompletionItem>> getCompletionProposals() {
        if (!this.isSchemaVisited) {
            Schema schema = Schema.from((String)this.getValidationSchema());
            TomlSchemaVisitor visitor = new TomlSchemaVisitor();
            schema.accept((SchemaVisitor)visitor);
            this.completions = visitor.getAllCompletionSnippets();
            this.isSchemaVisited = true;
        }
        return Collections.unmodifiableMap(this.completions);
    }

    public abstract String getValidationSchema();
}

