/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.commons.toml.common;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;

public final class TomlCommonUtil {
    public static final String LINE_SEPARATOR = System.lineSeparator();

    private TomlCommonUtil() {
    }

    public static String genSortText(int rank) {
        int rankRange = 25;
        int rankUpperBoundary = 64;
        int rankLowerBoundary = 90;
        if (rank < 1) {
            throw new IllegalArgumentException("Rank should be greater than zero");
        }
        int suffixValue = rank % rankRange;
        String suffix = suffixValue == 0 ? "" : String.valueOf((char)(rankUpperBoundary + suffixValue));
        String prefix = String.join((CharSequence)"", Collections.nCopies((rank - suffixValue) / rankRange, "" + (char)rankLowerBoundary));
        return prefix + suffix;
    }

    public static Optional<Path> getPathFromURI(String uri) {
        try {
            return Optional.of(Path.of(new URL(uri).toURI()));
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return Optional.empty();
        }
    }
}

