/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.commons.workspace;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.Document;
import io.ballerina.projects.Module;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.commons.eventsync.exceptions.EventSyncException;
import org.ballerinalang.langserver.commons.workspace.RunContext;
import org.ballerinalang.langserver.commons.workspace.RunResult;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public interface WorkspaceManager {
    public Optional<String> relativePath(Path var1);

    public Optional<String> relativePath(Path var1, CancelChecker var2);

    public Path projectRoot(Path var1);

    public Path projectRoot(Path var1, CancelChecker var2);

    public Optional<Project> project(Path var1);

    public Project loadProject(Path var1) throws ProjectException, WorkspaceDocumentException, EventSyncException;

    public Optional<Module> module(Path var1);

    public Optional<Module> module(Path var1, CancelChecker var2);

    public Optional<Document> document(Path var1);

    public Optional<Document> document(Path var1, CancelChecker var2);

    public Optional<SyntaxTree> syntaxTree(Path var1);

    public Optional<SyntaxTree> syntaxTree(Path var1, CancelChecker var2);

    public Optional<SemanticModel> semanticModel(Path var1);

    public Optional<SemanticModel> semanticModel(Path var1, @NonNull CancelChecker var2);

    public Optional<PackageCompilation> waitAndGetPackageCompilation(Path var1);

    public Optional<PackageCompilation> waitAndGetPackageCompilation(Path var1, CancelChecker var2);

    public void didOpen(Path var1, DidOpenTextDocumentParams var2) throws WorkspaceDocumentException;

    public void didChange(Path var1, DidChangeTextDocumentParams var2) throws WorkspaceDocumentException;

    public void didClose(Path var1, DidCloseTextDocumentParams var2);

    public void didChangeWatched(Path var1, FileEvent var2) throws WorkspaceDocumentException;

    public List<Path> didChangeWatched(DidChangeWatchedFilesParams var1) throws WorkspaceDocumentException;

    public String uriScheme();

    public RunResult run(RunContext var1) throws IOException;

    public boolean stop(Path var1);

    public CompletableFuture<Map<Path, Project>> workspaceProjects();
}

