/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.AnnotationAttachPointNode;
import io.ballerina.compiler.syntax.tree.AnnotationDeclarationNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.DistinctTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.EnumMemberNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExternalFunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IncludedRecordParameterNode;
import io.ballerina.compiler.syntax.tree.IntersectionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.MapTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.MarkdownCodeBlockNode;
import io.ballerina.compiler.syntax.tree.MarkdownCodeLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParameterizedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParenthesisedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.RestParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TableTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TupleTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeParameterNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.ballerinalang.docgen.docs.BallerinaDocGenerator;
import org.ballerinalang.docgen.generator.model.Annotation;
import org.ballerinalang.docgen.generator.model.AnnotationAttachment;
import org.ballerinalang.docgen.generator.model.BClass;
import org.ballerinalang.docgen.generator.model.BObjectType;
import org.ballerinalang.docgen.generator.model.BType;
import org.ballerinalang.docgen.generator.model.Client;
import org.ballerinalang.docgen.generator.model.Constant;
import org.ballerinalang.docgen.generator.model.Construct;
import org.ballerinalang.docgen.generator.model.DefaultableVariable;
import org.ballerinalang.docgen.generator.model.Enum;
import org.ballerinalang.docgen.generator.model.Error;
import org.ballerinalang.docgen.generator.model.Function;
import org.ballerinalang.docgen.generator.model.FunctionKind;
import org.ballerinalang.docgen.generator.model.Listener;
import org.ballerinalang.docgen.generator.model.MapType;
import org.ballerinalang.docgen.generator.model.Module;
import org.ballerinalang.docgen.generator.model.Record;
import org.ballerinalang.docgen.generator.model.TableType;
import org.ballerinalang.docgen.generator.model.Type;
import org.ballerinalang.docgen.generator.model.Variable;
import org.ballerinalang.docgen.generator.model.types.FunctionType;
import org.ballerinalang.docgen.generator.model.types.ObjectType;

public final class Generator {
    private static final String EMPTY_STRING = "";
    private static final String RETURN_PARAM_NAME = "return";
    public static final String REST_FIELD_DESCRIPTION = "Rest field";
    public static final String LISTENER_START_METHOD_NAME = "'start";
    public static final String LISTENER_ATTACH_METHOD_NAME = "attach";
    public static final String LISTENER_DETACH_METHOD_NAME = "detach";
    public static final String LISTENER_IMMEDIATE_STOP_METHOD_NAME = "immediateStop";
    public static final String LISTENER_GRACEFUL_STOP_METHOD_NAME = "gracefulStop";
    public static final String DOC_HEADER_PREFIX = "# ";

    private Generator() {
    }

    public static void setModuleFromSyntaxTree(Module module, SyntaxTree syntaxTree, SemanticModel semanticModel) {
        if (syntaxTree.containsModulePart()) {
            ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
            for (Node node : modulePartNode.members()) {
                if (node.kind().equals((Object)SyntaxKind.TYPE_DEFINITION)) {
                    TypeDefinitionNode typeDefinition = (TypeDefinitionNode)node;
                    if ((!typeDefinition.visibilityQualifier().isPresent() || !((Token)typeDefinition.visibilityQualifier().get()).kind().equals((Object)SyntaxKind.PUBLIC_KEYWORD)) && !Generator.isTypePramOrBuiltinSubtype(typeDefinition.metadata())) continue;
                    Generator.addTypeDefinition((TypeDescriptorNode)typeDefinition.typeDescriptor(), typeDefinition.typeName().text(), typeDefinition.metadata(), module, semanticModel, false);
                    continue;
                }
                if (node.kind() == SyntaxKind.CLASS_DEFINITION) {
                    ClassDefinitionNode classDefinition = (ClassDefinitionNode)node;
                    if (!classDefinition.visibilityQualifier().isPresent() || !((Token)classDefinition.visibilityQualifier().get()).kind().equals((Object)SyntaxKind.PUBLIC_KEYWORD)) continue;
                    BClass cls = Generator.getClassModel((ClassDefinitionNode)node, semanticModel, module);
                    if (cls instanceof Client) {
                        Client client = (Client)cls;
                        module.clients.add(client);
                        continue;
                    }
                    if (cls instanceof Listener) {
                        Listener listener = (Listener)cls;
                        module.listeners.add(listener);
                        continue;
                    }
                    module.classes.add(cls);
                    continue;
                }
                if (node.kind() == SyntaxKind.FUNCTION_DEFINITION && Generator.containsToken((NodeList<Token>)((FunctionDefinitionNode)node).qualifierList(), SyntaxKind.PUBLIC_KEYWORD)) {
                    module.functions.add(Generator.getFunctionModel((FunctionDefinitionNode)node, semanticModel, module));
                    continue;
                }
                if (node.kind() == SyntaxKind.CONST_DECLARATION && ((ConstantDeclarationNode)node).visibilityQualifier().isPresent() && ((Token)((ConstantDeclarationNode)node).visibilityQualifier().get()).kind().equals((Object)SyntaxKind.PUBLIC_KEYWORD)) {
                    module.constants.add(Generator.getConstantTypeModel((ConstantDeclarationNode)node, semanticModel, module));
                    continue;
                }
                if (node.kind() == SyntaxKind.ANNOTATION_DECLARATION && ((AnnotationDeclarationNode)node).visibilityQualifier().isPresent() && ((Token)((AnnotationDeclarationNode)node).visibilityQualifier().get()).kind().equals((Object)SyntaxKind.PUBLIC_KEYWORD)) {
                    module.annotations.add(Generator.getAnnotationModel((AnnotationDeclarationNode)node, semanticModel, module));
                    continue;
                }
                if (node.kind() == SyntaxKind.ENUM_DECLARATION && ((EnumDeclarationNode)node).qualifier().isPresent() && ((Token)((EnumDeclarationNode)node).qualifier().get()).kind().equals((Object)SyntaxKind.PUBLIC_KEYWORD)) {
                    module.enums.add(Generator.getEnumModel((EnumDeclarationNode)node));
                    continue;
                }
                if (node.kind() != SyntaxKind.MODULE_VAR_DECL) continue;
                ModuleVariableDeclarationNode variableDeclarationNode = (ModuleVariableDeclarationNode)node;
                DefaultableVariable defaultableVariable = Generator.getModuleVariable(variableDeclarationNode, semanticModel, module);
                if (Generator.containsToken((NodeList<Token>)variableDeclarationNode.qualifiers(), SyntaxKind.CONFIGURABLE_KEYWORD)) {
                    module.configurables.add(defaultableVariable);
                    continue;
                }
                if (!variableDeclarationNode.visibilityQualifier().isPresent() || !((Token)variableDeclarationNode.visibilityQualifier().get()).kind().equals((Object)SyntaxKind.PUBLIC_KEYWORD)) continue;
                module.variables.add(defaultableVariable);
            }
        }
    }

    public static void addTypeDefinition(TypeDescriptorNode typeDescriptorNode, String typeName, Optional<MetadataNode> metaDataNode, Module module, SemanticModel semanticModel, boolean isNullable) {
        SyntaxKind syntaxKind = typeDescriptorNode.kind();
        block0 : switch (syntaxKind) {
            case RECORD_TYPE_DESC: {
                module.records.add(Generator.getRecordTypeModel((RecordTypeDescriptorNode)typeDescriptorNode, typeName, metaDataNode, semanticModel, module));
                break;
            }
            case OBJECT_TYPE_DESC: {
                ObjectTypeDescriptorNode objectTypeDescriptorNode = (ObjectTypeDescriptorNode)typeDescriptorNode;
                BObjectType bObj = Generator.getObjectTypeModel(objectTypeDescriptorNode, typeName, metaDataNode, semanticModel, module);
                if (Generator.containsToken((NodeList<Token>)objectTypeDescriptorNode.objectTypeQualifiers(), SyntaxKind.SERVICE_KEYWORD)) {
                    module.serviceTypes.add(bObj);
                    break;
                }
                module.objectTypes.add(bObj);
                break;
            }
            case UNION_TYPE_DESC: {
                Type unionType = Type.fromNode((Node)typeDescriptorNode, semanticModel, module);
                if (unionType.memberTypes.stream().allMatch(type -> type.category != null && type.category.equals("errors") || type.category != null && type.category.equals("builtin") && type.name.equals("error"))) {
                    module.errors.add(new Error(typeName, Generator.getDocFromMetadata(metaDataNode), Generator.getDescSectionsDocFromMetaDataList(metaDataNode), Generator.isDeprecated(metaDataNode), Type.fromNode((Node)typeDescriptorNode, semanticModel, module)));
                    break;
                }
                module.unionTypes.add(Generator.getUnionTypeModel((Node)typeDescriptorNode, typeName, metaDataNode, semanticModel, module));
                break;
            }
            case SIMPLE_NAME_REFERENCE: 
            case QUALIFIED_NAME_REFERENCE: {
                Type refType = Type.fromNode((Node)typeDescriptorNode, semanticModel, module);
                if (refType.category.equals("errors")) {
                    module.errors.add(new Error(typeName, Generator.getDocFromMetadata(metaDataNode), Generator.getDescSectionsDocFromMetaDataList(metaDataNode), Generator.isDeprecated(metaDataNode), refType));
                    break;
                }
                BType bType = Generator.getUnionTypeModel((Node)typeDescriptorNode, typeName, metaDataNode, semanticModel, module);
                bType.isNullable = isNullable;
                module.simpleNameReferenceTypes.add(bType);
                break;
            }
            case DISTINCT_TYPE_DESC: {
                TypeDescriptorNode distinctTypeDescriptorNode = ((DistinctTypeDescriptorNode)typeDescriptorNode).typeDescriptor();
                SyntaxKind distinctTypeSyntaxKind = distinctTypeDescriptorNode.kind();
                switch (distinctTypeSyntaxKind) {
                    case ERROR_TYPE_DESC: {
                        Type detailType = null;
                        ParameterizedTypeDescriptorNode parameterizedTypeDescNode = (ParameterizedTypeDescriptorNode)distinctTypeDescriptorNode;
                        if (parameterizedTypeDescNode.typeParamNode().isPresent()) {
                            detailType = Type.fromNode((Node)((TypeParameterNode)parameterizedTypeDescNode.typeParamNode().get()).typeNode(), semanticModel, module);
                            detailType.isNullable = isNullable;
                        }
                        Error err = new Error(typeName, Generator.getDocFromMetadata(metaDataNode), Generator.getDescSectionsDocFromMetaDataList(metaDataNode), Generator.isDeprecated(metaDataNode), detailType);
                        err.isDistinct = true;
                        module.errors.add(err);
                        break block0;
                    }
                    case OBJECT_TYPE_DESC: {
                        ObjectTypeDescriptorNode distinctObjectTypeDescNode = (ObjectTypeDescriptorNode)distinctTypeDescriptorNode;
                        BObjectType bDistinctObj = Generator.getObjectTypeModel((ObjectTypeDescriptorNode)distinctTypeDescriptorNode, typeName, metaDataNode, semanticModel, module);
                        bDistinctObj.isDistinct = true;
                        if (Generator.containsToken((NodeList<Token>)distinctObjectTypeDescNode.objectTypeQualifiers(), SyntaxKind.SERVICE_KEYWORD)) {
                            module.serviceTypes.add(bDistinctObj);
                            break block0;
                        }
                        module.objectTypes.add(bDistinctObj);
                        break block0;
                    }
                    case PARENTHESISED_TYPE_DESC: {
                        ParenthesisedTypeDescriptorNode parenthesisedTypeDescriptorNode = (ParenthesisedTypeDescriptorNode)distinctTypeDescriptorNode;
                        Type parenthesisType = Type.fromNode((Node)parenthesisedTypeDescriptorNode, semanticModel, module);
                        parenthesisType.isNullable = isNullable;
                        Error parenthesisErr = new Error(typeName, Generator.getDocFromMetadata(metaDataNode), Generator.getDescSectionsDocFromMetaDataList(metaDataNode), Generator.isDeprecated(metaDataNode), parenthesisType);
                        parenthesisErr.isDistinct = true;
                        module.errors.add(parenthesisErr);
                        break block0;
                    }
                    case SIMPLE_NAME_REFERENCE: {
                        Type distinctRefType = Type.fromNode((Node)distinctTypeDescriptorNode, semanticModel, module);
                        distinctRefType.isNullable = isNullable;
                        if (distinctRefType.category.equals("errors")) {
                            Error simpleNameRefErr = new Error(typeName, Generator.getDocFromMetadata(metaDataNode), Generator.getDescSectionsDocFromMetaDataList(metaDataNode), Generator.isDeprecated(metaDataNode), distinctRefType);
                            simpleNameRefErr.isDistinct = true;
                            module.errors.add(simpleNameRefErr);
                            break block0;
                        }
                        ArrayList<Type> memberTypes = new ArrayList<Type>();
                        memberTypes.add(distinctRefType);
                        BType bType = new BType(typeName, Generator.getDocFromMetadata(metaDataNode), Generator.getDescSectionsDocFromMetaDataList(metaDataNode), Generator.isDeprecated(metaDataNode), memberTypes);
                        bType.isNullable = isNullable;
                        bType.isAnonymousUnionType = true;
                        module.types.add(bType);
                        break block0;
                    }
                }
                break;
            }
            case ERROR_TYPE_DESC: {
                ParameterizedTypeDescriptorNode parameterizedTypeDescNode = (ParameterizedTypeDescriptorNode)typeDescriptorNode;
                Type type2 = null;
                if (parameterizedTypeDescNode.typeParamNode().isPresent()) {
                    type2 = Type.fromNode((Node)((TypeParameterNode)parameterizedTypeDescNode.typeParamNode().get()).typeNode(), semanticModel, module);
                    type2.isNullable = isNullable;
                }
                module.errors.add(new Error(typeName, Generator.getDocFromMetadata(metaDataNode), Generator.getDescSectionsDocFromMetaDataList(metaDataNode), Generator.isDeprecated(metaDataNode), type2));
                break;
            }
            case INTERSECTION_TYPE_DESC: {
                Generator.addIntersectionTypeModel((IntersectionTypeDescriptorNode)typeDescriptorNode, typeName, metaDataNode, semanticModel, module);
                break;
            }
            case TABLE_TYPE_DESC: {
                TableType tableType = Generator.getTableTypeModel((TableTypeDescriptorNode)typeDescriptorNode, typeName, metaDataNode, semanticModel, module);
                tableType.rowParameterType.isNullable = isNullable;
                module.tableTypes.add(tableType);
                break;
            }
            case MAP_TYPE_DESC: {
                MapType mapType = Generator.getMapTypeModel((MapTypeDescriptorNode)typeDescriptorNode, typeName, metaDataNode, semanticModel, module);
                mapType.mapParameterType.isNullable = isNullable;
                module.mapTypes.add(mapType);
                break;
            }
            case TUPLE_TYPE_DESC: {
                BType tupleType = Generator.getTupleTypeModel((TupleTypeDescriptorNode)typeDescriptorNode, typeName, metaDataNode, semanticModel, module);
                tupleType.isNullable = isNullable;
                module.tupleTypes.add(tupleType);
                break;
            }
            case TYPEDESC_TYPE_DESC: {
                BType typeDescType = Generator.getTypeDescModel((ParameterizedTypeDescriptorNode)typeDescriptorNode, typeName, metaDataNode, semanticModel, module);
                typeDescType.isNullable = isNullable;
                module.typeDescriptorTypes.add(typeDescType);
                break;
            }
            case OPTIONAL_TYPE_DESC: {
                Generator.addTypeDefinition((TypeDescriptorNode)((OptionalTypeDescriptorNode)typeDescriptorNode).typeDescriptor(), typeName, metaDataNode, module, semanticModel, true);
                break;
            }
            default: {
                BType bType = Generator.getUnionTypeModel((Node)typeDescriptorNode, typeName, metaDataNode, semanticModel, module);
                bType.isNullable = isNullable;
                switch (syntaxKind) {
                    case INT_TYPE_DESC: {
                        module.integerTypes.add(bType);
                        break block0;
                    }
                    case DECIMAL_TYPE_DESC: {
                        module.decimalTypes.add(bType);
                        break block0;
                    }
                    case XML_TYPE_DESC: {
                        module.xmlTypes.add(bType);
                        break block0;
                    }
                    case FUNCTION_TYPE_DESC: {
                        module.functionTypes.add(bType);
                        break block0;
                    }
                    case ANYDATA_TYPE_DESC: {
                        module.anyDataTypes.add(bType);
                        break block0;
                    }
                    case STRING_TYPE_DESC: {
                        module.stringTypes.add(bType);
                        break block0;
                    }
                    case ANY_TYPE_DESC: {
                        module.anyTypes.add(bType);
                        break block0;
                    }
                    case ARRAY_TYPE_DESC: {
                        module.arrayTypes.add(bType);
                        break block0;
                    }
                    case STREAM_TYPE_DESC: {
                        module.streamTypes.add(bType);
                        break block0;
                    }
                    case BOOLEAN_TYPE_DESC: {
                        module.booleanTypes.add(bType);
                        break block0;
                    }
                }
            }
        }
    }

    public static boolean containsToken(NodeList<Token> nodeList, SyntaxKind kind) {
        for (Node node : nodeList) {
            if (node.kind() != kind) continue;
            return true;
        }
        return false;
    }

    public static DefaultableVariable getModuleVariable(ModuleVariableDeclarationNode moduleVariableNode, SemanticModel semanticModel, Module module) {
        String name = moduleVariableNode.typedBindingPattern().bindingPattern().toSourceCode().replace(" ", EMPTY_STRING);
        String doc = Generator.getDocFromMetadata(moduleVariableNode.metadata());
        String defaultValue = moduleVariableNode.initializer().isPresent() ? ((ExpressionNode)moduleVariableNode.initializer().get()).toSourceCode() : EMPTY_STRING;
        Type type = Type.fromNode((Node)moduleVariableNode.typedBindingPattern().typeDescriptor(), semanticModel, module);
        return new DefaultableVariable(name, doc, false, type, defaultValue);
    }

    public static Enum getEnumModel(EnumDeclarationNode enumDeclaration) {
        String enumName = enumDeclaration.identifier().text();
        ArrayList<Construct> members = new ArrayList<Construct>();
        enumDeclaration.enumMemberList().forEach(node -> {
            if (node.kind().equals((Object)SyntaxKind.ENUM_MEMBER)) {
                EnumMemberNode enumMemberNode = (EnumMemberNode)node;
                String memberName = enumMemberNode.identifier().text();
                String doc = Generator.getDocFromMetadata(enumMemberNode.metadata());
                if (doc.isEmpty()) {
                    doc = Generator.getParameterDocFromMetadataList(memberName, enumDeclaration.metadata());
                }
                List<String> descSections = Generator.getDescSectionsDocFromMetaDataList(enumDeclaration.metadata());
                members.add(new Construct(memberName, doc, descSections, false));
            }
        });
        return new Enum(enumName, Generator.getDocFromMetadata(enumDeclaration.metadata()), Generator.getDescSectionsDocFromMetaDataList(enumDeclaration.metadata()), Generator.isDeprecated(enumDeclaration.metadata()), members);
    }

    public static Annotation getAnnotationModel(AnnotationDeclarationNode annotationDeclaration, SemanticModel semanticModel, Module module) {
        String annotationName = annotationDeclaration.annotationTag().text();
        StringJoiner attachPointJoiner = new StringJoiner(", ");
        for (int i = 0; i < annotationDeclaration.attachPoints().size(); ++i) {
            AnnotationAttachPointNode annotationAttachPointNode = (AnnotationAttachPointNode)annotationDeclaration.attachPoints().get(i);
            attachPointJoiner.add(annotationAttachPointNode.toString());
        }
        Type dataType = annotationDeclaration.typeDescriptor().isPresent() ? Type.fromNode((Node)annotationDeclaration.typeDescriptor().get(), semanticModel, module) : null;
        return new Annotation(annotationName, Generator.getDocFromMetadata(annotationDeclaration.metadata()), Generator.getDescSectionsDocFromMetaDataList(annotationDeclaration.metadata()), Generator.isDeprecated(annotationDeclaration.metadata()), dataType, attachPointJoiner.toString());
    }

    public static Constant getConstantTypeModel(ConstantDeclarationNode constantNode, SemanticModel semanticModel, Module module) {
        Type type;
        String constantName = constantNode.variableName().text();
        String value = constantNode.initializer().toString();
        String desc = Generator.getDocFromMetadata(constantNode.metadata());
        List<String> descriptionSections = Generator.getDescSectionsDocFromMetaDataList(constantNode.metadata());
        if (constantNode.typeDescriptor().isPresent()) {
            type = Type.fromNode((Node)constantNode.typeDescriptor().get(), semanticModel, module);
        } else {
            String dataType = EMPTY_STRING;
            if (constantNode.initializer().kind() == SyntaxKind.STRING_LITERAL) {
                dataType = "string";
            } else if (constantNode.initializer().kind() == SyntaxKind.BOOLEAN_LITERAL) {
                dataType = "boolean";
            } else if (constantNode.initializer().kind() == SyntaxKind.NUMERIC_LITERAL) {
                if (((BasicLiteralNode)constantNode.initializer()).literalToken().kind().equals((Object)SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN)) {
                    dataType = "int";
                } else if (((BasicLiteralNode)constantNode.initializer()).literalToken().kind().equals((Object)SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN)) {
                    dataType = "float";
                }
            }
            type = new Type(dataType);
        }
        return new Constant(constantName, desc, descriptionSections, Generator.isDeprecated(constantNode.metadata()), type, value);
    }

    private static void addIntersectionTypeModel(IntersectionTypeDescriptorNode typeDescriptor, String typeName, Optional<MetadataNode> optionalMetadataNode, SemanticModel semanticModel, Module module) {
        boolean isReadonly;
        boolean bl = isReadonly = typeDescriptor.leftTypeDesc().kind() == SyntaxKind.READONLY_TYPE_DESC || typeDescriptor.rightTypeDesc().kind() == SyntaxKind.READONLY_TYPE_DESC;
        if (isReadonly) {
            Node typeDef;
            Node node = typeDef = typeDescriptor.leftTypeDesc().kind() == SyntaxKind.READONLY_TYPE_DESC ? typeDescriptor.rightTypeDesc() : typeDescriptor.leftTypeDesc();
            if (typeDef.kind() == SyntaxKind.RECORD_TYPE_DESC) {
                Record record = Generator.getRecordTypeModel((RecordTypeDescriptorNode)typeDef, typeName, optionalMetadataNode, semanticModel, module);
                record.isReadOnly = true;
                module.records.add(record);
                return;
            }
            if (typeDef.kind() == SyntaxKind.OBJECT_TYPE_DESC) {
                BObjectType bObj = Generator.getObjectTypeModel((ObjectTypeDescriptorNode)typeDef, typeName, optionalMetadataNode, semanticModel, module);
                bObj.isReadOnly = true;
                module.objectTypes.add(bObj);
                return;
            }
        }
        ArrayList<Type> memberTypes = new ArrayList<Type>();
        Type.addIntersectionMemberTypes((Node)typeDescriptor, semanticModel, memberTypes, module);
        BType bType = new BType(typeName, Generator.getDocFromMetadata(optionalMetadataNode), Generator.getDescSectionsDocFromMetaDataList(optionalMetadataNode), Generator.isDeprecated(optionalMetadataNode), memberTypes);
        bType.isIntersectionType = true;
        module.intersectionTypes.add(bType);
    }

    private static BType getTupleTypeModel(TupleTypeDescriptorNode typeDescriptor, String tupleTypeName, Optional<MetadataNode> optionalMetadataNode, SemanticModel semanticModel, Module module) {
        ArrayList<Type> memberTypes = new ArrayList<Type>();
        memberTypes.addAll(typeDescriptor.memberTypeDesc().stream().map(type -> Type.fromNode(type, semanticModel, module)).toList());
        BType bType = new BType(tupleTypeName, Generator.getDocFromMetadata(optionalMetadataNode), Generator.getDescSectionsDocFromMetaDataList(optionalMetadataNode), Generator.isDeprecated(optionalMetadataNode), memberTypes);
        bType.isTuple = true;
        return bType;
    }

    private static BType getTypeDescModel(ParameterizedTypeDescriptorNode typeDescriptor, String typeName, Optional<MetadataNode> optionalMetadataNode, SemanticModel semanticModel, Module module) {
        Type type = null;
        if (typeDescriptor.typeParamNode().isPresent()) {
            type = Type.fromNode((Node)((TypeParameterNode)typeDescriptor.typeParamNode().get()).typeNode(), semanticModel, module);
        }
        BType bType = new BType(typeName, Generator.getDocFromMetadata(optionalMetadataNode), Generator.getDescSectionsDocFromMetaDataList(optionalMetadataNode), Generator.isDeprecated(optionalMetadataNode), null);
        bType.isTypeDesc = true;
        bType.version = BallerinaDocGenerator.getBallerinaShortVersion();
        bType.elementType = type;
        return bType;
    }

    private static BType getUnionTypeModel(Node unionTypeDescriptor, String unionName, Optional<MetadataNode> optionalMetadataNode, SemanticModel semanticModel, Module module) {
        ArrayList<Type> memberTypes = new ArrayList<Type>();
        Type.addUnionMemberTypes(unionTypeDescriptor, semanticModel, memberTypes, module);
        BType bType = new BType(unionName, Generator.getDocFromMetadata(optionalMetadataNode), Generator.getDescSectionsDocFromMetaDataList(optionalMetadataNode), Generator.isDeprecated(optionalMetadataNode), memberTypes);
        bType.isAnonymousUnionType = true;
        return bType;
    }

    private static MapType getMapTypeModel(MapTypeDescriptorNode typeDescriptor, String typeName, Optional<MetadataNode> optionalMetadataNode, SemanticModel semanticModel, Module module) {
        Type type = typeDescriptor.mapTypeParamsNode().isMissing() ? null : Type.fromNode((Node)typeDescriptor, semanticModel, module);
        return new MapType(typeName, Generator.getDocFromMetadata(optionalMetadataNode), Generator.getDescSectionsDocFromMetaDataList(optionalMetadataNode), Generator.isDeprecated(optionalMetadataNode), type);
    }

    private static TableType getTableTypeModel(TableTypeDescriptorNode typeDescriptor, String typeName, Optional<MetadataNode> optionalMetadataNode, SemanticModel semanticModel, Module module) {
        Type rowParameterType = typeDescriptor.rowTypeParameterNode().isMissing() ? null : Type.fromNode((Node)typeDescriptor, semanticModel, module);
        Type keyConstraintType = typeDescriptor.keyConstraintNode().isEmpty() ? null : Type.fromNode((Node)typeDescriptor.keyConstraintNode().get(), semanticModel, module);
        return new TableType(typeName, Generator.getDocFromMetadata(optionalMetadataNode), Generator.getDescSectionsDocFromMetaDataList(optionalMetadataNode), Generator.isDeprecated(optionalMetadataNode), rowParameterType, keyConstraintType);
    }

    private static BClass getClassModel(ClassDefinitionNode classDefinitionNode, SemanticModel semanticModel, Module module) {
        ArrayList<Function> classFunctions = new ArrayList<Function>();
        ArrayList<Function> includedFunctions = new ArrayList<Function>();
        String name = classDefinitionNode.className().text();
        String description = Generator.getDocFromMetadata(classDefinitionNode.metadata());
        List<String> descriptionSections = Generator.getDescSectionsDocFromMetaDataList(classDefinitionNode.metadata());
        boolean isDeprecated = Generator.isDeprecated(classDefinitionNode.metadata());
        boolean isReadOnly = Generator.containsToken((NodeList<Token>)classDefinitionNode.classTypeQualifiers(), SyntaxKind.READONLY_KEYWORD);
        boolean isIsolated = Generator.containsToken((NodeList<Token>)classDefinitionNode.classTypeQualifiers(), SyntaxKind.ISOLATED_KEYWORD);
        boolean isService = Generator.containsToken((NodeList<Token>)classDefinitionNode.classTypeQualifiers(), SyntaxKind.SERVICE_KEYWORD);
        List<DefaultableVariable> fields = Generator.getDefaultableVariableList(classDefinitionNode.members(), classDefinitionNode.metadata(), semanticModel, module);
        for (Node member : classDefinitionNode.members()) {
            Type originType;
            if (member instanceof FunctionDefinitionNode && (Generator.containsToken((NodeList<Token>)((FunctionDefinitionNode)member).qualifierList(), SyntaxKind.PUBLIC_KEYWORD) || Generator.containsToken((NodeList<Token>)((FunctionDefinitionNode)member).qualifierList(), SyntaxKind.REMOTE_KEYWORD) || Generator.containsToken((NodeList<Token>)((FunctionDefinitionNode)member).qualifierList(), SyntaxKind.RESOURCE_KEYWORD))) {
                classFunctions.add(Generator.getFunctionModel((FunctionDefinitionNode)member, semanticModel, module));
                continue;
            }
            if (!(member instanceof TypeReferenceNode) || !((originType = Type.fromNode(member, semanticModel, module)) instanceof ObjectType)) continue;
            includedFunctions.addAll(Generator.mapFunctionTypesToFunctions(((ObjectType)originType).functionTypes, originType));
        }
        List<Function> functions = Stream.concat(includedFunctions.stream().filter(includedFunction -> classFunctions.stream().noneMatch(objFunction -> objFunction.name.equals(includedFunction.name))), classFunctions.stream()).toList();
        if (Generator.containsToken((NodeList<Token>)classDefinitionNode.classTypeQualifiers(), SyntaxKind.CLIENT_KEYWORD)) {
            return new Client(name, description, descriptionSections, isDeprecated, fields, functions, isReadOnly, isIsolated, isService);
        }
        if (Generator.containsToken((NodeList<Token>)classDefinitionNode.classTypeQualifiers(), SyntaxKind.LISTENER_KEYWORD) || Generator.isListenerModel(functions)) {
            return new Listener(name, description, descriptionSections, isDeprecated, fields, functions, isReadOnly, isIsolated, isService);
        }
        return new BClass(name, description, descriptionSections, isDeprecated, fields, functions, isReadOnly, isIsolated, isService);
    }

    private static boolean isListenerModel(List<Function> classFunctions) {
        boolean isStartIncluded = false;
        boolean isAttachIncluded = false;
        boolean isDetachIncluded = false;
        boolean isGracefulStopIncluded = false;
        boolean isImmediateStopIncluded = false;
        for (Function function : classFunctions) {
            if (function.name.equals(LISTENER_START_METHOD_NAME)) {
                isStartIncluded = true;
                continue;
            }
            if (function.name.equals(LISTENER_ATTACH_METHOD_NAME)) {
                isAttachIncluded = true;
                continue;
            }
            if (function.name.equals(LISTENER_DETACH_METHOD_NAME)) {
                isDetachIncluded = true;
                continue;
            }
            if (function.name.equals(LISTENER_GRACEFUL_STOP_METHOD_NAME)) {
                isGracefulStopIncluded = true;
                continue;
            }
            if (!function.name.equals(LISTENER_IMMEDIATE_STOP_METHOD_NAME)) continue;
            isImmediateStopIncluded = true;
        }
        return isStartIncluded && isAttachIncluded && isDetachIncluded && isGracefulStopIncluded && isImmediateStopIncluded;
    }

    private static BObjectType getObjectTypeModel(ObjectTypeDescriptorNode typeDescriptorNode, String objectName, Optional<MetadataNode> optionalMetadataNode, SemanticModel semanticModel, Module module) {
        ArrayList<Function> objectFunctions = new ArrayList<Function>();
        ArrayList<Function> includedFunctions = new ArrayList<Function>();
        String description = Generator.getDocFromMetadata(optionalMetadataNode);
        List<String> descriptionSections = Generator.getDescSectionsDocFromMetaDataList(optionalMetadataNode);
        boolean isDeprecated = Generator.isDeprecated(optionalMetadataNode);
        List<DefaultableVariable> fields = Generator.getDefaultableVariableList(typeDescriptorNode.members(), optionalMetadataNode, semanticModel, module);
        for (Node member : typeDescriptorNode.members()) {
            Type originType;
            if (member instanceof MethodDeclarationNode) {
                MethodDeclarationNode methodNode = (MethodDeclarationNode)member;
                if (!Generator.containsToken((NodeList<Token>)methodNode.qualifierList(), SyntaxKind.PUBLIC_KEYWORD) && !Generator.containsToken((NodeList<Token>)methodNode.qualifierList(), SyntaxKind.REMOTE_KEYWORD) && !Generator.containsToken((NodeList<Token>)methodNode.qualifierList(), SyntaxKind.RESOURCE_KEYWORD)) continue;
                String methodName = EMPTY_STRING;
                String accessor = EMPTY_STRING;
                String resourcePath = EMPTY_STRING;
                if (methodNode.kind() == SyntaxKind.RESOURCE_ACCESSOR_DECLARATION) {
                    accessor = methodNode.methodName().text();
                    resourcePath = methodNode.relativeResourcePath().stream().collect(StringBuilder::new, (firstString, secondString) -> firstString.append(secondString), (nodeA, nodeB) -> nodeA.append((CharSequence)nodeB)).toString();
                } else {
                    methodName = methodNode.methodName().text();
                }
                ArrayList<Variable> returnParams = new ArrayList<Variable>();
                FunctionSignatureNode methodSignature = methodNode.methodSignature();
                ArrayList<DefaultableVariable> parameters = new ArrayList<DefaultableVariable>(Generator.getDefaultableVariableList(methodSignature.parameters(), methodNode.metadata(), semanticModel, module));
                if (methodSignature.returnTypeDesc().isPresent()) {
                    ReturnTypeDescriptorNode returnType = (ReturnTypeDescriptorNode)methodSignature.returnTypeDesc().get();
                    Type type = Type.fromNode(returnType.type(), semanticModel, module);
                    returnParams.add(new Variable(EMPTY_STRING, Generator.getParameterDocFromMetadataList(RETURN_PARAM_NAME, methodNode.metadata()), false, type));
                }
                FunctionKind functionKind = Generator.containsToken((NodeList<Token>)methodNode.qualifierList(), SyntaxKind.REMOTE_KEYWORD) ? FunctionKind.REMOTE : (Generator.containsToken((NodeList<Token>)methodNode.qualifierList(), SyntaxKind.RESOURCE_KEYWORD) ? FunctionKind.RESOURCE : FunctionKind.OTHER);
                objectFunctions.add(new Function(methodName, accessor, resourcePath, Generator.getDocFromMetadata(methodNode.metadata()), Generator.getDescSectionsDocFromMetaDataList(methodNode.metadata()), functionKind, false, Generator.isDeprecated(methodNode.metadata()), Generator.containsToken((NodeList<Token>)methodNode.qualifierList(), SyntaxKind.ISOLATED_KEYWORD), parameters, returnParams));
                continue;
            }
            if (!(member instanceof TypeReferenceNode) || !((originType = Type.fromNode(member, semanticModel, module)) instanceof ObjectType)) continue;
            ObjectType objectType = (ObjectType)originType;
            includedFunctions.addAll(Generator.mapFunctionTypesToFunctions(objectType.functionTypes, originType));
        }
        List<Function> functions = Stream.concat(includedFunctions.stream().filter(includedFunction -> objectFunctions.stream().noneMatch(objFunction -> objFunction.name.equals(includedFunction.name))), objectFunctions.stream()).toList();
        return new BObjectType(objectName, description, descriptionSections, isDeprecated, fields, functions);
    }

    private static List<Function> mapFunctionTypesToFunctions(List<FunctionType> functionTypes, Type originType) {
        ArrayList<Function> functions = new ArrayList<Function>();
        for (FunctionType functionType : functionTypes) {
            ArrayList<DefaultableVariable> parameters = new ArrayList<DefaultableVariable>(functionType.paramTypes.stream().map(type -> new DefaultableVariable(type.name, type.description, false, type.elementType, EMPTY_STRING)).toList());
            ArrayList<Variable> returnParameters = new ArrayList<Variable>();
            if (functionType.returnType != null) {
                returnParameters.add(new Variable(EMPTY_STRING, functionType.returnType.description, functionType.returnType.isDeprecated, functionType.returnType));
            }
            Function function = new Function(functionType.name, functionType.accessor, functionType.resourcePath, functionType.description, functionType.descriptionSections, functionType.functionKind, functionType.isExtern, functionType.isDeprecated, functionType.isIsolated, parameters, returnParameters);
            function.inclusionType = originType.isPublic ? originType : null;
            functions.add(function);
        }
        return functions;
    }

    private static Function getFunctionModel(FunctionDefinitionNode functionDefinitionNode, SemanticModel semanticModel, Module module) {
        String functionName = EMPTY_STRING;
        String accessor = EMPTY_STRING;
        String resourcePath = EMPTY_STRING;
        if (functionDefinitionNode.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) {
            accessor = functionDefinitionNode.functionName().text();
            resourcePath = functionDefinitionNode.relativeResourcePath().stream().collect(StringBuilder::new, (firstString, secondString) -> firstString.append(secondString), (nodeA, nodeB) -> nodeA.append((CharSequence)nodeB)).toString();
        } else {
            functionName = functionDefinitionNode.functionName().text();
        }
        ArrayList<DefaultableVariable> parameters = new ArrayList<DefaultableVariable>();
        ArrayList<Variable> returnParams = new ArrayList<Variable>();
        FunctionSignatureNode functionSignature = functionDefinitionNode.functionSignature();
        parameters.addAll(Generator.getDefaultableVariableList(functionSignature.parameters(), functionDefinitionNode.metadata(), semanticModel, module));
        List<AnnotationAttachment> annotationAttachments = Generator.extractAnnotationAttachmentsFromMetadataNode(semanticModel, functionDefinitionNode.metadata());
        if (functionSignature.returnTypeDesc().isPresent()) {
            ReturnTypeDescriptorNode returnType = (ReturnTypeDescriptorNode)functionSignature.returnTypeDesc().get();
            Type type = Type.fromNode(returnType.type(), semanticModel, module);
            returnParams.add(new Variable(EMPTY_STRING, Generator.getParameterDocFromMetadataList(RETURN_PARAM_NAME, functionDefinitionNode.metadata()), false, type));
        }
        boolean isExtern = functionDefinitionNode.functionBody() instanceof ExternalFunctionBodyNode;
        FunctionKind functionKind = Generator.containsToken((NodeList<Token>)functionDefinitionNode.qualifierList(), SyntaxKind.REMOTE_KEYWORD) ? FunctionKind.REMOTE : (Generator.containsToken((NodeList<Token>)functionDefinitionNode.qualifierList(), SyntaxKind.RESOURCE_KEYWORD) ? FunctionKind.RESOURCE : FunctionKind.OTHER);
        return new Function(functionName, accessor, resourcePath, Generator.getDocFromMetadata(functionDefinitionNode.metadata()), Generator.getDescSectionsDocFromMetaDataList(functionDefinitionNode.metadata()), functionKind, isExtern, Generator.isDeprecated(functionDefinitionNode.metadata()), Generator.containsToken((NodeList<Token>)functionDefinitionNode.qualifierList(), SyntaxKind.ISOLATED_KEYWORD), parameters, returnParams, annotationAttachments);
    }

    private static Record getRecordTypeModel(RecordTypeDescriptorNode recordTypeDesc, String recordName, Optional<MetadataNode> optionalMetadataNode, SemanticModel semanticModel, Module module) {
        List<DefaultableVariable> fields = Generator.getDefaultableVariableList(recordTypeDesc.fields(), optionalMetadataNode, semanticModel, module);
        boolean isClosed = recordTypeDesc.bodyStartDelimiter().kind().equals((Object)SyntaxKind.OPEN_BRACE_PIPE_TOKEN);
        if (recordTypeDesc.recordRestDescriptor().isPresent()) {
            isClosed = false;
            DefaultableVariable restVariable = new DefaultableVariable(EMPTY_STRING, REST_FIELD_DESCRIPTION, false, Type.fromNode((Node)recordTypeDesc.recordRestDescriptor().get(), semanticModel, module), EMPTY_STRING);
            fields.add(restVariable);
        }
        return new Record(recordName, Generator.getDocFromMetadata(optionalMetadataNode), Generator.getDescSectionsDocFromMetaDataList(optionalMetadataNode), Generator.isDeprecated(optionalMetadataNode), isClosed, fields);
    }

    public static List<DefaultableVariable> getDefaultableVariableList(NodeList<?> nodeList, Optional<MetadataNode> optionalMetadataNode, SemanticModel semanticModel, Module module) {
        ArrayList<DefaultableVariable> variables = new ArrayList<DefaultableVariable>();
        for (int i = 0; i < nodeList.size(); ++i) {
            Type type2;
            String paramName;
            DefaultableVariable defaultableVariable;
            Type type3;
            String defaultValue;
            String doc;
            String name;
            Node node = nodeList.get(i);
            if (node instanceof RecordFieldWithDefaultValueNode) {
                RecordFieldWithDefaultValueNode recordField = (RecordFieldWithDefaultValueNode)node;
                name = recordField.fieldName().text();
                doc = Generator.getDocFromMetadata(recordField.metadata());
                if (doc.isEmpty()) {
                    doc = Generator.getParameterDocFromMetadataList(name, optionalMetadataNode);
                }
                defaultValue = recordField.expression().toString();
                type3 = Type.fromNode(recordField.typeName(), semanticModel, module);
                defaultableVariable = new DefaultableVariable(name, doc, false, type3, defaultValue, Generator.extractAnnotationAttachmentsFromMetadataNode(semanticModel, recordField.metadata()));
                if (recordField.readonlyKeyword().isPresent()) {
                    defaultableVariable.isReadOnly = true;
                }
                variables.add(defaultableVariable);
                continue;
            }
            if (node instanceof RecordFieldNode) {
                RecordFieldNode recordField = (RecordFieldNode)node;
                name = recordField.fieldName().text();
                doc = Generator.getDocFromMetadata(recordField.metadata());
                if (doc.isEmpty()) {
                    doc = Generator.getParameterDocFromMetadataList(name, optionalMetadataNode);
                }
                Type type4 = Type.fromNode(recordField.typeName(), semanticModel, module);
                type4.isOptional = recordField.questionMarkToken().isPresent();
                DefaultableVariable defaultableVariable2 = new DefaultableVariable(name, doc, Generator.isDeprecated(recordField.metadata()), type4, EMPTY_STRING, Generator.extractAnnotationAttachmentsFromMetadataNode(semanticModel, recordField.metadata()));
                if (recordField.readonlyKeyword().isPresent()) {
                    defaultableVariable2.isReadOnly = true;
                }
                variables.add(defaultableVariable2);
                continue;
            }
            if (node instanceof TypeReferenceNode) {
                Type originType = Type.fromNode(node, semanticModel, module);
                if (!originType.isPublic) {
                    variables.addAll(originType.memberTypes.stream().map(type -> new DefaultableVariable(type.name, type.description, false, type.elementType, EMPTY_STRING)).toList());
                    continue;
                }
                if (originType.memberTypes.isEmpty()) continue;
                variables.add(new DefaultableVariable(originType));
                continue;
            }
            if (node instanceof ObjectFieldNode) {
                ObjectFieldNode objectField = (ObjectFieldNode)node;
                if (!objectField.visibilityQualifier().isPresent() || !((Token)objectField.visibilityQualifier().get()).kind().equals((Object)SyntaxKind.PUBLIC_KEYWORD)) continue;
                name = objectField.fieldName().text();
                doc = Generator.getDocFromMetadata(objectField.metadata());
                if (doc.isEmpty()) {
                    doc = Generator.getParameterDocFromMetadataList(name, optionalMetadataNode);
                }
                defaultValue = objectField.expression().isPresent() ? ((ExpressionNode)objectField.expression().get()).toString() : EMPTY_STRING;
                type3 = Type.fromNode(objectField.typeName(), semanticModel, module);
                defaultableVariable = new DefaultableVariable(name, doc, Generator.isDeprecated(objectField.metadata()), type3, defaultValue, Generator.extractAnnotationAttachmentsFromMetadataNode(semanticModel, objectField.metadata()));
                variables.add(defaultableVariable);
                continue;
            }
            if (node instanceof RequiredParameterNode) {
                RequiredParameterNode requiredParameter = (RequiredParameterNode)node;
                paramName = requiredParameter.paramName().isPresent() ? ((Token)requiredParameter.paramName().get()).text() : EMPTY_STRING;
                type2 = Type.fromNode(requiredParameter.typeName(), semanticModel, module);
                variables.add(new DefaultableVariable(paramName, Generator.getParameterDocFromMetadataList(paramName, optionalMetadataNode), Generator.isDeprecated((NodeList<AnnotationNode>)requiredParameter.annotations()), type2, EMPTY_STRING));
                continue;
            }
            if (node instanceof DefaultableParameterNode) {
                DefaultableParameterNode defaultableParameter = (DefaultableParameterNode)node;
                paramName = defaultableParameter.paramName().isPresent() ? ((Token)defaultableParameter.paramName().get()).text() : EMPTY_STRING;
                type2 = Type.fromNode(defaultableParameter.typeName(), semanticModel, module);
                variables.add(new DefaultableVariable(paramName, Generator.getParameterDocFromMetadataList(paramName, optionalMetadataNode), Generator.isDeprecated((NodeList<AnnotationNode>)defaultableParameter.annotations()), type2, defaultableParameter.expression().toString(), Generator.extractAnnotationAttachmentsFromAnnotations(semanticModel, (NodeList<AnnotationNode>)defaultableParameter.annotations())));
                continue;
            }
            if (node instanceof RestParameterNode) {
                RestParameterNode restParameter = (RestParameterNode)node;
                paramName = restParameter.paramName().isPresent() ? ((Token)restParameter.paramName().get()).text() : EMPTY_STRING;
                type2 = new Type(paramName);
                type2.isRestParam = true;
                type2.elementType = Type.fromNode(restParameter.typeName(), semanticModel, module);
                variables.add(new DefaultableVariable(paramName, Generator.getParameterDocFromMetadataList(paramName, optionalMetadataNode), false, type2, EMPTY_STRING));
                continue;
            }
            if (!(node instanceof IncludedRecordParameterNode)) continue;
            IncludedRecordParameterNode includedRecord = (IncludedRecordParameterNode)node;
            paramName = includedRecord.paramName().isPresent() ? ((Token)includedRecord.paramName().get()).text() : EMPTY_STRING;
            type2 = Type.fromNode(includedRecord.typeName(), semanticModel, module);
            type2.isInclusion = true;
            variables.add(new DefaultableVariable(paramName, Generator.getParameterDocFromMetadataList(paramName, optionalMetadataNode), false, type2, EMPTY_STRING));
        }
        return variables;
    }

    private static List<AnnotationAttachment> extractAnnotationAttachmentsFromMetadataNode(SemanticModel semanticModel, Optional<MetadataNode> metadata) {
        ArrayList<AnnotationAttachment> annotationAttachments = new ArrayList<AnnotationAttachment>();
        metadata.ifPresent(metadataNode -> metadataNode.annotations().forEach(annotationNode -> {
            Symbol symbol = semanticModel.symbol((Node)annotationNode).orElse(null);
            if (symbol == null) {
                return;
            }
            ModuleID id = ((ModuleSymbol)symbol.getModule().get()).id();
            annotationAttachments.add(new AnnotationAttachment(symbol.getName().orElse(EMPTY_STRING), EMPTY_STRING, null, false, id.orgName(), id.moduleName(), id.version()));
        }));
        return annotationAttachments;
    }

    private static List<AnnotationAttachment> extractAnnotationAttachmentsFromAnnotations(SemanticModel semanticModel, NodeList<AnnotationNode> annotations) {
        ArrayList<AnnotationAttachment> annotationAttachments = new ArrayList<AnnotationAttachment>();
        annotations.forEach(annotationNode -> {
            Symbol symbol = semanticModel.symbol((Node)annotationNode).orElse(null);
            if (symbol == null) {
                return;
            }
            ModuleID id = ((ModuleSymbol)symbol.getModule().get()).id();
            annotationAttachments.add(new AnnotationAttachment(symbol.getName().orElse(EMPTY_STRING), EMPTY_STRING, null, false, id.orgName(), id.moduleName(), id.version()));
        });
        return annotationAttachments;
    }

    private static boolean isTypePramOrBuiltinSubtype(Optional<MetadataNode> metadataNode) {
        if (metadataNode.isEmpty()) {
            return false;
        }
        return metadataNode.get().annotations().stream().anyMatch(annotationNode -> annotationNode.toString().contains("@typeParam") || annotationNode.toString().contains("@builtinSubtype"));
    }

    private static boolean isDeprecated(NodeList<AnnotationNode> annotations) {
        for (AnnotationNode annotationNode : annotations) {
            if (!annotationNode.toString().contains("@deprecated")) continue;
            return true;
        }
        return false;
    }

    private static boolean isDeprecated(Optional<MetadataNode> metadataNode) {
        if (!metadataNode.isPresent()) {
            return false;
        }
        MetadataNode metaData = metadataNode.get();
        for (AnnotationNode annotationNode : metaData.annotations()) {
            if (!annotationNode.toString().contains("@deprecated")) continue;
            return true;
        }
        return false;
    }

    private static String getDocFromMetadata(Optional<MetadataNode> optionalMetadataNode) {
        MarkdownDocumentationNode docLines;
        if (optionalMetadataNode.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder doc = new StringBuilder();
        MarkdownDocumentationNode markdownDocumentationNode = docLines = optionalMetadataNode.get().documentationString().isPresent() ? (MarkdownDocumentationNode)optionalMetadataNode.get().documentationString().get() : null;
        if (docLines != null) {
            for (Node docLine : docLines.documentationLines()) {
                if (docLine instanceof MarkdownDocumentationLineNode) {
                    MarkdownDocumentationLineNode markdownDocLine = (MarkdownDocumentationLineNode)docLine;
                    String docLineString = Generator.getDocLineString((NodeList<Node>)markdownDocLine.documentElements());
                    if (docLineString.startsWith(DOC_HEADER_PREFIX)) break;
                    doc.append(!markdownDocLine.documentElements().isEmpty() ? Generator.getDocLineString((NodeList<Node>)markdownDocLine.documentElements()) : "\n");
                    continue;
                }
                if (!(docLine instanceof MarkdownCodeBlockNode)) break;
                MarkdownCodeBlockNode markdownCodeBlock = (MarkdownCodeBlockNode)docLine;
                doc.append(Generator.getDocCodeBlockString(markdownCodeBlock));
            }
        }
        return doc.toString();
    }

    private static String getParameterDocFromMetadataList(String parameterName, Optional<MetadataNode> optionalMetadataNode) {
        if (optionalMetadataNode.isEmpty()) {
            return EMPTY_STRING;
        }
        MarkdownDocumentationNode docLines = optionalMetadataNode.get().documentationString().isPresent() ? (MarkdownDocumentationNode)optionalMetadataNode.get().documentationString().get() : null;
        StringBuilder parameterDoc = new StringBuilder();
        if (docLines != null) {
            boolean lookForMoreLines = false;
            for (Node docLine : docLines.documentationLines()) {
                if (docLine instanceof MarkdownParameterDocumentationLineNode) {
                    MarkdownParameterDocumentationLineNode markdownParamDocLine = (MarkdownParameterDocumentationLineNode)docLine;
                    if (markdownParamDocLine.parameterName().text().equals(parameterName)) {
                        parameterDoc.append(Generator.getDocLineString((NodeList<Node>)markdownParamDocLine.documentElements()));
                        lookForMoreLines = true;
                        continue;
                    }
                    lookForMoreLines = false;
                    continue;
                }
                if (!lookForMoreLines || !(docLine instanceof MarkdownDocumentationLineNode)) continue;
                MarkdownDocumentationLineNode markdownDocLine = (MarkdownDocumentationLineNode)docLine;
                String docLineString = Generator.getDocLineString((NodeList<Node>)markdownDocLine.documentElements());
                if (!docLineString.isEmpty()) {
                    parameterDoc.append(docLineString);
                    continue;
                }
                lookForMoreLines = false;
            }
        }
        return parameterDoc.toString();
    }

    private static List<String> getDescSectionsDocFromMetaDataList(Optional<MetadataNode> optionalMetadataNode) {
        MarkdownDocumentationNode docLines;
        if (optionalMetadataNode.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> descSections = new ArrayList<String>();
        MarkdownDocumentationNode markdownDocumentationNode = docLines = optionalMetadataNode.get().documentationString().isPresent() ? (MarkdownDocumentationNode)optionalMetadataNode.get().documentationString().get() : null;
        if (docLines != null) {
            StringBuilder sectionDoc = new StringBuilder();
            boolean lookForMoreLines = false;
            for (Node docLine : docLines.documentationLines()) {
                if (docLine instanceof MarkdownDocumentationLineNode) {
                    MarkdownDocumentationLineNode markdownDocLine = (MarkdownDocumentationLineNode)docLine;
                    String docLineString = Generator.getDocLineString((NodeList<Node>)markdownDocLine.documentElements());
                    if (!docLineString.isEmpty()) {
                        if (docLineString.startsWith(DOC_HEADER_PREFIX)) {
                            sectionDoc = new StringBuilder();
                            sectionDoc.append(docLineString);
                            lookForMoreLines = true;
                            continue;
                        }
                        if (!lookForMoreLines) continue;
                        sectionDoc.append(docLineString);
                        continue;
                    }
                    if (sectionDoc != null && !sectionDoc.toString().isEmpty()) {
                        descSections.add(sectionDoc.toString());
                        sectionDoc = null;
                    }
                    lookForMoreLines = false;
                    continue;
                }
                if (sectionDoc != null && !sectionDoc.toString().isEmpty()) {
                    descSections.add(sectionDoc.toString());
                    sectionDoc = null;
                }
                lookForMoreLines = false;
            }
            if (sectionDoc != null && !sectionDoc.toString().isEmpty()) {
                descSections.add(sectionDoc.toString());
            }
        }
        return descSections;
    }

    private static String getDocLineString(NodeList<Node> documentElements) {
        if (documentElements.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder doc = new StringBuilder();
        for (Node docNode : documentElements) {
            doc.append(docNode.toString());
        }
        return doc.toString();
    }

    private static String getDocCodeBlockString(MarkdownCodeBlockNode markdownCodeBlockNode) {
        StringBuilder doc = new StringBuilder();
        doc.append(markdownCodeBlockNode.startBacktick().toString());
        markdownCodeBlockNode.langAttribute().ifPresent(langAttribute -> doc.append(langAttribute));
        for (MarkdownCodeLineNode codeLineNode : markdownCodeBlockNode.codeLines()) {
            doc.append(codeLineNode.codeDescription().toString());
        }
        doc.append(markdownCodeBlockNode.endBacktick().toString());
        return doc.toString();
    }
}

